#define LINCFG_C
/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     lincfg.c                
*														                            
* Revision:      										                    
*														                            
* Functions:    LIN Driver internal configuration
*												                            
* Description:  
*
* Notes:        This file is NOT allowed to modify by user
*
******************************************************************************/

#include "linapi.h"

/********************************************************************************************/
/********************************************************************************************/
/**     Driver hardware configuration                                                      **/
/********************************************************************************************/
/********************************************************************************************/
#if defined(MASTER)	
#if (!((LIN_TO_WAKEUPDEL >= 4) & (LIN_TO_WAKEUPDEL <= 64)))
#warning "The wake up delimiter is out of range. Therefore the wake up delimiter will be set to 4"
#undef  LIN_TO_WAKEUPDEL
#define LIN_TO_WAKEUPDEL        4
#endif /* (!((LIN_TO_WAKEUPDEL >= 4) & (LIN_TO_WAKEUPDEL <= 64))) */
#endif /* defined(MASTER) */	

/* LIN baud rate masks */
#define LIN_BAUDRATE_MASK       0x1FFFu

/* For BaseRam and BaseReg shifting */
#define LIN_INITREG_SHIFT       8u

/* Mask for INITRM register */
#if defined(C32)
/* NB: Bit0 will be clear, so The 12K RAM is aligned to the bottom of the 16K page ($0000) */
#define LIN_INITRM_MASK         0xF8u
#endif /* defined(C32) */

/* Mask for INITRG register */
#if defined(C32)
#define LIN_INITRG_MASK         0x78u
#endif /* defined(C32) */

const struct
{
    unsigned char   LIN_BaseRam;        /* RAM base address */
    unsigned char   LIN_BaseReg;        /* I/O registers base address */
    unsigned int    LIN_IdleTimeoutClocks;  /* number of LIN_IdleClock() calls per LIN idle timeout */
    unsigned int    LIN_BaudRate;       /* LIN baud rate setting */
#if defined(MASTER)
    unsigned char   LIN_to_wakeup_delimiter; /* Tbit wake up  delimiter */
    unsigned int    LIN_BreakBaudRate;  /* baud rate to send Break symbol (10 bit time -> 13 bit time) */
    unsigned char   LIN_TimerPrescaler; /* timer prescaler */
#endif /* defined(MASTER) */
} LIN_CfgConst =
{
    ((_BASERAM >> LIN_INITREG_SHIFT) & LIN_INITRM_MASK),
    ((_BASEREG >> LIN_INITREG_SHIFT) & LIN_INITRG_MASK),
    LIN_IDLETIMEOUT,
    (LIN_BAUDRATE & LIN_BAUDRATE_MASK),
#if defined(MASTER)
    LIN_TO_WAKEUPDEL,
    (unsigned int)(((unsigned int)(LIN_BAUDRATE * 1.5 )) & LIN_BAUDRATE_MASK ),
    LIN_TIMERPRESCALER,
#endif /* defined(MASTER) */
};
#if defined(MASTER)

/********************************************************************************************/
/********************************************************************************************/
/**     Timeout module constants calculation                                               **/
/********************************************************************************************/
/********************************************************************************************/

#define LIN_MAXTOCOUNTER 0xFFFFul       /* maximal allowed timer 16-bit counter value */
                                        /* it must be long for correct computation */

/********************************************************************************************/
/* Wakeup Delimiter                                                                         */
/********************************************************************************************/
#define LIN_WKUPDELLEN_TO   10ul

    /* dividers set */
#define LIN_TO9DIVIDER1     1ul
#define LIN_TO9DIVIDER2     2ul
#define LIN_TO9DIVIDER3     5ul
#define LIN_TO9DIVIDER4     10ul
    
    /* maximal integral divider search */
#if   ((LIN_WKUPDELLEN_TO / LIN_TO9DIVIDER1) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO9DIVIDER LIN_TO9DIVIDER1
#elif ((LIN_WKUPDELLEN_TO / LIN_TO9DIVIDER2) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO9DIVIDER LIN_TO9DIVIDER2
#elif ((LIN_WKUPDELLEN_TO / LIN_TO9DIVIDER3) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO9DIVIDER LIN_TO9DIVIDER3
#elif ((LIN_WKUPDELLEN_TO / LIN_TO9DIVIDER4) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO9DIVIDER LIN_TO9DIVIDER4
#endif

/********************************************************************************************/
/* MaxFrame Timeout module constants calculation                                            */
/*      Nmax = (10 * Ndata + 45) * 1.4                                                      */
/*      Tmax = Nmax - 15                                                                    */
/*          for S12: Nmax - 15                                                             */
/********************************************************************************************/

/********************************************************************************************/
/* 1 byte:      77 - 15 = 62                                                                */
/********************************************************************************************/
#define LIN_MAXFRAME_1_TIMEOUT  62ul
                                        
    /* dividers set */
#define LIN_TO1DIVIDER1 1ul
#define LIN_TO1DIVIDER2 2ul
#define LIN_TO1DIVIDER3 31ul
#define LIN_TO1DIVIDER4 62ul

    /* maximal integral divider search */
#if   ((LIN_MAXFRAME_1_TIMEOUT / LIN_TO1DIVIDER1) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO1DIVIDER LIN_TO1DIVIDER1
#elif ((LIN_MAXFRAME_1_TIMEOUT / LIN_TO1DIVIDER2) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO1DIVIDER LIN_TO1DIVIDER2
#elif ((LIN_MAXFRAME_1_TIMEOUT / LIN_TO1DIVIDER3) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO1DIVIDER LIN_TO1DIVIDER3
#elif ((LIN_MAXFRAME_1_TIMEOUT / LIN_TO1DIVIDER4) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO1DIVIDER LIN_TO1DIVIDER4
#endif

/********************************************************************************************/
/* 2 bytes:     91 - 15 = 76                                                                */
/********************************************************************************************/
#define LIN_MAXFRAME_2_TIMEOUT  76ul
                                        
    /* dividers set */
#define LIN_TO2DIVIDER1 1ul
#define LIN_TO2DIVIDER2 2ul
#define LIN_TO2DIVIDER3 4ul
#define LIN_TO2DIVIDER4 19ul
#define LIN_TO2DIVIDER5 38ul
#define LIN_TO2DIVIDER6 76ul

    /* maximal integral divider search */
#if   ((LIN_MAXFRAME_2_TIMEOUT / LIN_TO2DIVIDER1) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO2DIVIDER LIN_TO2DIVIDER1
#elif ((LIN_MAXFRAME_2_TIMEOUT / LIN_TO2DIVIDER2) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO2DIVIDER LIN_TO2DIVIDER2
#elif ((LIN_MAXFRAME_2_TIMEOUT / LIN_TO2DIVIDER3) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO2DIVIDER LIN_TO2DIVIDER3
#elif ((LIN_MAXFRAME_2_TIMEOUT / LIN_TO2DIVIDER4) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO2DIVIDER LIN_TO2DIVIDER4
#elif ((LIN_MAXFRAME_2_TIMEOUT / LIN_TO2DIVIDER5) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO2DIVIDER LIN_TO2DIVIDER5
#elif ((LIN_MAXFRAME_2_TIMEOUT / LIN_TO2DIVIDER6) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO2DIVIDER LIN_TO2DIVIDER6
#endif

/********************************************************************************************/
/* 3 bytes:     105 - 15 = 90                                                               */
/********************************************************************************************/
#define LIN_MAXFRAME_3_TIMEOUT  90ul
                                        
    /* dividers set */
#define LIN_TO3DIVIDER1 1ul
#define LIN_TO3DIVIDER2 2ul
#define LIN_TO3DIVIDER3 3ul
#define LIN_TO3DIVIDER4 5ul
#define LIN_TO3DIVIDER5 6ul
#define LIN_TO3DIVIDER6 9ul
#define LIN_TO3DIVIDER7 10ul
#define LIN_TO3DIVIDER8 15ul
#define LIN_TO3DIVIDER9 18ul
#define LIN_TO3DIVIDER10 30ul
#define LIN_TO3DIVIDER11 45ul
#define LIN_TO3DIVIDER12 90ul

    /* maximal integral divider search */
#if   ((LIN_MAXFRAME_3_TIMEOUT / LIN_TO3DIVIDER1) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO3DIVIDER LIN_TO3DIVIDER1
#elif ((LIN_MAXFRAME_3_TIMEOUT / LIN_TO3DIVIDER2) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO3DIVIDER LIN_TO3DIVIDER2
#elif ((LIN_MAXFRAME_3_TIMEOUT / LIN_TO3DIVIDER3) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO3DIVIDER LIN_TO3DIVIDER3
#elif ((LIN_MAXFRAME_3_TIMEOUT / LIN_TO3DIVIDER4) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO3DIVIDER LIN_TO3DIVIDER4
#elif ((LIN_MAXFRAME_3_TIMEOUT / LIN_TO3DIVIDER5) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO3DIVIDER LIN_TO3DIVIDER5
#elif ((LIN_MAXFRAME_3_TIMEOUT / LIN_TO3DIVIDER6) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO3DIVIDER LIN_TO3DIVIDER6
#elif ((LIN_MAXFRAME_3_TIMEOUT / LIN_TO3DIVIDER7) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO3DIVIDER LIN_TO3DIVIDER7
#elif ((LIN_MAXFRAME_3_TIMEOUT / LIN_TO3DIVIDER8) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO3DIVIDER LIN_TO3DIVIDER8
#elif ((LIN_MAXFRAME_3_TIMEOUT / LIN_TO3DIVIDER9) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO3DIVIDER LIN_TO3DIVIDER9
#elif ((LIN_MAXFRAME_3_TIMEOUT / LIN_TO3DIVIDER10) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO3DIVIDER LIN_TO3DIVIDER10
#elif ((LIN_MAXFRAME_3_TIMEOUT / LIN_TO3DIVIDER11) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO3DIVIDER LIN_TO3DIVIDER11
#elif ((LIN_MAXFRAME_3_TIMEOUT / LIN_TO3DIVIDER12) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO3DIVIDER LIN_TO3DIVIDER12
#endif

/********************************************************************************************/
/* 4 bytes:     119 - 15 = 104                                                              */
/********************************************************************************************/
#define LIN_MAXFRAME_4_TIMEOUT  104ul
                                        
    /* dividers set */
#define LIN_TO4DIVIDER1 1ul
#define LIN_TO4DIVIDER2 2ul
#define LIN_TO4DIVIDER3 4ul
#define LIN_TO4DIVIDER4 8ul
#define LIN_TO4DIVIDER5 13ul
#define LIN_TO4DIVIDER6 26ul
#define LIN_TO4DIVIDER7 52ul
#define LIN_TO4DIVIDER8 104ul

    /* maximal integral divider search */
#if   ((LIN_MAXFRAME_4_TIMEOUT / LIN_TO4DIVIDER1) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO4DIVIDER LIN_TO4DIVIDER1
#elif ((LIN_MAXFRAME_4_TIMEOUT / LIN_TO4DIVIDER2) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO4DIVIDER LIN_TO4DIVIDER2
#elif ((LIN_MAXFRAME_4_TIMEOUT / LIN_TO4DIVIDER3) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO4DIVIDER LIN_TO4DIVIDER3
#elif ((LIN_MAXFRAME_4_TIMEOUT / LIN_TO4DIVIDER4) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO4DIVIDER LIN_TO4DIVIDER4
#elif ((LIN_MAXFRAME_4_TIMEOUT / LIN_TO4DIVIDER5) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO4DIVIDER LIN_TO4DIVIDER5
#elif ((LIN_MAXFRAME_4_TIMEOUT / LIN_TO4DIVIDER6) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO4DIVIDER LIN_TO4DIVIDER6
#elif ((LIN_MAXFRAME_4_TIMEOUT / LIN_TO4DIVIDER7) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO4DIVIDER LIN_TO4DIVIDER7
#elif ((LIN_MAXFRAME_4_TIMEOUT / LIN_TO4DIVIDER8) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO4DIVIDER LIN_TO4DIVIDER8
#endif

/********************************************************************************************/
/* 5 bytes:     133 - 15 = 118                                                              */
/********************************************************************************************/
#define LIN_MAXFRAME_5_TIMEOUT  118ul
                                        
    /* dividers set */
#define LIN_TO5DIVIDER1 1ul
#define LIN_TO5DIVIDER2 2ul
#define LIN_TO5DIVIDER3 59ul
#define LIN_TO5DIVIDER4 118ul

    /* maximal integral divider search */
#if   ((LIN_MAXFRAME_5_TIMEOUT / LIN_TO5DIVIDER1) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO5DIVIDER LIN_TO5DIVIDER1
#elif ((LIN_MAXFRAME_5_TIMEOUT / LIN_TO5DIVIDER2) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO5DIVIDER LIN_TO5DIVIDER2
#elif ((LIN_MAXFRAME_5_TIMEOUT / LIN_TO5DIVIDER3) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO5DIVIDER LIN_TO5DIVIDER3
#elif ((LIN_MAXFRAME_5_TIMEOUT / LIN_TO5DIVIDER4) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO5DIVIDER LIN_TO5DIVIDER4
#endif

/********************************************************************************************/
/* 6 bytes:     147 - 15 = 132                                                              */
/********************************************************************************************/
#define LIN_MAXFRAME_6_TIMEOUT  132ul
                                        
    /* dividers set */
#define LIN_TO6DIVIDER1 1ul
#define LIN_TO6DIVIDER2 2ul
#define LIN_TO6DIVIDER3 3ul
#define LIN_TO6DIVIDER4 4ul
#define LIN_TO6DIVIDER5 6ul
#define LIN_TO6DIVIDER6 11ul
#define LIN_TO6DIVIDER7 12ul
#define LIN_TO6DIVIDER8 22ul
#define LIN_TO6DIVIDER9 33ul
#define LIN_TO6DIVIDER10 44ul
#define LIN_TO6DIVIDER11 66ul
#define LIN_TO6DIVIDER12 132ul

    /* maximal integral divider search */
#if   ((LIN_MAXFRAME_6_TIMEOUT / LIN_TO6DIVIDER1) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO6DIVIDER LIN_TO6DIVIDER1
#elif ((LIN_MAXFRAME_6_TIMEOUT / LIN_TO6DIVIDER2) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO6DIVIDER LIN_TO6DIVIDER2
#elif ((LIN_MAXFRAME_6_TIMEOUT / LIN_TO6DIVIDER3) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO6DIVIDER LIN_TO6DIVIDER3
#elif ((LIN_MAXFRAME_6_TIMEOUT / LIN_TO6DIVIDER4) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO6DIVIDER LIN_TO6DIVIDER4
#elif ((LIN_MAXFRAME_6_TIMEOUT / LIN_TO6DIVIDER5) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO6DIVIDER LIN_TO6DIVIDER5
#elif ((LIN_MAXFRAME_6_TIMEOUT / LIN_TO6DIVIDER6) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO6DIVIDER LIN_TO6DIVIDER6
#elif ((LIN_MAXFRAME_6_TIMEOUT / LIN_TO6DIVIDER7) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO6DIVIDER LIN_TO6DIVIDER7
#elif ((LIN_MAXFRAME_6_TIMEOUT / LIN_TO6DIVIDER8) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO6DIVIDER LIN_TO6DIVIDER8
#elif ((LIN_MAXFRAME_6_TIMEOUT / LIN_TO6DIVIDER9) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO6DIVIDER LIN_TO6DIVIDER9
#elif ((LIN_MAXFRAME_6_TIMEOUT / LIN_TO6DIVIDER10) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO6DIVIDER LIN_TO6DIVIDER10
#elif ((LIN_MAXFRAME_6_TIMEOUT / LIN_TO6DIVIDER11) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO6DIVIDER LIN_TO6DIVIDER11
#elif ((LIN_MAXFRAME_6_TIMEOUT / LIN_TO6DIVIDER12) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO6DIVIDER LIN_TO6DIVIDER12
#endif

/********************************************************************************************/
/* 7 bytes:     161 - 15 = 146                                                              */
/********************************************************************************************/
#define LIN_MAXFRAME_7_TIMEOUT  146ul
                                        
    /* dividers set */
#define LIN_TO7DIVIDER1 1ul
#define LIN_TO7DIVIDER2 2ul
#define LIN_TO7DIVIDER3 73ul
#define LIN_TO7DIVIDER4 146ul

    /* maximal integral divider search */
#if   ((LIN_MAXFRAME_7_TIMEOUT / LIN_TO7DIVIDER1) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO7DIVIDER LIN_TO7DIVIDER1
#elif ((LIN_MAXFRAME_7_TIMEOUT / LIN_TO7DIVIDER2) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO7DIVIDER LIN_TO7DIVIDER2
#elif ((LIN_MAXFRAME_7_TIMEOUT / LIN_TO7DIVIDER3) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO7DIVIDER LIN_TO7DIVIDER3
#elif ((LIN_MAXFRAME_7_TIMEOUT / LIN_TO7DIVIDER4) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO7DIVIDER LIN_TO7DIVIDER4
#endif

/********************************************************************************************/
/* 8 bytes:     175 - 15 = 160                                                              */
/********************************************************************************************/
#define LIN_MAXFRAME_8_TIMEOUT  160ul
                                        
    /* dividers set */
#define LIN_TO8DIVIDER1 1ul
#define LIN_TO8DIVIDER2 2ul
#define LIN_TO8DIVIDER3 4ul
#define LIN_TO8DIVIDER4 5ul
#define LIN_TO8DIVIDER5 8ul
#define LIN_TO8DIVIDER6 10ul
#define LIN_TO8DIVIDER7 16ul
#define LIN_TO8DIVIDER8 20ul
#define LIN_TO8DIVIDER9 32ul
#define LIN_TO8DIVIDER10 40ul
#define LIN_TO8DIVIDER11 80ul
#define LIN_TO8DIVIDER12 160ul

    /* maximal integral divider search */
#if   ((LIN_MAXFRAME_8_TIMEOUT / LIN_TO8DIVIDER1) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO8DIVIDER LIN_TO8DIVIDER1
#elif ((LIN_MAXFRAME_8_TIMEOUT / LIN_TO8DIVIDER2) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO8DIVIDER LIN_TO8DIVIDER2
#elif ((LIN_MAXFRAME_8_TIMEOUT / LIN_TO8DIVIDER3) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO8DIVIDER LIN_TO8DIVIDER3
#elif ((LIN_MAXFRAME_8_TIMEOUT / LIN_TO8DIVIDER4) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO8DIVIDER LIN_TO8DIVIDER4
#elif ((LIN_MAXFRAME_8_TIMEOUT / LIN_TO8DIVIDER5) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO8DIVIDER LIN_TO8DIVIDER5
#elif ((LIN_MAXFRAME_8_TIMEOUT / LIN_TO8DIVIDER6) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO8DIVIDER LIN_TO8DIVIDER6
#elif ((LIN_MAXFRAME_8_TIMEOUT / LIN_TO8DIVIDER7) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO8DIVIDER LIN_TO8DIVIDER7
#elif ((LIN_MAXFRAME_8_TIMEOUT / LIN_TO8DIVIDER8) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO8DIVIDER LIN_TO8DIVIDER8
#elif ((LIN_MAXFRAME_8_TIMEOUT / LIN_TO8DIVIDER9) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO8DIVIDER LIN_TO8DIVIDER9
#elif ((LIN_MAXFRAME_8_TIMEOUT / LIN_TO8DIVIDER10) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO8DIVIDER LIN_TO8DIVIDER10
#elif ((LIN_MAXFRAME_8_TIMEOUT / LIN_TO8DIVIDER11) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO8DIVIDER LIN_TO8DIVIDER11
#elif ((LIN_MAXFRAME_8_TIMEOUT / LIN_TO8DIVIDER12) * LIN_BITTIME) < LIN_MAXTOCOUNTER
#define LIN_TO8DIVIDER LIN_TO8DIVIDER12
#endif


/********************************************************************************************/
/********************************************************************************************/
/**     Configuration arrays with timeout module constants                                 **/
/********************************************************************************************/
/********************************************************************************************/

/********************************************************************************************/
/* Number of timer interrupts counted for each timeout                                      */
/********************************************************************************************/

const unsigned char LIN_MTO_Counter[] = 
{ 
    LIN_TO9DIVIDER,             /* Wakeup Delimiter             */
    LIN_TO1DIVIDER,             /* MaxFrame for 1 byte  message */
    LIN_TO2DIVIDER,             /* MaxFrame for 2 bytes message */
    LIN_TO3DIVIDER,             /* MaxFrame for 3 bytes message */
    LIN_TO4DIVIDER,             /* MaxFrame for 4 bytes message */
    LIN_TO5DIVIDER,             /* MaxFrame for 5 bytes message */
    LIN_TO6DIVIDER,             /* MaxFrame for 6 bytes message */
    LIN_TO7DIVIDER,             /* MaxFrame for 7 bytes message */
    LIN_TO8DIVIDER,             /* MaxFrame for 8 bytes message */
};

/********************************************************************************************/
/* Number of timer ticks per one timer interrupt                                            */
/********************************************************************************************/

const unsigned int LIN_MTO_Ticks[] = 
{ 
    (LIN_WKUPDELLEN_TO / LIN_TO9DIVIDER) * LIN_BITTIME,         /* Wakeup Delimiter         */
    (LIN_MAXFRAME_1_TIMEOUT / LIN_TO1DIVIDER) * LIN_BITTIME,    /* MaxFrame for 1 byte  msg */
    (LIN_MAXFRAME_2_TIMEOUT / LIN_TO2DIVIDER) * LIN_BITTIME,    /* MaxFrame for 2 bytes msg */
    (LIN_MAXFRAME_3_TIMEOUT / LIN_TO3DIVIDER) * LIN_BITTIME,    /* MaxFrame for 3 bytes msg */
    (LIN_MAXFRAME_4_TIMEOUT / LIN_TO4DIVIDER) * LIN_BITTIME,    /* MaxFrame for 4 bytes msg */
    (LIN_MAXFRAME_5_TIMEOUT / LIN_TO5DIVIDER) * LIN_BITTIME,    /* MaxFrame for 5 bytes msg */
    (LIN_MAXFRAME_6_TIMEOUT / LIN_TO6DIVIDER) * LIN_BITTIME,    /* MaxFrame for 6 bytes msg */
    (LIN_MAXFRAME_7_TIMEOUT / LIN_TO7DIVIDER) * LIN_BITTIME,    /* MaxFrame for 7 bytes msg */
    (LIN_MAXFRAME_8_TIMEOUT / LIN_TO8DIVIDER) * LIN_BITTIME,    /* MaxFrame for 8 bytes msg */
};

#endif /* defined(MASTER) */
