#ifndef REGS_H
#define REGS_H
/******************************************************************************
*                                                                     
*       Copyright (C) 2005 Freescale Semiconductor, Inc.              
*       All Rights Reserved								              
*														              
* Filename:     regs.h                
*														              
* Revision:      										              
*														              
* Functions:    Register definition file
*												                            
* Description:  
*
* Notes:        
*
******************************************************************************/

/* Registers used for mapping RAM and I/O registers */
#include "analog_die_reg.h"

#if defined(COSMIC12)
#define   IOABS(address)  @address
volatile  LIN_BYTE LIN_INITRM IOABS(0x10);    /* RAM mapping register - location after reset */
volatile  LIN_BYTE LIN_INITRG IOABS(0x11);    /* IO mapping register - location after reset */
volatile  LIN_BYTE LIN_INITEE IOABS(0x12);    /* EEPROM mapping register - location after reset */
volatile  LIN_BYTE LIN_MISC   IOABS(0x13);    /* mapping control register - location after reset */
#endif /* defined(COSMIC12) */

#if defined(CW12)
#define IOBYTEABS(address) (*(( volatile LIN_BYTE*) (address)))
#define LIN_INITRM IOBYTEABS(0x10)  /* RAM mapping register - location after reset */
#define LIN_INITRG IOBYTEABS(0x11)  /* IO mapping register - location after reset */
#define LIN_INITEE IOBYTEABS(0x12)  /* EEPROM mapping register - location after reset */
#define LIN_MISC   IOBYTEABS(0x13)  /* mapping control register - location after reset */
#endif /* defined(CW12) */

/* Type that map registers into structure elements.                         */
/*      NB: order is important! Don't omit reserved or unused registers!    */

typedef struct {
    volatile LIN_BYTE porta;  /* 0x00 port a */
    volatile LIN_BYTE portb;  /* 0x01 port b */
    volatile LIN_BYTE ddra;   /* 0x02 data direction port a */
    volatile LIN_BYTE ddrb;   /* 0x03 data direction port b */
#if defined(C32)
    volatile LIN_BYTE reserved1[0x3C];  /* Timer section starts from 0x40 */ 
#endif /* defined(C32) */
    volatile LIN_BYTE tios;   /* time select */
    volatile LIN_BYTE cforc;  /* compare force */
    volatile LIN_BYTE oc7m;   /* oc7 mask */
    volatile LIN_BYTE oc7d;   /* oc7 data */
    volatile LIN_WORD  tcnt;  /* timer counter */
	volatile LIN_BYTE tscr;   /* timer system control */
#if defined(C32)
    volatile LIN_BYTE ttov;   /* timer toggle overflow */ 
#endif /* defined(C32) */
    volatile LIN_BYTE tctl1;  /* timer control 1 */
    volatile LIN_BYTE tctl2;  /* timer control 2 */
    volatile LIN_BYTE tctl3;  /* timer control 3 */
    volatile LIN_BYTE tctl4;  /* timer control 4 */
    volatile LIN_BYTE tmsk1;  /* timer interrupt mask 1 */
    volatile LIN_BYTE tmsk2;  /* timer interrupt mask 2 */
    volatile LIN_BYTE tflg1;  /* timer interrupt flag 1 */
    volatile LIN_BYTE tflg2;  /* timer interrupt flag 2 */
    volatile LIN_WORD  tc0;   /* timer capture/compare 0 */
    volatile LIN_WORD  tc1;   /* timer capture/compare 1 */
    volatile LIN_WORD  tc2;   /* timer capture/compare 2 */
    volatile LIN_WORD  tc3;   /* timer capture/compare 3 */
    volatile LIN_WORD  tc4;   /* timer capture/compare 4 */
    volatile LIN_WORD  tc5;   /* timer capture/compare 5 */
    volatile LIN_WORD  tc6;   /* timer capture/compare 6 */
    volatile LIN_WORD  tc7;   /* timer capture/compare 7 */
#if defined(C32)
    volatile LIN_BYTE reserved2[0x68];  /* SCI section starts from 0xC8 */ 
#endif /* defined(C32) */
    volatile LIN_BYTE sc0bdh; /* sci 0 baud rate high */
    volatile LIN_BYTE sc0bdl; /* sci 0 baud rate low */
    volatile LIN_BYTE sc0cr1; /* sci 0 control register 1 */
    volatile LIN_BYTE sc0cr2; /* sci 0 control register 2 */
    volatile LIN_BYTE sc0sr1; /* sci 0 status register 1 */
    volatile LIN_BYTE sc0sr2; /* sci 0 status register 2 */
    volatile LIN_BYTE sc0drh; /* sci 0 data register high */
    volatile LIN_BYTE sc0drl; /* sci 0 data register low */
#if defined(C32)
    volatile LIN_BYTE reserved3[0x188];  /* PortP section starts from 0x258 */
    volatile LIN_BYTE portp;  /* 0x258 port p */
    volatile LIN_BYTE ptip;   /* 0x259 input port p */
    volatile LIN_BYTE ddrp;   /* 0x25A data direction port p */	
#endif /* defined(C32) */

    /* can be continued */
} LIN_REGTYPE;

/* Extern declaration of common-purpose structure with registers definition */

#if defined(CW12)
#pragma DATA_SEG LinReg
#endif /* defined(CW12) */

#if defined(COSMIC12)
#pragma section [lin_reg]
#endif /* defined(COSMIC12) */

extern volatile LIN_REGTYPE LIN_Reg; 

#if defined(CW12)
#pragma DATA_SEG DEFAULT
#endif /* defined(CW12) */

#if defined(COSMIC12)
#pragma section []
#endif /* defined(COSMIC12) */

/* Register definitions used in the driver sources */

//http://www.freescale.com/webapp/sps/site/prod_summary.jsp?code=KITUSBSPIDGLEVME&fsrch=1
#define LIN_SC0BDH SCIBDhi    /* SCI 0 baud rate high */
#define LIN_SC0BDL SCIBDlo    /* SCI 0 baud rate low */
#define LIN_SC0CR1 SCIC1    /* SCI 0 control register 1 */
#define LIN_SC0CR2 SCIC2    /* SCI 0 control register 2 */
#define LIN_SC0SR1 SCIS1    /* SCI 0 status register 1 */
#define LIN_SC0SR2 SCIS2    /* SCI 0 status register 2 */   // ---- not the same register
#define LIN_SC0DRH SCIC3    /* SCI 0 data register high */
#define LIN_SC0DRL SCID    /* SCI 0 data register low */

/******************* Bit masks *************************/

/* define bit mask for SCI */
#define     LIN_SCCR1_LOOPS     0x80        /* Loop Mode/Single Wire Mode Enable in SCCR1 */
//#define     LIN_SCCR1_WOMS      0x40        /* Wired-or mode for serial pins     in SCCR1 */
#define     LIN_SCCR1_RSRC      0x20        /* Receive source                    in SCCR1 */
#define     LIN_SCCR1_M         0x10        /* Mode (character lenght)           in SCCR1 */
//#define     LIN_SCCR1_WAKE      0x08        /* Wake-up by address Mark/Idle      in SCCR1 */
#define     LIN_SCCR1_ILT       0x04        /* Idle line type                    in SCCR1 */
#define     LIN_SCCR1_PE        0x02        /* Parity Ebable                     in SCCR1 */
#define     LIN_SCCR1_PT        0x01        /* Parity bit                        in SCCR1 */

#define     LIN_SCCR2_TIE       0x80        /* Transmit interrupt enable bit     in SCCR2 */
#define     LIN_SCCR2_TCIE      0x40        /* Transfer complited intrerrupt enable SCCR2 */
#define     LIN_SCCR2_RIE       0x20        /* Reciver interrupt enable          in SCCR2 */
#define     LIN_SCCR2_ILIE      0x10        /* Idle line interrupt ebable        in SCCR2 */
#define     LIN_SCCR2_TE        0x08        /* Transmitter enable                in SCCR2 */
#define     LIN_SCCR2_RE        0x04        /* Receiver enable                   in SCCR2 */
#define     LIN_SCCR2_RWU       0x02        /* Receiver wake-up                  in SCCR2 */
#define     LIN_SCCR2_SBK       0x01        /* Send Break                        in SCCR2 */

#define     LIN_SCSR1_TDRE      0x80       /* Transmit Data Register Empty Flag  in SCSR1 */
#define     LIN_SCSR1_TC        0x40       /* Transmit                           in SCSR1 */
#define     LIN_SCSR1_RDRF      0x20       /* Receiver data register full flag   in SCSR1 */
#define     LIN_SCSR1_IDLE      0x10       /* Idle line detected flag            in SCSR1 */
#define     LIN_SCSR1_OR        0x08       /* Overrun error flag                 in SCSR1 */
#define     LIN_SCSR1_NF        0x04       /* Noise error flag                   in SCSR1 */
#define     LIN_SCSR1_FE        0x02       /* Framing error flag                 in SCSR1 */
#define     LIN_SCSR1_PE        0x01       /* Parity error flag                  in SCSR1 */

#define     LIN_SCDRH_R8        0x80        /* Received bit 8                    in SCDRH */
#define     LIN_SCDRH_T8        0x40        /* Transmit bit 8                    in SCDRH */



#endif /* !define (REGS_H) */
