#ifndef LINPROT_H
#define LINPROT_H
/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     linprot.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    LIN Protocol module. Master and Slave State Machine header file
*														                            
* Description:  
*
* Notes:        
*
******************************************************************************/

#define LIN_PROT_BUF_LEN 8u

/****************************************************************************
 * All extern declarations of common-purpose RAM variables shall be here.
 ***************************************************************************/
/****************************************************************************
 * It require to perform zero page RAM placement optimisation.
 ***************************************************************************/


extern  LIN_BYTE LIN_StateFlags;            /* State machine status  */

extern  LIN_BYTE LIN_ProtBuf[LIN_PROT_BUF_LEN];   /* Protocol buffer */
extern  LIN_BYTE LIN_TmpSCIByte;                  /* byte to receive byte from SCI                   */
                                                  /* it shoud be used only under disabled interrupts */
extern  LIN_BYTE LIN_BufCounter;                  /* ProtBuf counter point to sended byte for FLAG_DATA_SEND         */
                                                  /* or to first free byte for FLAG_DATA_RECEIVE or FLAG_DATA_IGNORE */
extern  LIN_BYTE LIN_MsgLength;                   /* Message length 1..8   */



/****************************************************************************
 * End of common-purpose RAM variables extern declaration
 ***************************************************************************/

#if defined(MASTER)
                                        /* Master flags for states machine */
#define LIN_FLAG_SLEEP          0x01
#define LIN_FLAG_SEND_BREAK     0x02
#define LIN_FLAG_IGNORE         0x04
#define LIN_FLAG_SEND_HEADER    0x08
#define LIN_FLAG_SEND_DATA      0x10
#define LIN_FLAG_RECEIVE_DATA   0x20
#define LIN_FLAG_IGNORE_DATA    0x40
#define LIN_FLAG_WAKEUP_TIMEOUT 0x80

#endif /* defined(MASTER) */

#if defined(SLAVE)
                                        /* Slave flags for states machine */

#if defined(LINAPI_1_0)
#define LIN_FLAG_DISCONNECT     0x01    /* LIN API: disconnected state */
#define LIN_FLAG_NOINIT         0x02    /* interface not initialized */
#else /* !defined(LINAPI_1_0) */
#define LIN_FLAG_SLEEP          0x01    /* Freescale API: sleep mode */
#endif /* !defined(LINAPI_1_0) */
#define LIN_FLAG_IGNORE         0x04
#define LIN_FLAG_RECEIVE_SYNC   0x08
#define LIN_FLAG_SEND_DATA      0x10
#define LIN_FLAG_RECEIVE_DATA   0x20
#define LIN_FLAG_RECEIVE_ID     0x40
#define LIN_FLAG_WAKEUP_TIMEOUT 0x80

#endif /* defined(SLAVE) */

/****************************************************************************/
/***                            Functions                                 ***/
/****************************************************************************/

void LIN_RxCompleted    ( void );
void LIN_TxCompleted    ( void );

/* Extern -- only for unit testing */
void LIN_CopyToBuf      ( LIN_BYTE * src );
void LIN_CopyFromBuf    ( LIN_BYTE * dst );

#if defined(MASTER)
void LIN_FrameError     ( void );
void LIN_Timeout        ( void );
#endif /* defined(MASTER) */

#if defined(SLAVE)
#define     LIN_FRAMEERROR      0   /* frame error like break */
#define     LIN_NORMALBREAK     1u  /* normal break */
void LIN_FrameError     ( LIN_BYTE breakType );
#endif /* defined(SLAVE) */

#endif /* define (LINPROT_H) */