#ifndef LINMSG_H
#define LINMSG_H

/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     linmsg.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    Message subsystem header file
*														                            
* Description:  
*
* Notes:        
*
******************************************************************************/

/* NB: be careful - check file linapi.h for bits from LinMsgStatus                        */
/* LIN_OK                0x00    No error, service call has succeeded.                    */
/* LIN_MSG_NODATA        0x01    The message data buffer is empty (data has not been      */
/*                               initialized or reseived yet).                            */
/* LIN_MSG_NOCHANGE      0x02    The message data has not changed since last read.        */
/* LIN_MSG_OVERRUN       0x04    The message data has not been read and was overwritten.  */

/* in lindef.h:                                                                             */
/* LIN_MSG_UPDATED      0x20u   Message has been updated by the user                        */

                            /* Mask for msg status to return in API call  */
#define LIN_MSG_STATUS_MASK     0x0Fu 
                             
#define LIN_MSG_OK              0x10u
                            /* Message locked. Reserved for future use and for HC05 */
#define LIN_MSG_LOCKED          0x40u


/* Message's index is least 6 bits in LinLookupTable */
#define LIN_MSG_INDEX_MASK      0x3Fu

/* Bit masks for message processing types */
/* Based on LIN_RECEIVE, LIN_SEND, LIN_SEND_UPDATED defines */

                            /* Message is not ignored -- 1100 0000 */
#define LIN_MSG_NOT_IGNORED     (LIN_RECEIVE | LIN_SEND | LIN_SEND_UPDATED)
                            /* Message is received    -- 0100 0000 */
#define LIN_MSG_RECEIVE         LIN_RECEIVE
                            /* Message is sended      -- 1000 0000 */
#define LIN_MSG_SEND            LIN_SEND
                            /* Message is sended but only updated -- 0100 0000 */
                            /* NB: it should be checked only after LIN_MSG_SEND */
#define LIN_MSG_SEND_UPDATED    (LIN_SEND_UPDATED & ~LIN_SEND)

/* Valid frame's Id range 0..0x3D */
#define LIN_FRAME_MAX_ID  0x3D    

#endif /* !define (LINMSG_H) */
