#ifndef LINAPI_H
#define LINAPI_H
/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     linapi.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    Freescale API header file for LIN Drivers
*														                            
* Description:  
*
* Notes:        
*
******************************************************************************/

/* LIN Driver data types and definitions */
#include "lindef.h"

#if !defined( LINCFGH )
#include "lincfg.h"
#else
#include LINCFGH
#endif /* !defined( LINCFGH ) */

#if !defined( LINMSGIDH )
#include "linmsgid.h"
#else
#include LINMSGIDH
#endif /* !defined( LINMSGIDH ) */

/*      LINStatusType Constant Definition     */

#define LIN_OK                0x00    /* No error, service call has succeeded.                    */
//#define LIN_MSG_NODATA        0x01    /*   The message data buffer is empty (data has not been      */
                                      /* initialized or reseived yet).                            */
#define LIN_MSG_NOCHANGE      0x02    /* The message data has not changed since last read.        */
#define LIN_MSG_OVERRUN       0x04    /* The message data has not been read and was overwritten.  */
#define LIN_REQ_PENDING       0x15    /* The message request is already pending.                  */
#define LIN_INVALID_MODE      0x16    /* The service could not be called in the current driver    */
                                      /* state.                                                   */
#define LIN_INVALID_ID        0x80    /* The message identifier is invalid, i.e. the message      */
                                      /* direction differs from the configured one.               */
#define LIN_NO_ID             0x7F    /* The message identifier is absent, i.e. there is no such  */
                                      /* identifier configured on this node.                      */

/*      LINDriverStatusType bit mask constant values */

#define LIN_STATUS_RUN        0x01    /* Driver is in run state                                   */
#define LIN_STATUS_IDLE       0x02    /* No-Bus_activity timeout is expired                       */
#define LIN_STATUS_PENDING    0x04    /* LIN bus frame is pending                                 */

/*      LIN Driver Freescale API functions prototypes */

void                    LIN_Init ( void );
#if defined(SLAVE)
LINStatusType           LIN_Wakeup( void );
#endif /* defined(SLAVE) */
void                    LIN_GotoRun( void );
LINDriverStatusType     LIN_DriverStatus( void );
LINStatusType           LIN_GetMsg( LINMsgIdType msgId, LINMsgRefType msgData );
LINStatusType           LIN_PutMsg( LINMsgIdType msgId, LINMsgRefType msgData );
LINStatusType           LIN_MsgStatus( LINMsgIdType msgId );
LINErrCounterType       LIN_GetRxErr( void );
LINErrCounterType       LIN_GetTxErr( void );
void                    LIN_ClearRxErr( void );
void                    LIN_ClearTxErr( void );
void                    LIN_IdleClock( void );
#if defined(MASTER)
LINStatusType           LIN_RequestMsg( LINMsgIdType msgId );
#endif /* defined(MASTER) */

/*      User hook called after going to Sleep mode */
void                    LIN_Command( void );

#endif /* define (LINAPI_H) */
