/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.vti;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.vti.ForwardingVTI;
import org.apache.derby.vti.RestrictedVTI;
import org.apache.derby.vti.Restriction;

public class ForeignTableVTI
extends ForwardingVTI
implements RestrictedVTI {
    private static HashMap<String, Connection> _connections = new HashMap();
    private String _foreignSchemaName;
    private String _foreignTableName;
    private String _connectionURL;
    private Connection _foreignConnection;
    private String[] _columnNames;
    private Restriction _restriction;
    private int[] _columnNumberMap;
    private PreparedStatement _foreignPreparedStatement;

    public ForeignTableVTI(String string, String string2, Connection connection) {
        this._foreignSchemaName = string;
        this._foreignTableName = string2;
        this._foreignConnection = connection;
    }

    protected ForeignTableVTI(String string, String string2, String string3) {
        this._foreignSchemaName = string;
        this._foreignTableName = string2;
        this._connectionURL = string3;
    }

    public static ForeignTableVTI readForeignTable(String string, String string2, String string3) {
        return new ForeignTableVTI(string, string2, string3);
    }

    public static void dropConnection(String string) {
        _connections.remove(string);
    }

    public static int countConnections() {
        return _connections.size();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            this._foreignSchemaName = null;
            this._foreignTableName = null;
            this._connectionURL = null;
            this._columnNames = null;
            this._restriction = null;
            this._columnNumberMap = null;
            if (this.getWrappedResultSet() != null) {
                this.getWrappedResultSet().close();
            }
            if (this._foreignPreparedStatement != null) {
                this._foreignPreparedStatement.close();
            }
            this.wrapResultSet(null);
            this._foreignPreparedStatement = null;
            this._foreignConnection = null;
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.isClosed() && this.getWrappedResultSet() == null) {
            this._foreignPreparedStatement = ForeignTableVTI.prepareStatement(ForeignTableVTI.getForeignConnection(this._connectionURL, this._foreignConnection), this.makeQuery());
            this.wrapResultSet(this._foreignPreparedStatement.executeQuery());
        }
        return this.getWrappedResultSet().next();
    }

    @Override
    public boolean isClosed() {
        return this._connectionURL == null && this._foreignConnection == null;
    }

    @Override
    public void initScan(String[] stringArray, Restriction restriction) throws SQLException {
        this._columnNames = ArrayUtil.copy(stringArray);
        this._restriction = restriction;
        int n2 = this._columnNames.length;
        this._columnNumberMap = new int[n2];
        int n3 = 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this._columnNames[i2] == null) continue;
            this._columnNumberMap[i2] = n3++;
        }
    }

    private static Connection getForeignConnection(String string, Connection connection) throws SQLException {
        if (connection != null) {
            return connection;
        }
        Connection connection2 = _connections.get(string);
        if (connection2 == null && (connection2 = DriverManager.getConnection(string)) != null) {
            _connections.put(string, connection2);
        }
        return connection2;
    }

    private String makeQuery() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ");
        int n2 = this._columnNames.length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = this._columnNames[i2];
            if (string2 == null) continue;
            if (n3 > 0) {
                stringBuilder.append(", ");
            }
            ++n3;
            stringBuilder.append(ForeignTableVTI.delimitedID(string2));
        }
        stringBuilder.append("\nfrom ");
        stringBuilder.append(ForeignTableVTI.delimitedID(this._foreignSchemaName));
        stringBuilder.append('.');
        stringBuilder.append(ForeignTableVTI.delimitedID(this._foreignTableName));
        if (this._restriction != null && (string = this._restriction.toSQL()) != null && (string = string.trim()).length() != 0) {
            stringBuilder.append("\nwhere " + string);
        }
        return stringBuilder.toString();
    }

    private static String delimitedID(String string) {
        return IdUtil.normalToDelimited(string);
    }

    private static PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        return connection.prepareStatement(string);
    }

    @Override
    protected int mapColumnNumber(int n2) {
        return this._columnNumberMap[n2 - 1];
    }
}

