/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.derby.iapi.error.ExceptionUtil;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.xa.XAResourceManager;
import org.apache.derby.iapi.store.access.xa.XAXactId;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.TransactionResourceImpl;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.EmbedPooledConnection;
import org.apache.derby.jdbc.XATransactionState;

class EmbedXAResource
implements XAResource {
    private EmbedPooledConnection con;
    private ResourceAdapter ra;
    private XAXactId currentXid;
    private int timeoutSeconds;
    private LanguageConnectionContext lcc;

    EmbedXAResource(EmbedPooledConnection embedPooledConnection, ResourceAdapter resourceAdapter) {
        this.con = embedPooledConnection;
        this.ra = resourceAdapter;
        this.timeoutSeconds = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void commit(Xid xid, boolean bl2) throws XAException {
        this.checkXAActive();
        XAXactId xAXactId = new XAXactId(xid);
        XATransactionState xATransactionState = this.getTransactionState(xAXactId);
        if (xATransactionState == null) {
            XAResourceManager xAResourceManager = this.ra.getXAResourceManager();
            ContextManager contextManager = xAResourceManager.find(xid);
            if (contextManager == null) {
                throw new XAException(-4);
            }
            ContextService contextService = EmbedXAResource.getContextService();
            contextService.setCurrentContextManager(contextManager);
            try {
                xAResourceManager.commit(contextManager, xAXactId, bl2);
                contextManager.cleanupOnError(StandardException.closeException(), false);
                return;
            }
            catch (StandardException standardException) {
                contextManager.cleanupOnError(standardException, this.con.isActive());
                throw EmbedXAResource.wrapInXAException(standardException);
            }
            finally {
                contextService.resetCurrentContextManager(contextManager);
            }
        }
        XATransactionState xATransactionState2 = xATransactionState;
        synchronized (xATransactionState2) {
            this.checkUserCredentials(xATransactionState.creatingResource);
            switch (xATransactionState.associationState) {
                case 0: {
                    break;
                }
                case -1: {
                    throw new XAException(xATransactionState.rollbackOnlyCode);
                }
                default: {
                    throw new XAException(-6);
                }
            }
            if (xATransactionState.suspendedList != null && xATransactionState.suspendedList.size() != 0) {
                throw new XAException(-6);
            }
            if (xATransactionState.isPrepared == bl2) {
                throw new XAException(-6);
            }
            try {
                xATransactionState.xa_commit(bl2);
            }
            catch (SQLException sQLException) {
                throw EmbedXAResource.wrapInXAException(sQLException);
            }
            finally {
                this.returnConnectionToResource(xATransactionState, xAXactId);
            }
        }
    }

    @Override
    public final synchronized void end(Xid xid, int n2) throws XAException {
        XATransactionState xATransactionState;
        this.checkXAActive();
        try {
            if (this.con.currentConnectionHandle != null) {
                this.con.currentConnectionHandle.getIsolationUptoDate();
            }
        }
        catch (SQLException sQLException) {
            throw EmbedXAResource.wrapInXAException(sQLException);
        }
        XAXactId xAXactId = new XAXactId(xid);
        boolean bl2 = false;
        if (this.currentXid != null) {
            if (!this.currentXid.equals(xAXactId)) {
                throw new XAException(-6);
            }
            bl2 = true;
        }
        if ((xATransactionState = this.getTransactionState(xAXactId)) == null) {
            throw new XAException(-4);
        }
        boolean bl3 = xATransactionState.end(this, n2, bl2);
        if (bl2) {
            this.currentXid = null;
            this.con.realConnection = null;
        }
        if (bl3) {
            throw new XAException(xATransactionState.rollbackOnlyCode);
        }
    }

    @Override
    public final synchronized int prepare(Xid xid) throws XAException {
        this.checkXAActive();
        XAXactId xAXactId = new XAXactId(xid);
        XATransactionState xATransactionState = this.getTransactionState(xAXactId);
        if (xATransactionState == null) {
            XAResourceManager xAResourceManager = this.ra.getXAResourceManager();
            ContextManager contextManager = xAResourceManager.find(xid);
            if (contextManager == null) {
                throw new XAException(-4);
            }
            throw new XAException(-6);
        }
        XATransactionState xATransactionState2 = xATransactionState;
        synchronized (xATransactionState2) {
            this.checkUserCredentials(xATransactionState.creatingResource);
            switch (xATransactionState.associationState) {
                case 0: {
                    break;
                }
                case -1: {
                    throw new XAException(xATransactionState.rollbackOnlyCode);
                }
                default: {
                    throw new XAException(-6);
                }
            }
            if (xATransactionState.suspendedList != null && xATransactionState.suspendedList.size() != 0) {
                throw new XAException(-6);
            }
            if (xATransactionState.isPrepared) {
                throw new XAException(-6);
            }
            try {
                int n2 = xATransactionState.xa_prepare();
                if (n2 == 2) {
                    xATransactionState.isPrepared = true;
                    return 0;
                }
                this.returnConnectionToResource(xATransactionState, xAXactId);
                return 3;
            }
            catch (SQLException sQLException) {
                XAException xAException = EmbedXAResource.wrapInXAException(sQLException);
                if (ExceptionUtil.isDeferredConstraintViolation(sQLException.getSQLState())) {
                    this.returnConnectionToResource(xATransactionState, xAXactId);
                }
                throw xAException;
            }
        }
    }

    @Override
    public synchronized int getTransactionTimeout() {
        return this.timeoutSeconds;
    }

    @Override
    public final synchronized boolean isSameRM(XAResource xAResource) throws XAException {
        this.checkXAActive();
        if (xAResource instanceof EmbedXAResource) {
            return this.ra == ((EmbedXAResource)xAResource).ra;
        }
        return false;
    }

    @Override
    public final synchronized Xid[] recover(int n2) throws XAException {
        this.checkXAActive();
        try {
            return this.ra.getXAResourceManager().recover(n2);
        }
        catch (StandardException standardException) {
            throw EmbedXAResource.wrapInXAException(standardException);
        }
    }

    @Override
    public final synchronized void forget(Xid xid) throws XAException {
        this.checkXAActive();
        XAXactId xAXactId = new XAXactId(xid);
        XATransactionState xATransactionState = this.getTransactionState(xAXactId);
        if (xATransactionState == null) {
            XAResourceManager xAResourceManager = this.ra.getXAResourceManager();
            ContextManager contextManager = xAResourceManager.find(xid);
            if (contextManager == null) {
                throw new XAException(-4);
            }
            ContextService contextService = EmbedXAResource.getContextService();
            contextService.setCurrentContextManager(contextManager);
            try {
                xAResourceManager.forget(contextManager, xAXactId);
                contextManager.cleanupOnError(StandardException.closeException(), false);
                return;
            }
            catch (StandardException standardException) {
                contextManager.cleanupOnError(standardException, this.con.isActive());
                throw EmbedXAResource.wrapInXAException(standardException);
            }
            finally {
                contextService.resetCurrentContextManager(contextManager);
            }
        }
        throw new XAException(-6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void rollback(Xid xid) throws XAException {
        this.checkXAActive();
        XAXactId xAXactId = new XAXactId(xid);
        XATransactionState xATransactionState = this.getTransactionState(xAXactId);
        if (xATransactionState == null) {
            XAResourceManager xAResourceManager = this.ra.getXAResourceManager();
            ContextManager contextManager = xAResourceManager.find(xid);
            if (contextManager == null) {
                throw new XAException(-4);
            }
            ContextService contextService = EmbedXAResource.getContextService();
            contextService.setCurrentContextManager(contextManager);
            try {
                xAResourceManager.rollback(contextManager, xAXactId);
                contextManager.cleanupOnError(StandardException.closeException(), false);
                return;
            }
            catch (StandardException standardException) {
                contextManager.cleanupOnError(standardException, this.con.isActive());
                throw EmbedXAResource.wrapInXAException(standardException);
            }
            finally {
                contextService.resetCurrentContextManager(contextManager);
            }
        }
        XATransactionState xATransactionState2 = xATransactionState;
        synchronized (xATransactionState2) {
            switch (xATransactionState.associationState) {
                case -1: 
                case 0: {
                    break;
                }
                default: {
                    throw new XAException(-6);
                }
            }
            if (xATransactionState.suspendedList != null && xATransactionState.suspendedList.size() != 0) {
                throw new XAException(-6);
            }
            this.checkUserCredentials(xATransactionState.creatingResource);
            try {
                xATransactionState.xa_rollback();
            }
            catch (SQLException sQLException) {
                throw EmbedXAResource.wrapInXAException(sQLException);
            }
            finally {
                this.returnConnectionToResource(xATransactionState, xAXactId);
            }
        }
    }

    @Override
    public synchronized boolean setTransactionTimeout(int n2) throws XAException {
        if (n2 < 0) {
            throw new XAException(-5);
        }
        this.timeoutSeconds = n2;
        return true;
    }

    private long getDefaultXATransactionTimeout() throws XAException {
        try {
            LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext(this.con);
            TransactionController transactionController = languageConnectionContext.getTransactionExecute();
            long l2 = 1000L * (long)PropertyUtil.getServiceInt(transactionController, "derby.jdbc.xaTransactionTimeout", 0, Integer.MAX_VALUE, 0);
            return l2;
        }
        catch (SQLException sQLException) {
            throw EmbedXAResource.wrapInXAException(sQLException);
        }
        catch (StandardException standardException) {
            throw EmbedXAResource.wrapInXAException(standardException);
        }
    }

    @Override
    public final synchronized void start(Xid xid, int n2) throws XAException {
        this.checkXAActive();
        if (this.currentXid != null) {
            throw new XAException(-6);
        }
        XAXactId xAXactId = new XAXactId(xid);
        XATransactionState xATransactionState = this.getTransactionState(xAXactId);
        switch (n2) {
            case 0: {
                long l2;
                if (xATransactionState != null) {
                    throw new XAException(-8);
                }
                try {
                    if (this.con.realConnection == null) {
                        this.con.openRealConnection();
                        if (this.con.currentConnectionHandle != null) {
                            this.con.currentConnectionHandle.setState(true);
                            this.con.realConnection.setApplicationConnection(this.con.currentConnectionHandle);
                        }
                    } else {
                        if (this.con.currentConnectionHandle != null && this.con.currentConnectionHandle.getAutoCommit()) {
                            this.con.currentConnectionHandle.rollback();
                        }
                        if (!this.con.realConnection.transactionIsIdle()) {
                            throw new XAException(-9);
                        }
                        if (this.con.currentConnectionHandle != null) {
                            this.con.currentConnectionHandle.getIsolationUptoDate();
                            this.con.currentConnectionHandle.setState(true);
                            this.con.realConnection.rollback();
                        } else {
                            this.con.resetRealConnection();
                        }
                    }
                    this.con.realConnection.setAutoCommit(false);
                    this.con.realConnection.setHoldability(2);
                    this.getLanguageConnectionContext(this.con.realConnection).getTransactionExecute().createXATransactionFromLocalTransaction(xAXactId.getFormatId(), xAXactId.getGlobalTransactionId(), xAXactId.getBranchQualifier());
                }
                catch (StandardException standardException) {
                    throw EmbedXAResource.wrapInXAException(standardException);
                }
                catch (SQLException sQLException) {
                    throw EmbedXAResource.wrapInXAException(sQLException);
                }
                xATransactionState = new XATransactionState(EmbedXAResource.getContextManager(this.con.realConnection), this.con.realConnection, this, xAXactId);
                if (!this.ra.addConnection(xAXactId, xATransactionState)) {
                    throw new XAException(-8);
                }
                this.currentXid = xAXactId;
                if (this.timeoutSeconds == Integer.MAX_VALUE || (l2 = this.timeoutSeconds > 0 ? (long)(1000 * this.timeoutSeconds) : this.getDefaultXATransactionTimeout()) <= 0L) break;
                xATransactionState.scheduleTimeoutTask(l2);
                break;
            }
            case 0x200000: 
            case 0x8000000: {
                if (xATransactionState == null) {
                    throw new XAException(-4);
                }
                xATransactionState.start(this, n2);
                if (xATransactionState.conn == this.con.realConnection) break;
                if (this.con.realConnection != null) {
                    if (!this.con.realConnection.transactionIsIdle()) {
                        throw new XAException(-9);
                    }
                    try {
                        if (this.con.currentConnectionHandle != null) {
                            this.con.currentConnectionHandle.getIsolationUptoDate();
                        }
                    }
                    catch (SQLException sQLException) {
                        throw EmbedXAResource.wrapInXAException(sQLException);
                    }
                    EmbedXAResource.closeUnusedConnection(this.con.realConnection);
                }
                this.con.realConnection = xATransactionState.conn;
                if (this.con.currentConnectionHandle == null) break;
                try {
                    this.con.currentConnectionHandle.setState(false);
                    this.con.realConnection.setApplicationConnection(this.con.currentConnectionHandle);
                    break;
                }
                catch (SQLException sQLException) {
                    throw EmbedXAResource.wrapInXAException(sQLException);
                }
            }
            default: {
                throw new XAException(-5);
            }
        }
        this.currentXid = xAXactId;
    }

    Xid getCurrentXid() {
        return this.currentXid;
    }

    private XATransactionState getTransactionState(XAXactId xAXactId) {
        return (XATransactionState)this.ra.findConnection(xAXactId);
    }

    private void checkUserCredentials(EmbedXAResource embedXAResource) throws XAException {
        if (embedXAResource == this) {
            return;
        }
        if (embedXAResource.con.getPassword().equals(this.con.getPassword()) && embedXAResource.con.getUsername().equals(this.con.getUsername())) {
            return;
        }
        throw new XAException(103);
    }

    private void checkXAActive() throws XAException {
        try {
            this.con.checkActive();
        }
        catch (SQLException sQLException) {
            throw EmbedXAResource.wrapInXAException(sQLException);
        }
    }

    private static XAException wrapInXAException(SQLException sQLException) {
        String string = sQLException.getSQLState();
        String string2 = sQLException.getMessage();
        int n2 = sQLException.getErrorCode();
        int n3 = string.equals(StandardException.getSQLStateFromIdentifier("XSAX1.S")) ? -8 : (string.equals(StandardException.getSQLStateFromIdentifier("XSAX0.S")) ? 105 : (string.equals("40001") ? 102 : (string.equals("40XL1") ? 106 : (n2 >= 40000 ? -7 : (ExceptionUtil.isDeferredConstraintViolation(string) ? 103 : -3)))));
        XAException xAException = new XAException(string2);
        xAException.errorCode = n3;
        xAException.initCause(sQLException);
        return xAException;
    }

    private static XAException wrapInXAException(StandardException standardException) {
        return EmbedXAResource.wrapInXAException(TransactionResourceImpl.wrapInSQLException(standardException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnConnectionToResource(XATransactionState xATransactionState, XAXactId xAXactId) {
        this.removeXATransaction(xAXactId);
        XATransactionState xATransactionState2 = xATransactionState;
        synchronized (xATransactionState2) {
            xATransactionState.associationState = 3;
            xATransactionState.notifyAll();
            EmbedConnection embedConnection = xATransactionState.conn;
            if (xATransactionState.creatingResource.con.realConnection == embedConnection || xATransactionState.creatingResource.con.realConnection == null) {
                xATransactionState.creatingResource.con.realConnection = embedConnection;
                BrokeredConnection brokeredConnection = xATransactionState.creatingResource.con.currentConnectionHandle;
                embedConnection.setApplicationConnection(brokeredConnection);
                if (brokeredConnection != null) {
                    try {
                        brokeredConnection.setState(true);
                    }
                    catch (SQLException sQLException) {
                        EmbedXAResource.closeUnusedConnection(xATransactionState.conn);
                        xATransactionState.creatingResource.con.realConnection = null;
                    }
                }
                return;
            }
        }
        EmbedXAResource.closeUnusedConnection(xATransactionState.conn);
    }

    private static void closeUnusedConnection(EmbedConnection embedConnection) {
        if (embedConnection != null) {
            try {
                embedConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    void removeXATransaction(XAXactId xAXactId) {
        XATransactionState xATransactionState = (XATransactionState)this.ra.removeConnection(xAXactId);
        if (xATransactionState != null) {
            xATransactionState.popMe();
        }
    }

    void setCurrentXid(XAXactId xAXactId) {
        this.currentXid = xAXactId;
    }

    private static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static ContextManager getContextManager(final EmbedConnection embedConnection) {
        return AccessController.doPrivileged(new PrivilegedAction<ContextManager>(){

            @Override
            public ContextManager run() {
                return embedConnection.getContextManager();
            }
        });
    }

    private LanguageConnectionContext getLanguageConnectionContext(final EmbedConnection embedConnection) {
        return AccessController.doPrivileged(new PrivilegedAction<LanguageConnectionContext>(){

            @Override
            public LanguageConnectionContext run() {
                return embedConnection.getLanguageConnection();
            }
        });
    }

    private LanguageConnectionContext getLanguageConnectionContext(final EmbedPooledConnection embedPooledConnection) throws SQLException {
        if (this.lcc == null) {
            try {
                this.lcc = AccessController.doPrivileged(new PrivilegedExceptionAction<LanguageConnectionContext>(){

                    @Override
                    public LanguageConnectionContext run() throws SQLException {
                        return embedPooledConnection.getLanguageConnection();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw Util.javaException(privilegedActionException);
            }
        }
        return this.lcc;
    }
}

