/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication.buffer;

class LogBufferElement {
    private final byte[] bufferdata;
    private int position;
    private long greatestInstant;
    private boolean recycleMe;

    protected LogBufferElement(int n2) {
        this.bufferdata = new byte[n2];
        this.init();
    }

    protected void init() {
        this.position = 0;
        this.greatestInstant = 0L;
        this.recycleMe = true;
    }

    protected void appendLog(long l2, byte[] byArray, int n2, int n3) {
        this.greatestInstant = l2;
        this.position = this.appendBytes(byArray, n2, this.position, n3);
    }

    protected byte[] getData() {
        return this.bufferdata;
    }

    protected long getLastInstant() {
        return this.greatestInstant;
    }

    protected int freeSize() {
        return this.bufferdata.length - this.position;
    }

    protected int size() {
        return this.position;
    }

    protected boolean isRecyclable() {
        return this.recycleMe;
    }

    protected void setRecyclable(boolean bl2) {
        this.recycleMe = bl2;
    }

    private int appendBytes(byte[] byArray, int n2, int n3, int n4) {
        System.arraycopy(byArray, n2, this.bufferdata, n3, n4);
        return n3 + n4;
    }
}

