/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication;

import java.util.Date;
import org.apache.derby.iapi.error.ErrorStringBuilder;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;

public class ReplicationLogger {
    private final boolean verbose = PropertyUtil.getSystemBoolean("derby.replication.verbose", true);
    private final String dbname;

    public ReplicationLogger(String string) {
        this.dbname = string;
    }

    public void logError(String string, Throwable throwable) {
        if (this.verbose) {
            Monitor.logTextMessage("R001", new Date());
            if (string != null) {
                Monitor.logTextMessage(string, this.dbname);
            }
            if (throwable != null) {
                ErrorStringBuilder errorStringBuilder = new ErrorStringBuilder(Monitor.getStream().getHeader());
                errorStringBuilder.stackTrace(throwable);
                Monitor.logMessage(errorStringBuilder.get().toString());
                errorStringBuilder.reset();
            }
            Monitor.logTextMessage("R002", new Object[0]);
        }
    }

    public void logText(String string, boolean bl2) {
        if (this.verbose) {
            if (bl2) {
                Monitor.logTextMessage("R001", new Date());
                Monitor.logMessage(string);
                Monitor.logTextMessage("R002", new Object[0]);
            } else {
                Monitor.logTextMessage("R013", new Date(), string);
            }
        }
    }
}

