/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerLock;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.RowLock;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.impl.store.raw.xact.NoLocking;

public class RowLocking3
extends NoLocking {
    private static final LockingPolicy NO_LOCK = new NoLocking();
    protected final LockFactory lf;

    protected RowLocking3(LockFactory lockFactory) {
        this.lf = lockFactory;
    }

    protected RowLock getReadLockType() {
        return RowLock.RS3;
    }

    protected RowLock getUpdateLockType() {
        return RowLock.RU3;
    }

    protected RowLock getWriteLockType() {
        return RowLock.RX3;
    }

    @Override
    public boolean lockContainer(Transaction transaction, ContainerHandle containerHandle, boolean bl2, boolean bl3) throws StandardException {
        ContainerLock containerLock = bl3 ? ContainerLock.CIX : ContainerLock.CIS;
        boolean bl4 = this.lf.lockObject(transaction.getCompatibilitySpace(), transaction, containerHandle.getId(), containerLock, bl2 ? -2 : 0);
        if (bl4 && (this.lf.isLockHeld(transaction.getCompatibilitySpace(), transaction, containerHandle.getId(), ContainerLock.CX) || !bl3 && this.lf.isLockHeld(transaction.getCompatibilitySpace(), transaction, containerHandle.getId(), ContainerLock.CS))) {
            containerHandle.setLockingPolicy(NO_LOCK);
        }
        return bl4;
    }

    @Override
    public boolean lockRecordForRead(Transaction transaction, ContainerHandle containerHandle, RecordHandle recordHandle, boolean bl2, boolean bl3) throws StandardException {
        RowLock rowLock = bl3 ? this.getUpdateLockType() : this.getReadLockType();
        return this.lf.lockObject(transaction.getCompatibilitySpace(), transaction, recordHandle, rowLock, bl2 ? -2 : 0);
    }

    @Override
    public boolean zeroDurationLockRecordForWrite(Transaction transaction, RecordHandle recordHandle, boolean bl2, boolean bl3) throws StandardException {
        return this.lf.zeroDurationlockObject(transaction.getCompatibilitySpace(), recordHandle, bl2 ? RowLock.RIP : this.getWriteLockType(), bl3 ? -2 : 0);
    }

    @Override
    public boolean lockRecordForWrite(Transaction transaction, RecordHandle recordHandle, boolean bl2, boolean bl3) throws StandardException {
        return this.lf.lockObject(transaction.getCompatibilitySpace(), transaction, recordHandle, bl2 ? RowLock.RI : this.getWriteLockType(), bl3 ? -2 : 0);
    }

    @Override
    public int getMode() {
        return 1;
    }
}

