/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.ScanHandle;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.impl.store.raw.log.FlushedScan;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogRecord;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.impl.store.raw.log.StreamLogScan;

public class FlushedScanHandle
implements ScanHandle {
    LogFactory lf;
    StreamLogScan fs;
    LogRecord lr = null;
    boolean readOptionalData = false;
    int groupsIWant;
    ArrayInputStream rawInput = new ArrayInputStream(new byte[4096]);

    FlushedScanHandle(LogToFile logToFile, DatabaseInstant databaseInstant, int n2) throws StandardException {
        this.lf = logToFile;
        this.fs = new FlushedScan(logToFile, ((LogCounter)databaseInstant).getValueAsLong());
        this.groupsIWant = n2;
    }

    @Override
    public boolean next() throws StandardException {
        this.readOptionalData = false;
        this.lr = null;
        try {
            this.lr = this.fs.getNextRecord(this.rawInput, null, this.groupsIWant);
            return this.lr != null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA2.D", iOException, new Object[0]));
        }
    }

    @Override
    public int getGroup() throws StandardException {
        return this.lr.group();
    }

    @Override
    public Loggable getLoggable() throws StandardException {
        try {
            return this.lr.getLoggable();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA2.D", iOException, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA3.D", classNotFoundException, new Object[0]));
        }
    }

    @Override
    public InputStream getOptionalData() throws StandardException {
        if (this.lr == null) {
            return null;
        }
        try {
            int n2 = this.rawInput.readInt();
            this.readOptionalData = true;
            this.rawInput.setLimit(n2);
            return this.rawInput;
        }
        catch (IOException iOException) {
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA2.D", iOException, new Object[0]));
        }
    }

    @Override
    public DatabaseInstant getInstant() throws StandardException {
        return this.fs.getLogInstant();
    }

    @Override
    public Object getTransactionId() throws StandardException {
        try {
            return this.lr.getTransactionId();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA2.D", iOException, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA3.D", classNotFoundException, new Object[0]));
        }
    }

    @Override
    public void close() {
        if (this.fs != null) {
            this.fs.close();
        }
        this.fs = null;
    }
}

