/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.LimitInputStream;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.services.io.TypedFormat;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.DecryptInputStream;
import org.apache.derby.impl.store.raw.data.MemByteHolder;
import org.apache.derby.impl.store.raw.data.StoredFieldHeader;
import org.apache.derby.impl.store.raw.data.StoredRecordHeader;
import org.apache.derby.io.StorageFile;

class StreamFileContainer
implements PrivilegedExceptionAction<Object>,
TypedFormat {
    protected static int formatIdInteger = 290;
    protected static final int LARGE_SLOT_SIZE = 4;
    protected static final int MIN_BUFFER_SIZE = 1024;
    protected static final int FIELD_STATUS = StoredFieldHeader.setFixed(StoredFieldHeader.setInitial(), true);
    protected static final int FIELD_HEADER_SIZE = StoredFieldHeader.size(FIELD_STATUS, 0, 4);
    protected ContainerKey identity;
    private BaseDataFileFactory dataFactory;
    private int bufferSize;
    private StorageFile file;
    private OutputStream fileOut;
    private DynamicByteArrayOutputStream out;
    private FormatIdOutputStream logicalDataOut;
    private InputStream fileIn;
    private BufferedInputStream bufferedIn;
    private DecryptInputStream decryptIn;
    private LimitInputStream limitIn;
    private FormatIdInputStream logicalDataIn;
    private StoredRecordHeader recordHeader;
    private byte[] ciphertext;
    private byte[] zeroBytes;
    private static final int STORAGE_FILE_EXISTS_ACTION = 1;
    private static final int STORAGE_FILE_DELETE_ACTION = 2;
    private static final int STORAGE_FILE_MKDIRS_ACTION = 3;
    private static final int STORAGE_FILE_GET_OUTPUT_STREAM_ACTION = 4;
    private static final int STORAGE_FILE_GET_INPUT_STREAM_ACTION = 5;
    private int actionCode;
    private StorageFile actionStorageFile;

    StreamFileContainer(ContainerKey containerKey, BaseDataFileFactory baseDataFileFactory) {
        this.identity = containerKey;
        this.dataFactory = baseDataFileFactory;
    }

    StreamFileContainer(ContainerKey containerKey, BaseDataFileFactory baseDataFileFactory, Properties properties) throws StandardException {
        this.identity = containerKey;
        this.dataFactory = baseDataFileFactory;
        try {
            this.file = this.getFileName(containerKey, true, false);
            if (this.privExists(this.file)) {
                throw StandardException.newException("XSDF0.S", this.file);
            }
            this.getContainerProperties(properties);
        }
        catch (SecurityException securityException) {
            throw StandardException.newException("XSDF1.S", securityException, this.file);
        }
    }

    protected StreamFileContainer open(boolean bl2) throws StandardException {
        this.file = this.getFileName(this.identity, false, true);
        if (!this.privExists(this.file)) {
            return null;
        }
        try {
            if (!bl2) {
                this.fileIn = this.privGetInputStream(this.file);
                if (this.dataFactory.databaseEncrypted()) {
                    MemByteHolder memByteHolder = new MemByteHolder(16384);
                    this.decryptIn = new DecryptInputStream(this.fileIn, memByteHolder, this.dataFactory);
                    this.limitIn = new LimitInputStream(this.decryptIn);
                } else {
                    this.bufferedIn = new BufferedInputStream(this.fileIn, 16384);
                    this.limitIn = new LimitInputStream(this.bufferedIn);
                }
            } else {
                return null;
            }
            this.logicalDataIn = new FormatIdInputStream(this.limitIn);
            this.recordHeader = new StoredRecordHeader();
            this.recordHeader.read(this.logicalDataIn);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDF1.S", iOException, this.file);
        }
        return this;
    }

    protected void close() {
        try {
            if (this.fileIn != null) {
                this.fileIn.close();
                this.fileIn = null;
                if (this.dataFactory.databaseEncrypted()) {
                    this.decryptIn.close();
                    this.decryptIn = null;
                } else {
                    this.bufferedIn.close();
                    this.bufferedIn = null;
                }
                this.logicalDataIn.close();
                this.logicalDataIn = null;
            }
            if (this.fileOut != null) {
                this.fileOut.close();
                this.logicalDataOut.close();
                this.fileOut = null;
                this.logicalDataOut = null;
                this.out = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getTypeFormatId() {
        return 290;
    }

    public void getContainerProperties(Properties properties) throws StandardException {
        AccessFactory accessFactory = (AccessFactory)StreamFileContainer.getServiceModule(this.dataFactory, "org.apache.derby.iapi.store.access.AccessFactory");
        TransactionController transactionController = accessFactory == null ? null : accessFactory.getTransaction(StreamFileContainer.getContextService().getCurrentContextManager());
        this.bufferSize = PropertyUtil.getServiceInt(transactionController, properties, "derby.storage.streamFileBufferSize", 1024, Integer.MAX_VALUE, 16384);
    }

    public ContainerKey getIdentity() {
        return this.identity;
    }

    protected boolean use(StreamContainerHandle streamContainerHandle) throws StandardException {
        return true;
    }

    public void load(RowSource rowSource) throws StandardException {
        this.out = new DynamicByteArrayOutputStream(this.bufferSize);
        this.logicalDataOut = new FormatIdOutputStream(this.out);
        boolean bl2 = this.dataFactory.databaseEncrypted();
        if (bl2) {
            if (this.zeroBytes == null) {
                this.zeroBytes = new byte[this.dataFactory.getEncryptionBlockSize() - 1];
            }
            this.out.write(this.zeroBytes, 0, this.dataFactory.getEncryptionBlockSize() - 1);
        }
        try {
            int n2;
            int n3;
            this.fileOut = this.privGetOutputStream(this.file);
            FormatableBitSet formatableBitSet = rowSource.getValidColumns();
            DataValueDescriptor[] dataValueDescriptorArray = rowSource.getNextRowFromRowSource();
            int n4 = 0;
            if (formatableBitSet != null) {
                for (n3 = formatableBitSet.getLength() - 1; n3 >= 0; --n3) {
                    if (!formatableBitSet.isSet(n3)) continue;
                    n4 = n3 + 1;
                    break;
                }
            } else {
                n4 = dataValueDescriptorArray.length;
            }
            this.recordHeader = new StoredRecordHeader(0, n4);
            n3 = this.recordHeader.write(this.out);
            int n5 = n2 = formatableBitSet == null ? 0 : formatableBitSet.getLength();
            while (dataValueDescriptorArray != null) {
                int n6 = -1;
                for (int i2 = 0; i2 < n4; ++i2) {
                    DataValueDescriptor dataValueDescriptor;
                    if (formatableBitSet == null) {
                        dataValueDescriptor = dataValueDescriptorArray[++n6];
                        this.writeColumn(dataValueDescriptor);
                    } else if (n2 > i2 && formatableBitSet.isSet(i2)) {
                        dataValueDescriptor = dataValueDescriptorArray[++n6];
                        this.writeColumn(dataValueDescriptor);
                    } else {
                        this.writeColumn(null);
                    }
                    if (this.out.getUsed() < this.bufferSize && this.bufferSize - this.out.getUsed() >= 1024) continue;
                    this.writeToFile();
                }
                dataValueDescriptorArray = rowSource.getNextRowFromRowSource();
            }
            if (bl2) {
                if (this.out.getUsed() > this.dataFactory.getEncryptionBlockSize() - 1) {
                    this.writeToFile();
                }
            } else if (this.out.getUsed() > 0) {
                this.writeToFile();
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile() throws StandardException {
        block17: {
            try {
                if (this.dataFactory.databaseEncrypted()) {
                    int n2 = this.out.getUsed() - (this.dataFactory.getEncryptionBlockSize() - 1);
                    int n3 = n2 % this.dataFactory.getEncryptionBlockSize();
                    int n4 = n3 == 0 ? 0 : this.dataFactory.getEncryptionBlockSize() - n3;
                    int n5 = n3 == 0 ? this.dataFactory.getEncryptionBlockSize() - 1 : n3 - 1;
                    int n6 = n2 + n4;
                    if (n2 <= 0) {
                        return;
                    }
                    if (this.ciphertext == null) {
                        this.ciphertext = new byte[n6];
                    } else if (this.ciphertext.length < n6) {
                        this.ciphertext = new byte[n6];
                    }
                    this.dataFactory.encrypt(this.out.getByteArray(), n5, n6, this.ciphertext, 0, false);
                    CompressedNumber.writeInt(this.fileOut, n2);
                    this.dataFactory.writeInProgress();
                    try {
                        this.fileOut.write(this.ciphertext, 0, n6);
                    }
                    finally {
                        this.dataFactory.writeFinished();
                    }
                    this.out.reset();
                    if (this.dataFactory.databaseEncrypted()) {
                        if (this.zeroBytes == null) {
                            this.zeroBytes = new byte[this.dataFactory.getEncryptionBlockSize() - 1];
                        }
                        this.out.write(this.zeroBytes, 0, this.dataFactory.getEncryptionBlockSize() - 1);
                    }
                    break block17;
                }
                if (this.out.getUsed() == 0) {
                    return;
                }
                this.dataFactory.writeInProgress();
                try {
                    this.fileOut.write(this.out.getByteArray(), 0, this.out.getUsed());
                }
                finally {
                    this.dataFactory.writeFinished();
                }
                this.out.reset();
            }
            catch (IOException iOException) {
                throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
            }
        }
    }

    private void writeColumn(Object object) throws StandardException, IOException {
        Object object2;
        Storable storable;
        int n2 = FIELD_STATUS;
        if (object == null) {
            n2 = StoredFieldHeader.setNonexistent(n2);
            StoredFieldHeader.write(this.out, n2, 0, 4);
            return;
        }
        if (object instanceof Storable && (storable = (Storable)object).isNull()) {
            n2 = StoredFieldHeader.setNull(n2, true);
            StoredFieldHeader.write(this.out, n2, 0, 4);
            return;
        }
        int n3 = this.out.getPosition();
        int n4 = 0;
        StoredFieldHeader.write(this.out, n2, n4, 4);
        if (object instanceof StreamStorable && ((StreamStorable)object).returnStream() != null) {
            object = ((StreamStorable)object).returnStream();
        }
        if (object instanceof InputStream) {
            int n5;
            object2 = (InputStream)object;
            int n6 = Math.min(Math.max(((InputStream)object2).available(), 64), 8192);
            byte[] byArray = new byte[n6];
            while ((n5 = ((InputStream)object2).read(byArray)) != -1) {
                n4 += n5;
                this.out.write(byArray, 0, n5);
            }
        } else if (object instanceof Storable) {
            object2 = (Storable)object;
            object2.writeExternal(this.logicalDataOut);
            n4 = this.out.getPosition() - n3 - FIELD_HEADER_SIZE;
        } else {
            this.logicalDataOut.writeObject(object);
            n4 = this.out.getPosition() - n3 - FIELD_HEADER_SIZE;
        }
        int n7 = this.out.getPosition();
        this.out.setPosition(n3);
        StoredFieldHeader.write(this.out, n2, n4, 4);
        if (!StoredFieldHeader.isNull(n2)) {
            this.out.setPosition(n7);
        }
    }

    public boolean fetchNext(Object[] objectArray) throws StandardException {
        boolean bl2 = false;
        int n2 = 0;
        try {
            int n3 = this.recordHeader.getNumberFields();
            int n4 = 0;
            for (n2 = 0; n2 < n3 && n4 < objectArray.length; ++n2) {
                Object object;
                this.limitIn.clearLimit();
                int n5 = StoredFieldHeader.readStatus(this.logicalDataIn);
                int n6 = StoredFieldHeader.readFieldDataLength(this.logicalDataIn, n5, 4);
                this.limitIn.setLimit(n6);
                Object object2 = objectArray[n4];
                if (StoredFieldHeader.isNullable(n5)) {
                    if (object2 == null) {
                        throw StandardException.newException("XSDA6.S", Integer.toString(n2));
                    }
                    if (!(object2 instanceof Storable)) {
                        throw StandardException.newException("XSDA6.S", object2.getClass().getName());
                    }
                    object = (Storable)object2;
                    if (StoredFieldHeader.isNull(n5)) {
                        object.restoreToNull();
                        ++n4;
                        continue;
                    }
                    bl2 = true;
                    object.readExternal(this.logicalDataIn);
                    bl2 = false;
                    ++n4;
                    continue;
                }
                if (StoredFieldHeader.isNull(n5)) {
                    throw StandardException.newException("XSDA6.S", Integer.toString(n2));
                }
                object = objectArray[n4];
                if (object instanceof Externalizable) {
                    Externalizable externalizable = (Externalizable)object;
                    bl2 = true;
                    externalizable.readExternal(this.logicalDataIn);
                    bl2 = false;
                    ++n4;
                    continue;
                }
                object = null;
                bl2 = true;
                objectArray[n4] = this.logicalDataIn.readObject();
                bl2 = false;
                ++n4;
            }
        }
        catch (IOException iOException) {
            if (bl2) {
                if (iOException instanceof EOFException) {
                    throw StandardException.newException("XSDA7.S", iOException, this.logicalDataIn.getErrorInfo());
                }
                throw StandardException.newException("XSDA8.S", iOException, this.logicalDataIn.getErrorInfo());
            }
            if (iOException instanceof InvalidClassException) {
                throw StandardException.newException("XSDA8.S", iOException, this.logicalDataIn.getErrorInfo());
            }
            if (iOException instanceof EOFException && n2 == 0) {
                this.close();
                return false;
            }
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB9.D", iOException, this.identity));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw StandardException.newException("XSDA9.S", classNotFoundException, this.logicalDataIn.getErrorInfo());
        }
        catch (LinkageError linkageError) {
            if (bl2) {
                throw StandardException.newException("XSDA8.S", linkageError, this.logicalDataIn.getErrorInfo());
            }
            throw linkageError;
        }
        return true;
    }

    public boolean removeContainer() throws StandardException {
        this.close();
        if (this.privExists(this.file)) {
            return this.privDelete(this.file);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StorageFile getFileName(ContainerKey containerKey, boolean bl2, boolean bl3) throws StandardException {
        if (containerKey.getSegmentId() == -1L) {
            return this.dataFactory.storageFactory.newStorageFile(this.dataFactory.storageFactory.getTempDir(), "T" + containerKey.getContainerId() + ".tmp");
        }
        StorageFile storageFile = this.dataFactory.getContainerPath(containerKey, false);
        if (!this.privExists(storageFile)) {
            if (!bl2) {
                return null;
            }
            StorageFile storageFile2 = storageFile.getParentDir();
            if (!this.privExists(storageFile2)) {
                BaseDataFileFactory baseDataFileFactory = this.dataFactory;
                synchronized (baseDataFileFactory) {
                    if (!this.privExists(storageFile2)) {
                        boolean bl4 = false;
                        IOException iOException = null;
                        try {
                            bl4 = this.privMkdirs(storageFile2);
                        }
                        catch (IOException iOException2) {
                            iOException = iOException2;
                        }
                        if (!bl4) {
                            if (bl3) {
                                return null;
                            }
                            throw StandardException.newException("XSDF3.S", iOException, storageFile2);
                        }
                    }
                }
            }
        }
        return storageFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privExists(StorageFile storageFile) {
        this.actionCode = 1;
        this.actionStorageFile = storageFile;
        try {
            Object object = AccessController.doPrivileged(this);
            boolean bl2 = (Boolean)object;
            return bl2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    private synchronized boolean privMkdirs(StorageFile storageFile) throws IOException {
        this.actionCode = 3;
        this.actionStorageFile = storageFile;
        try {
            Object object = AccessController.doPrivileged(this);
            boolean bl2 = (Boolean)object;
            return bl2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privDelete(StorageFile storageFile) {
        this.actionCode = 2;
        this.actionStorageFile = storageFile;
        try {
            Object object = AccessController.doPrivileged(this);
            boolean bl2 = (Boolean)object;
            return bl2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    private synchronized OutputStream privGetOutputStream(StorageFile storageFile) throws FileNotFoundException {
        this.actionCode = 4;
        this.actionStorageFile = storageFile;
        try {
            OutputStream outputStream = (OutputStream)AccessController.doPrivileged(this);
            return outputStream;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getException();
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    private synchronized InputStream privGetInputStream(StorageFile storageFile) throws FileNotFoundException {
        this.actionCode = 5;
        this.actionStorageFile = storageFile;
        try {
            InputStream inputStream = (InputStream)AccessController.doPrivileged(this);
            return inputStream;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getException();
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    @Override
    public Object run() throws IOException {
        switch (this.actionCode) {
            case 1: {
                return this.actionStorageFile.exists();
            }
            case 2: {
                return this.actionStorageFile.delete();
            }
            case 3: {
                boolean bl2 = this.actionStorageFile.mkdirs();
                this.actionStorageFile.limitAccessToOwner();
                return bl2;
            }
            case 4: {
                return this.actionStorageFile.getOutputStream();
            }
            case 5: {
                return this.actionStorageFile.getInputStream();
            }
        }
        return null;
    }

    private static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static Object getServiceModule(final Object object, final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Monitor.getServiceModule(object, string);
            }
        });
    }
}

