/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.ArrayOutputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DataInputUtil;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.ErrorObjectInput;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.PageTimeStamp;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.ByteHolder;
import org.apache.derby.impl.store.raw.data.CachedPage;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.LongColumnException;
import org.apache.derby.impl.store.raw.data.MemByteHolder;
import org.apache.derby.impl.store.raw.data.NoSpaceOnPage;
import org.apache.derby.impl.store.raw.data.OverflowInputStream;
import org.apache.derby.impl.store.raw.data.PageCreationArgs;
import org.apache.derby.impl.store.raw.data.PageVersion;
import org.apache.derby.impl.store.raw.data.RawField;
import org.apache.derby.impl.store.raw.data.ReclaimSpace;
import org.apache.derby.impl.store.raw.data.RememberBytesInputStream;
import org.apache.derby.impl.store.raw.data.StoredFieldHeader;
import org.apache.derby.impl.store.raw.data.StoredRecordHeader;

public class StoredPage
extends CachedPage {
    public static final int FORMAT_NUMBER = 117;
    protected static final int PAGE_HEADER_OFFSET = 4;
    protected static final int PAGE_HEADER_SIZE = 56;
    protected static final int RECORD_SPACE_OFFSET = 60;
    protected static final int PAGE_VERSION_OFFSET = 6;
    protected static final int SMALL_SLOT_SIZE = 2;
    protected static final int LARGE_SLOT_SIZE = 4;
    protected static final int CHECKSUM_SIZE = 8;
    protected static final int OVERFLOW_POINTER_SIZE = 12;
    protected static final int OVERFLOW_PTR_FIELD_SIZE = 14;
    ByteHolder bh = null;
    protected static final int COLUMN_NONE = 0;
    protected static final int COLUMN_FIRST = 1;
    protected static final int COLUMN_LONG = 2;
    protected static final int COLUMN_CREATE_NULL = 3;
    private int maxFieldSize;
    private boolean isOverflowPage;
    private int slotsInUse;
    private int nextId;
    private int generation;
    private int prevGeneration;
    private long bipLocation;
    private int deletedRowCount;
    private boolean headerOutOfDate;
    private CRC32 checksum;
    protected int minimumRecordSize;
    private int userRowSize;
    private int slotFieldSize;
    private int slotEntrySize;
    private int slotTableOffsetToFirstEntry;
    private int slotTableOffsetToFirstRecordLengthField;
    private int slotTableOffsetToFirstReservedSpaceField;
    protected int totalSpace;
    protected int freeSpace = Integer.MIN_VALUE;
    private int firstFreeByte = Integer.MIN_VALUE;
    protected int spareSpace;
    private StoredRecordHeader overflowRecordHeader;
    protected ArrayInputStream rawDataIn;
    protected ArrayOutputStream rawDataOut;
    protected FormatIdOutputStream logicalDataOut;

    @Override
    public int getTypeFormatId() {
        return 117;
    }

    private StoredRecordHeader getOverFlowRecordHeader() throws StandardException {
        return this.overflowRecordHeader != null ? this.overflowRecordHeader : (this.overflowRecordHeader = new StoredRecordHeader());
    }

    @Override
    protected void initialize() {
        super.initialize();
        if (this.rawDataIn == null) {
            this.rawDataIn = new ArrayInputStream();
            this.checksum = new CRC32();
        }
        if (this.pageData != null) {
            this.rawDataIn.setData(this.pageData);
        }
    }

    private void createOutStreams() {
        this.rawDataOut = new ArrayOutputStream();
        this.rawDataOut.setData(this.pageData);
        this.logicalDataOut = new FormatIdOutputStream(this.rawDataOut);
    }

    private void setOutputStream(OutputStream outputStream) {
        if (this.rawDataOut == null) {
            this.createOutStreams();
        }
        this.logicalDataOut.setOutput(outputStream);
    }

    private void resetOutputStream() {
        this.logicalDataOut.setOutput(this.rawDataOut);
    }

    @Override
    protected void usePageBuffer(byte[] byArray) {
        this.pageData = byArray;
        int n2 = this.pageData.length;
        if (this.rawDataIn != null) {
            this.rawDataIn.setData(this.pageData);
        }
        this.slotFieldSize = this.calculateSlotFieldSize(n2);
        this.slotEntrySize = 3 * this.slotFieldSize;
        this.initSpace();
        this.slotTableOffsetToFirstEntry = n2 - 8 - this.slotEntrySize;
        this.slotTableOffsetToFirstRecordLengthField = this.slotTableOffsetToFirstEntry + this.slotFieldSize;
        this.slotTableOffsetToFirstReservedSpaceField = this.slotTableOffsetToFirstEntry + 2 * this.slotFieldSize;
        if (this.rawDataOut != null) {
            this.rawDataOut.setData(this.pageData);
        }
    }

    private int calculateSlotFieldSize(int n2) {
        if (n2 < 65536) {
            return 2;
        }
        return 4;
    }

    @Override
    protected void createPage(PageKey pageKey, PageCreationArgs pageCreationArgs) throws StandardException {
        this.spareSpace = pageCreationArgs.spareSpace;
        this.minimumRecordSize = pageCreationArgs.minimumRecordSize;
        this.setPageArray(pageCreationArgs.pageSize);
        this.cleanPage();
        this.setPageVersion(0L);
        this.nextId = 6;
        this.generation = 0;
        this.prevGeneration = 0;
        this.bipLocation = 0L;
        this.createOutStreams();
    }

    @Override
    protected void initFromData(FileContainer fileContainer, PageKey pageKey) throws StandardException {
        if (fileContainer != null) {
            this.spareSpace = fileContainer.getSpareSpace();
            this.minimumRecordSize = fileContainer.getMinimumRecordSize();
        }
        try {
            this.validateChecksum(pageKey);
        }
        catch (StandardException standardException) {
            if (standardException.getMessageId().equals("XSDG2.D")) {
                int n2 = this.getPageSize();
                byte[] byArray = this.pageData;
                this.pageData = null;
                this.setPageArray(n2);
                try {
                    fileContainer.readPage(pageKey.getPageNumber(), this.pageData);
                }
                catch (IOException iOException) {
                    throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, pageKey));
                }
                try {
                    this.validateChecksum(pageKey);
                }
                catch (StandardException standardException2) {
                    throw this.dataFactory.markCorrupt(standardException);
                }
                String string = StoredPage.pagedataToHexDump(byArray);
                String string2 = StoredPage.pagedataToHexDump(byArray);
                throw StandardException.newException("XSDFD.S", standardException, pageKey, string, string2);
            }
            throw standardException;
        }
        try {
            this.readPageHeader();
            this.initSlotTable(pageKey);
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, pageKey));
        }
    }

    protected void validateChecksum(PageKey pageKey) throws StandardException {
        long l2;
        try {
            this.rawDataIn.setPosition(this.getPageSize() - 8);
            l2 = this.rawDataIn.readLong();
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, pageKey));
        }
        this.checksum.reset();
        this.checksum.update(this.pageData, 0, this.getPageSize() - 8);
        if (l2 != this.checksum.getValue()) {
            CRC32 cRC32 = new CRC32();
            cRC32.reset();
            cRC32.update(this.pageData, 0, this.getPageSize() - 8);
            if (l2 != cRC32.getValue()) {
                throw StandardException.newException("XSDG2.D", pageKey, this.checksum.getValue(), l2, StoredPage.pagedataToHexDump(this.pageData));
            }
            this.checksum = cRC32;
        }
    }

    protected void updateChecksum() throws IOException {
        this.checksum.reset();
        this.checksum.update(this.pageData, 0, this.getPageSize() - 8);
        this.rawDataOut.setPosition(this.getPageSize() - 8);
        this.logicalDataOut.writeLong(this.checksum.getValue());
    }

    @Override
    protected void writePage(PageKey pageKey) throws StandardException {
        try {
            if (this.headerOutOfDate) {
                this.updatePageHeader();
            } else {
                this.updatePageVersion();
            }
            this.updateChecksum();
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, pageKey));
        }
    }

    @Override
    protected void writeFormatId(PageKey pageKey) throws StandardException {
        try {
            if (this.rawDataOut == null) {
                this.createOutStreams();
            }
            this.rawDataOut.setPosition(0);
            FormatIdUtil.writeFormatIdInteger(this.logicalDataOut, this.getTypeFormatId());
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, pageKey));
        }
    }

    @Override
    protected void releaseExclusive() {
        super.releaseExclusive();
        this.pageCache.release(this);
    }

    @Override
    public int getTotalSpace(int n2) throws StandardException {
        try {
            this.rawDataIn.setPosition(this.getSlotOffset(n2) + this.slotFieldSize);
            return this.slotFieldSize == 2 ? this.rawDataIn.readUnsignedShort() + this.rawDataIn.readUnsignedShort() : this.rawDataIn.readInt() + this.rawDataIn.readInt();
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, this.getPageId()));
        }
    }

    @Override
    public boolean spaceForInsert() throws StandardException {
        if (this.slotsInUse == 0) {
            return true;
        }
        if (!this.allowInsert()) {
            return false;
        }
        int n2 = this.totalSpace - this.freeSpace;
        int n3 = n2 / this.slotsInUse;
        return n3 <= this.freeSpace;
    }

    @Override
    public boolean spaceForInsert(Object[] objectArray, FormatableBitSet formatableBitSet, int n2) throws StandardException {
        if (this.slotsInUse == 0) {
            return true;
        }
        if (!this.allowInsert()) {
            return false;
        }
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream();
        try {
            this.logRow(0, true, this.nextId, objectArray, formatableBitSet, dynamicByteArrayOutputStream, 0, (byte)1, -1, -1, n2);
        }
        catch (NoSpaceOnPage noSpaceOnPage) {
            return false;
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
        return true;
    }

    private boolean spaceForInsert(Object[] objectArray, FormatableBitSet formatableBitSet, int n2, int n3, int n4) throws StandardException {
        if (!this.spaceForInsert() || this.freeSpace < n2) {
            return false;
        }
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream();
        try {
            this.logRow(0, true, this.nextId, objectArray, formatableBitSet, dynamicByteArrayOutputStream, n3, (byte)1, -1, -1, n4);
        }
        catch (NoSpaceOnPage noSpaceOnPage) {
            return false;
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
        return true;
    }

    @Override
    public boolean unfilled() {
        return this.allowInsert() && this.freeSpace > this.getPageSize() / 2;
    }

    @Override
    public boolean allowInsert() {
        if (this.slotsInUse == 0) {
            return true;
        }
        int n2 = this.freeSpace;
        if ((n2 -= this.slotEntrySize) < this.minimumRecordSize || n2 < 17) {
            return false;
        }
        return n2 * 100 / this.totalSpace >= this.spareSpace;
    }

    @Override
    public boolean spaceForCopy(int n2, int[] nArray) {
        int n3 = this.slotEntrySize * n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] <= 0) continue;
            n3 += nArray[i2] >= this.minimumRecordSize ? nArray[i2] : this.minimumRecordSize;
        }
        return this.freeSpace - n3 >= 0;
    }

    protected boolean spaceForCopy(int n2, int n3) {
        int n4 = this.slotEntrySize + ((n2 = n2 - StoredRecordHeader.getStoredSizeRecordId(n3) + StoredRecordHeader.getStoredSizeRecordId(this.nextId)) >= this.minimumRecordSize ? n2 : this.minimumRecordSize);
        return this.freeSpace - n4 >= 0;
    }

    @Override
    protected boolean restoreRecordFromSlot(int n2, Object[] objectArray, FetchDescriptor fetchDescriptor, RecordHandle recordHandle, StoredRecordHeader storedRecordHeader, boolean bl2) throws StandardException {
        try {
            int n3 = this.getRecordOffset(n2) + storedRecordHeader.size();
            ArrayInputStream arrayInputStream = this.rawDataIn;
            arrayInputStream.setPosition(n3);
            if (!storedRecordHeader.hasOverflow()) {
                if (bl2 && fetchDescriptor != null && fetchDescriptor.getQualifierList() != null) {
                    fetchDescriptor.reset();
                    if (!this.qualifyRecordFromSlot(objectArray, n3, fetchDescriptor, storedRecordHeader, recordHandle)) {
                        return false;
                    }
                    arrayInputStream.setPosition(n3);
                }
                if (fetchDescriptor != null) {
                    this.readRecordFromArray(objectArray, fetchDescriptor.getValidColumns() == null ? objectArray.length - 1 : fetchDescriptor.getMaxFetchColumnId(), fetchDescriptor.getValidColumnsArray(), fetchDescriptor.getMaterializedColumns(), arrayInputStream, storedRecordHeader, recordHandle);
                } else {
                    this.readRecordFromArray(objectArray, objectArray.length - 1, null, null, arrayInputStream, storedRecordHeader, recordHandle);
                }
                return true;
            }
            if (fetchDescriptor != null) {
                if (fetchDescriptor.getQualifierList() != null) {
                    fetchDescriptor.reset();
                }
                this.readRecordFromArray(objectArray, fetchDescriptor.getValidColumns() == null ? objectArray.length - 1 : fetchDescriptor.getMaxFetchColumnId(), fetchDescriptor.getValidColumnsArray(), fetchDescriptor.getMaterializedColumns(), arrayInputStream, storedRecordHeader, recordHandle);
            } else {
                this.readRecordFromArray(objectArray, objectArray.length - 1, null, null, arrayInputStream, storedRecordHeader, recordHandle);
            }
            while (storedRecordHeader != null) {
                StoredPage storedPage = this.getOverflowPage(storedRecordHeader.getOverflowPage());
                storedRecordHeader = storedPage.restoreLongRecordFromSlot(objectArray, fetchDescriptor, recordHandle, storedRecordHeader);
                storedPage.unlatch();
                storedPage = null;
            }
            return fetchDescriptor == null || fetchDescriptor.getQualifierList() == null || this.qualifyRecordFromRow(objectArray, fetchDescriptor.getQualifierList());
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, this.getPageId()));
        }
    }

    private StoredRecordHeader restoreLongRecordFromSlot(Object[] objectArray, FetchDescriptor fetchDescriptor, RecordHandle recordHandle, StoredRecordHeader storedRecordHeader) throws StandardException {
        int n2 = this.findRecordById(storedRecordHeader.getOverflowId(), 0);
        StoredRecordHeader storedRecordHeader2 = this.getHeaderAtSlot(n2);
        try {
            int n3 = this.getRecordOffset(n2) + storedRecordHeader2.size();
            ArrayInputStream arrayInputStream = this.rawDataIn;
            arrayInputStream.setPosition(n3);
            if (fetchDescriptor != null) {
                if (fetchDescriptor.getQualifierList() != null) {
                    fetchDescriptor.reset();
                }
                this.readRecordFromArray(objectArray, fetchDescriptor.getValidColumns() == null ? objectArray.length - 1 : fetchDescriptor.getMaxFetchColumnId(), fetchDescriptor.getValidColumnsArray(), fetchDescriptor.getMaterializedColumns(), arrayInputStream, storedRecordHeader2, recordHandle);
            } else {
                this.readRecordFromArray(objectArray, objectArray.length - 1, null, null, arrayInputStream, storedRecordHeader2, recordHandle);
            }
            return storedRecordHeader2.hasOverflow() ? storedRecordHeader2 : null;
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, this.getPageId()));
        }
    }

    @Override
    public int newRecordId() {
        return this.nextId;
    }

    @Override
    public int newRecordIdAndBump() {
        this.headerOutOfDate = true;
        return this.nextId++;
    }

    @Override
    protected int newRecordId(int n2) {
        return n2 + 1;
    }

    @Override
    public boolean isOverflowPage() {
        return this.isOverflowPage;
    }

    public final int getPageSize() {
        return this.pageData.length;
    }

    protected final void clearSection(int n2, int n3) {
        Arrays.fill(this.pageData, n2, n2 + n3, (byte)0);
    }

    protected int getMaxFreeSpace() {
        return this.getPageSize() - 60 - 8;
    }

    protected int getCurrentFreeSpace() {
        return this.freeSpace;
    }

    private void readPageHeader() throws IOException {
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(4);
        this.isOverflowPage = arrayInputStream.readBoolean();
        this.setPageStatus(arrayInputStream.readByte());
        this.setPageVersion(arrayInputStream.readLong());
        this.slotsInUse = arrayInputStream.readUnsignedShort();
        this.nextId = arrayInputStream.readInt();
        this.generation = arrayInputStream.readInt();
        this.prevGeneration = arrayInputStream.readInt();
        this.bipLocation = arrayInputStream.readLong();
        this.deletedRowCount = arrayInputStream.readUnsignedShort() - 1;
        long l2 = arrayInputStream.readUnsignedShort();
        l2 = arrayInputStream.readInt();
        l2 = arrayInputStream.readLong();
        l2 = arrayInputStream.readLong();
    }

    private void updatePageHeader() throws IOException {
        this.rawDataOut.setPosition(4);
        this.logicalDataOut.writeBoolean(this.isOverflowPage);
        this.logicalDataOut.writeByte(this.getPageStatus());
        this.logicalDataOut.writeLong(this.getPageVersion());
        this.logicalDataOut.writeShort(this.slotsInUse);
        this.logicalDataOut.writeInt(this.nextId);
        this.logicalDataOut.writeInt(this.generation);
        this.logicalDataOut.writeInt(this.prevGeneration);
        this.logicalDataOut.writeLong(this.bipLocation);
        this.logicalDataOut.writeShort(this.deletedRowCount + 1);
        this.logicalDataOut.writeShort(0);
        this.logicalDataOut.writeInt(this.dataFactory.random());
        this.logicalDataOut.writeLong(0L);
        this.logicalDataOut.writeLong(0L);
        this.headerOutOfDate = false;
    }

    private void updatePageVersion() throws IOException {
        this.rawDataOut.setPosition(6);
        this.logicalDataOut.writeLong(this.getPageVersion());
    }

    private int getSlotOffset(int n2) {
        return this.slotTableOffsetToFirstEntry - n2 * this.slotEntrySize;
    }

    private int getRecordOffset(int n2) {
        byte[] byArray = this.pageData;
        int n3 = this.slotTableOffsetToFirstEntry - n2 * this.slotEntrySize;
        return this.slotFieldSize == 2 ? (byArray[n3++] & 0xFF) << 8 | byArray[n3] & 0xFF : (byArray[n3++] & 0xFF) << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3] & 0xFF;
    }

    private void setRecordOffset(int n2, int n3) throws IOException {
        this.rawDataOut.setPosition(this.getSlotOffset(n2));
        if (this.slotFieldSize == 2) {
            this.logicalDataOut.writeShort(n3);
        } else {
            this.logicalDataOut.writeInt(n3);
        }
    }

    protected int getRecordPortionLength(int n2) throws IOException {
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(this.slotTableOffsetToFirstRecordLengthField - n2 * this.slotEntrySize);
        return this.slotFieldSize == 2 ? arrayInputStream.readUnsignedShort() : arrayInputStream.readInt();
    }

    @Override
    public int getReservedCount(int n2) throws IOException {
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(this.slotTableOffsetToFirstReservedSpaceField - n2 * this.slotEntrySize);
        return this.slotFieldSize == 2 ? arrayInputStream.readUnsignedShort() : arrayInputStream.readInt();
    }

    private void updateRecordPortionLength(int n2, int n3, int n4) throws IOException {
        this.rawDataOut.setPosition(this.slotTableOffsetToFirstRecordLengthField - n2 * this.slotEntrySize);
        if (this.slotFieldSize == 2) {
            this.logicalDataOut.writeShort(this.getRecordPortionLength(n2) + n3);
        } else {
            this.logicalDataOut.writeInt(this.getRecordPortionLength(n2) + n3);
        }
        if (n4 != 0) {
            if (this.slotFieldSize == 2) {
                this.logicalDataOut.writeShort(this.getReservedCount(n2) + n4);
            } else {
                this.logicalDataOut.writeInt(this.getReservedCount(n2) + n4);
            }
        }
    }

    private void initSlotTable(PageKey pageKey) throws StandardException {
        int n2 = this.slotsInUse;
        this.initializeHeaders(n2);
        this.clearAllSpace();
        this.freeSpace -= n2 * this.slotEntrySize;
        int n3 = -1;
        int n4 = -1;
        try {
            int n5;
            int n6;
            for (n6 = 0; n6 < n2; ++n6) {
                n5 = this.getRecordOffset(n6);
                if (n5 < 60 || n5 >= this.getPageSize() - 8) {
                    throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", pageKey));
                }
                if (n5 <= n4) continue;
                n4 = n5;
                n3 = n6;
            }
            this.bumpRecordCount(n2);
            if (n3 != -1) {
                this.firstFreeByte = n4 + this.getTotalSpace(n3);
                this.freeSpace -= this.firstFreeByte - 60;
            }
            if (this.deletedRowCount == -1) {
                n6 = 0;
                n5 = this.slotsInUse;
                for (int i2 = 0; i2 < n5; ++i2) {
                    if (!this.isDeletedOnPage(i2)) continue;
                    ++n6;
                }
                this.deletedRowCount = n6;
            }
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, pageKey));
        }
    }

    private void setSlotEntry(int n2, int n3, int n4, int n5) throws IOException {
        this.rawDataOut.setPosition(this.getSlotOffset(n2));
        if (this.slotFieldSize == 2) {
            this.logicalDataOut.writeShort(n3);
            this.logicalDataOut.writeShort(n4);
            this.logicalDataOut.writeShort(n5);
        } else {
            this.logicalDataOut.writeInt(n3);
            this.logicalDataOut.writeInt(n4);
            this.logicalDataOut.writeInt(n5);
        }
    }

    private void addSlotEntry(int n2, int n3, int n4, int n5) throws IOException {
        if (n2 < this.slotsInUse) {
            int n6 = this.getSlotOffset(this.slotsInUse - 1);
            int n7 = this.getSlotOffset(n2) + this.slotEntrySize - n6;
            int n8 = this.getSlotOffset(this.slotsInUse);
            System.arraycopy(this.pageData, n6, this.pageData, n8, n7);
        } else {
            int n9 = this.getSlotOffset(n2);
        }
        this.freeSpace -= this.slotEntrySize;
        ++this.slotsInUse;
        this.headerOutOfDate = true;
        this.setSlotEntry(n2, n3, n4, n5);
    }

    private void removeSlotEntry(int n2) throws IOException {
        int n3 = this.getSlotOffset(this.slotsInUse - 1);
        int n4 = this.getSlotOffset(this.slotsInUse - 2);
        if (n2 != this.slotsInUse - 1) {
            int n5 = this.getSlotOffset(n2) - n3;
            System.arraycopy(this.pageData, n3, this.pageData, n4, n5);
        }
        this.clearSection(n3, this.slotEntrySize);
        this.freeSpace += this.slotEntrySize;
        --this.slotsInUse;
        this.headerOutOfDate = true;
    }

    @Override
    public StoredRecordHeader recordHeaderOnDemand(int n2) {
        StoredRecordHeader storedRecordHeader = new StoredRecordHeader(this.pageData, this.getRecordOffset(n2));
        this.setHeaderAtSlot(n2, storedRecordHeader);
        return storedRecordHeader;
    }

    @Override
    public boolean entireRecordOnPage(int n2) throws StandardException {
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n2);
        if (storedRecordHeader.hasOverflow()) {
            return false;
        }
        try {
            int n3 = this.getRecordOffset(n2);
            int n4 = storedRecordHeader.getNumberFields();
            ArrayInputStream arrayInputStream = this.rawDataIn;
            arrayInputStream.setPosition(n3 + storedRecordHeader.size());
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = StoredFieldHeader.readStatus(arrayInputStream);
                if (StoredFieldHeader.isOverflow(n5)) {
                    return false;
                }
                int n6 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n5, this.slotFieldSize);
                if (n6 == 0) continue;
                arrayInputStream.setPosition(arrayInputStream.getPosition() + n6);
            }
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, this.getPageId()));
        }
        return true;
    }

    protected void purgeOverflowAtSlot(int n2, RecordHandle recordHandle, boolean bl2) throws StandardException {
        if (n2 < 0 || n2 >= this.slotsInUse) {
            throw StandardException.newException("XSDA1.S", new Object[0]);
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        int[] nArray = new int[]{this.getHeaderAtSlot(n2).getId()};
        this.owner.getActionSet().actionPurge(rawTransaction, this, n2, 1, nArray, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOneColumnChain(long l2, int n2) throws StandardException {
        StoredPage storedPage = null;
        boolean bl2 = false;
        try {
            while (l2 != -1L) {
                storedPage = this.getOverflowPage(l2);
                bl2 = false;
                if (storedPage == null) {
                    break;
                }
                int n3 = 0;
                RecordHandle recordHandle = storedPage.getNextColumnPiece(n3);
                if (storedPage.recordCount() == 1) {
                    bl2 = true;
                    this.owner.removePage(storedPage);
                } else {
                    storedPage.unlatch();
                    storedPage = null;
                }
                if (recordHandle != null) {
                    l2 = recordHandle.getPageNumber();
                    n2 = recordHandle.getId();
                    continue;
                }
                l2 = -1L;
            }
        }
        finally {
            if (!bl2 && storedPage != null) {
                storedPage.unlatch();
                storedPage = null;
            }
        }
    }

    private void purgeColumnChains(RawTransaction rawTransaction, int n2, RecordHandle recordHandle) throws StandardException {
        try {
            StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n2);
            int n3 = storedRecordHeader.getNumberFields();
            ArrayInputStream arrayInputStream = this.rawDataIn;
            int n4 = this.getRecordOffset(n2) + storedRecordHeader.size();
            arrayInputStream.setPosition(n4);
            for (int i2 = 0; i2 < n3; ++i2) {
                int n5 = StoredFieldHeader.readStatus(arrayInputStream);
                int n6 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n5, this.slotFieldSize);
                if (!StoredFieldHeader.isOverflow(n5)) {
                    if (n6 == 0) continue;
                    arrayInputStream.setPosition(arrayInputStream.getPosition() + n6);
                    continue;
                }
                long l2 = CompressedNumber.readLong(arrayInputStream);
                int n7 = CompressedNumber.readInt(arrayInputStream);
                this.purgeOneColumnChain(l2, n7);
            }
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, this.getPageId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void purgeRowPieces(RawTransaction rawTransaction, int n2, RecordHandle recordHandle, boolean bl2) throws StandardException {
        StoredPage storedPage;
        this.purgeColumnChains(rawTransaction, n2, recordHandle);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n2);
        while (storedRecordHeader.hasOverflow() && (storedPage = this.getOverflowPage(storedRecordHeader.getOverflowPage())) != null) {
            try {
                int n3 = StoredPage.getOverflowSlot(storedPage, storedRecordHeader);
                storedPage.purgeColumnChains(rawTransaction, n3, recordHandle);
                storedRecordHeader = storedPage.getHeaderAtSlot(n3);
                if (n3 == 0 && storedPage.recordCount() == 1) {
                    try {
                        this.owner.removePage(storedPage);
                        continue;
                    }
                    finally {
                        storedPage = null;
                        continue;
                    }
                }
                storedPage.purgeOverflowAtSlot(n3, recordHandle, bl2);
                storedPage.unlatch();
                storedPage = null;
            }
            finally {
                if (storedPage == null) continue;
                storedPage.unlatch();
                storedPage = null;
            }
        }
    }

    void removeOrphanedColumnChain(ReclaimSpace reclaimSpace, ContainerHandle containerHandle) throws StandardException {
        StoredPage storedPage = (StoredPage)containerHandle.getPageNoWait(reclaimSpace.getColumnPageId());
        if (storedPage == null) {
            return;
        }
        boolean bl2 = storedPage.equalTimeStamp(reclaimSpace.getPageTimeStamp());
        storedPage.unlatch();
        if (!bl2) {
            return;
        }
        RecordHandle recordHandle = reclaimSpace.getHeadRowHandle();
        int n2 = this.findRecordById(recordHandle.getId(), recordHandle.getSlotNumberHint());
        if (n2 >= 0) {
            StoredPage storedPage2 = this;
            try {
                int n3 = reclaimSpace.getColumnId();
                StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n2);
                while (storedRecordHeader.getNumberFields() + storedRecordHeader.getFirstField() <= n3) {
                    if (storedPage2 != this) {
                        storedPage2.unlatch();
                        storedPage2 = null;
                    }
                    if (!storedRecordHeader.hasOverflow()) break;
                    storedPage2 = this.getOverflowPage(storedRecordHeader.getOverflowPage());
                    storedRecordHeader = storedPage2.getHeaderAtSlot(StoredPage.getOverflowSlot(storedPage2, storedRecordHeader));
                }
                if (storedRecordHeader.getNumberFields() + storedRecordHeader.getFirstField() > n3 && !storedPage2.isColumnOrphaned(storedRecordHeader, n3, reclaimSpace.getColumnPageId(), reclaimSpace.getColumnRecordId())) {
                    if (storedPage2 != this) {
                        storedPage2.unlatch();
                        storedPage2 = null;
                    }
                    return;
                }
            }
            catch (IOException iOException) {
                throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
            }
            finally {
                if (storedPage2 != this && storedPage2 != null) {
                    storedPage2.unlatch();
                }
            }
        }
        long l2 = reclaimSpace.getColumnPageId();
        int n4 = reclaimSpace.getColumnRecordId();
        this.purgeOneColumnChain(l2, n4);
    }

    private boolean isColumnOrphaned(StoredRecordHeader storedRecordHeader, int n2, long l2, long l3) throws StandardException, IOException {
        int n3;
        int n4 = this.findRecordById(storedRecordHeader.getId(), 0);
        ArrayInputStream arrayInputStream = this.rawDataIn;
        int n5 = this.getRecordOffset(n4);
        arrayInputStream.setPosition(n5 + storedRecordHeader.size());
        for (n3 = storedRecordHeader.getFirstField(); n3 < n2; ++n3) {
            this.skipField(arrayInputStream);
        }
        n3 = StoredFieldHeader.readStatus(arrayInputStream);
        int n6 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n3, this.slotFieldSize);
        if (StoredFieldHeader.isOverflow(n3)) {
            long l4 = CompressedNumber.readLong(arrayInputStream);
            int n7 = CompressedNumber.readInt(arrayInputStream);
            if (l4 == l2 && (long)n7 == l3) {
                return false;
            }
        }
        return true;
    }

    private RecordHandle getNextColumnPiece(int n2) throws StandardException {
        try {
            StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n2);
            int n3 = storedRecordHeader.getNumberFields();
            if (n3 != 2) {
                return null;
            }
            ArrayInputStream arrayInputStream = this.rawDataIn;
            int n4 = this.getRecordOffset(n2) + storedRecordHeader.size();
            arrayInputStream.setPosition(n4);
            this.skipField(arrayInputStream);
            int n5 = StoredFieldHeader.readStatus(arrayInputStream);
            int n6 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n5, this.slotFieldSize);
            long l2 = CompressedNumber.readLong(arrayInputStream);
            int n7 = CompressedNumber.readInt(arrayInputStream);
            return this.owner.makeRecordHandle(l2, n7);
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, this.getPageId()));
        }
    }

    private void initSpace() {
        this.totalSpace = this.getMaxFreeSpace();
        this.maxFieldSize = this.totalSpace - this.slotEntrySize - 16 - 12;
    }

    private void clearAllSpace() {
        this.freeSpace = this.totalSpace;
        this.firstFreeByte = this.getPageSize() - this.totalSpace - 8;
    }

    private void compressPage(int n2, int n3) throws IOException {
        int n4 = n3 + 1 - n2;
        if (n3 + 1 != this.firstFreeByte) {
            int n5 = this.firstFreeByte - n3 - 1;
            System.arraycopy(this.pageData, n3 + 1, this.pageData, n2, n5);
            for (int i2 = 0; i2 < this.slotsInUse; ++i2) {
                int n6 = this.getRecordOffset(i2);
                if (n6 < n3 + 1) continue;
                this.setRecordOffset(i2, n6 -= n4);
            }
        }
        this.freeSpace += n4;
        this.firstFreeByte -= n4;
        this.clearSection(this.firstFreeByte, n4);
    }

    protected void expandPage(int n2, int n3) throws IOException {
        int n4 = this.firstFreeByte - n2;
        if (n4 > 0) {
            System.arraycopy(this.pageData, n2, this.pageData, n2 + n3, n4);
            for (int i2 = 0; i2 < this.slotsInUse; ++i2) {
                int n5 = this.getRecordOffset(i2);
                if (n5 < n2) continue;
                this.setRecordOffset(i2, n5 += n3);
            }
        }
        this.freeSpace -= n3;
        this.firstFreeByte += n3;
    }

    private void shrinkPage(int n2, int n3) throws IOException {
        int n4 = this.firstFreeByte - n2;
        if (n4 > 0) {
            System.arraycopy(this.pageData, n2, this.pageData, n2 - n3, n4);
            for (int i2 = 0; i2 < this.slotsInUse; ++i2) {
                int n5 = this.getRecordOffset(i2);
                if (n5 < n2) continue;
                this.setRecordOffset(i2, n5 -= n3);
            }
        }
        this.freeSpace += n3;
        this.firstFreeByte -= n3;
    }

    @Override
    public int getRecordLength(int n2) throws IOException {
        return this.getRecordPortionLength(n2);
    }

    protected boolean getIsOverflow(int n2) throws IOException {
        return this.getHeaderAtSlot(n2).hasOverflow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int logRow(int n2, boolean bl2, int n3, Object[] objectArray, FormatableBitSet formatableBitSet, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n4, byte by, int n5, int n6, int n7) throws StandardException, IOException {
        if (!bl2 && n5 != -1 && n6 == -1) {
            return n5;
        }
        int n8 = this.freeSpace;
        this.setOutputStream(dynamicByteArrayOutputStream);
        int n9 = dynamicByteArrayOutputStream.getPosition();
        this.userRowSize = 0;
        boolean bl3 = false;
        if (n5 != -1) {
            n8 = n6;
            n9 = dynamicByteArrayOutputStream.getBeginPosition();
        } else {
            if (!bl2) {
                n8 += this.getTotalSpace(n2);
            } else {
                n8 -= this.slotEntrySize;
                if (n4 == 0) {
                    bl3 = true;
                }
            }
            if (n8 <= 0) {
                throw new NoSpaceOnPage(this.isOverflowPage());
            }
        }
        try {
            int n10;
            int n11;
            int n12;
            StoredRecordHeader storedRecordHeader;
            if (objectArray == null) {
                int n13 = this.logOverflowRecord(n2, n8, dynamicByteArrayOutputStream);
                return n13;
            }
            int n14 = 0;
            if (bl2) {
                storedRecordHeader = new StoredRecordHeader();
            } else {
                storedRecordHeader = new StoredRecordHeader(this.getHeaderAtSlot(n2));
                n4 = storedRecordHeader.getFirstField();
            }
            if (formatableBitSet == null) {
                n14 = objectArray.length - n4;
            } else {
                for (n12 = formatableBitSet.getLength() - 1; n12 >= n4; --n12) {
                    if (!formatableBitSet.isSet(n12)) continue;
                    n14 = n12 + 1 - n4;
                    break;
                }
            }
            n12 = -1;
            if (bl2) {
                storedRecordHeader.setId(n3);
                storedRecordHeader.setNumberFields(n14);
            } else {
                n12 = storedRecordHeader.getNumberFields();
                if (n14 > n12) {
                    if (storedRecordHeader.hasOverflow()) {
                        n14 = n12;
                    } else {
                        storedRecordHeader.setNumberFields(n14);
                    }
                } else if (n14 < n12) {
                    if (formatableBitSet == null) {
                        storedRecordHeader.setNumberFields(n14);
                    } else {
                        n14 = n12;
                    }
                }
            }
            int n15 = n4 + n14;
            if (n5 >= n15) {
                int n16 = -1;
                return n16;
            }
            if ((by & 1) != 1) {
                storedRecordHeader.setFirstField(n4);
            }
            int n17 = n5;
            if (n5 == -1) {
                n11 = storedRecordHeader.write(this.logicalDataOut);
                if ((n8 -= n11) < 0) {
                    throw new NoSpaceOnPage(this.isOverflowPage());
                }
                n17 = n4;
            }
            n11 = 0;
            int n18 = n10 = formatableBitSet == null ? 0 : formatableBitSet.getLength();
            if (formatableBitSet != null && !bl2 && formatableBitSet != null && n17 < n4 + n12) {
                this.rawDataIn.setPosition(this.getFieldOffset(n2, n17));
                n11 = 1;
            }
            int n19 = n8;
            int n20 = 0;
            int n21 = dynamicByteArrayOutputStream.getPosition();
            int n22 = n4;
            if (n8 > 12) {
                n21 = -1;
            }
            int n23 = 1;
            for (int i2 = n17; i2 < n15; ++i2) {
                int n24;
                int n25;
                block63: {
                    Object object = null;
                    boolean bl4 = false;
                    if (formatableBitSet == null || n10 > i2 && formatableBitSet.isSet(i2)) {
                        if (i2 < objectArray.length) {
                            object = objectArray[i2];
                        }
                    } else if (!bl2) {
                        bl4 = true;
                    }
                    if (n8 > 12) {
                        n21 = dynamicByteArrayOutputStream.getPosition();
                        n22 = i2;
                    }
                    n19 = n8;
                    if (bl4) {
                        if (i2 < n4 + n12) {
                            n25 = this.rawDataIn.getPosition();
                            this.skipField(this.rawDataIn);
                            n24 = this.rawDataIn.getPosition() - n25;
                            if (n24 <= n8) {
                                this.logColumn(null, 0, dynamicByteArrayOutputStream, Integer.MAX_VALUE, 0, n7);
                                n8 -= n24;
                            }
                        } else {
                            n8 = this.logColumn(null, 0, dynamicByteArrayOutputStream, n8, 3, n7);
                        }
                    } else {
                        if (n11 != 0 && i2 < n4 + n12) {
                            this.skipField(this.rawDataIn);
                        }
                        try {
                            n8 = object == null ? this.logColumn(null, 0, dynamicByteArrayOutputStream, n8, n23, n7) : this.logColumn(objectArray, i2, dynamicByteArrayOutputStream, n8, n23, n7);
                        }
                        catch (LongColumnException longColumnException) {
                            if ((by & 1) == 1) {
                                if (longColumnException.getColumn() instanceof InputStream && objectArray[i2] instanceof StreamStorable && (objectArray[i2] instanceof InputStream || ((StreamStorable)objectArray[i2]).returnStream() != null)) {
                                    ((StreamStorable)objectArray[i2]).setStream((InputStream)longColumnException.getColumn());
                                }
                                throw new NoSpaceOnPage(this.isOverflowPage());
                            }
                            if ((n8 < 14 || i2 != n15 - 1) && (n8 < 28 || i2 >= n15 - 1)) break block63;
                            dynamicByteArrayOutputStream.setBeginPosition(n9);
                            longColumnException.setExceptionInfo(dynamicByteArrayOutputStream, i2, n8);
                            throw longColumnException;
                        }
                    }
                }
                int n26 = n24 = n7 == 100 ? 0 : (int)(this.isLong(n20 += n19 - n8, n7) ? 1 : 0);
                if (n19 == n8 || n24 != 0) {
                    if ((by & 1) == 1) {
                        throw new NoSpaceOnPage(this.isOverflowPage());
                    }
                    if (n24 != 0) {
                        dynamicByteArrayOutputStream.setPosition(dynamicByteArrayOutputStream.getPosition() - n20);
                    }
                    n25 = i2;
                } else {
                    n25 = n15;
                }
                if ((n19 == n8 || (by & 0x10) == 16) && n8 < 12) {
                    if (i2 == n4 || n21 < 0) {
                        throw new NoSpaceOnPage(this.isOverflowPage());
                    }
                    dynamicByteArrayOutputStream.setPosition(n21);
                    n25 = n22;
                }
                if (n25 < n15) {
                    int n27;
                    int n28 = n25 - n4;
                    int n29 = storedRecordHeader.size();
                    storedRecordHeader.setNumberFields(n28);
                    int n30 = storedRecordHeader.size();
                    int n31 = dynamicByteArrayOutputStream.getPosition();
                    if (n29 > n30) {
                        n27 = n29 - n30;
                        dynamicByteArrayOutputStream.setBeginPosition(n9 + n27);
                        dynamicByteArrayOutputStream.setPosition(n9 + n27);
                    } else if (n30 > n29) {
                        dynamicByteArrayOutputStream.setPosition(n9);
                    } else {
                        dynamicByteArrayOutputStream.setBeginPosition(n9);
                        dynamicByteArrayOutputStream.setPosition(n9);
                    }
                    n27 = storedRecordHeader.write(this.logicalDataOut);
                    dynamicByteArrayOutputStream.setPosition(n31);
                    if (!bl2 && formatableBitSet != null) {
                        this.handleIncompleteLogRow(n2, n25, formatableBitSet, dynamicByteArrayOutputStream);
                    }
                    int n32 = n25;
                    return n32;
                }
                n23 = 0;
            }
            dynamicByteArrayOutputStream.setBeginPosition(n9);
            n4 = -1;
            if (bl3 && n8 < this.minimumRecordSize - this.userRowSize) {
                throw new NoSpaceOnPage(this.isOverflowPage());
            }
        }
        finally {
            this.resetOutputStream();
        }
        return n4;
    }

    private void handleIncompleteLogRow(int n2, int n3, FormatableBitSet formatableBitSet, DynamicByteArrayOutputStream dynamicByteArrayOutputStream) throws StandardException {
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n2);
        int n4 = storedRecordHeader.getFirstField() + storedRecordHeader.getNumberFields();
        boolean bl2 = false;
        int n5 = formatableBitSet.size();
        for (int i2 = n3; i2 < n4; ++i2) {
            if (n5 > i2 && formatableBitSet.get(i2)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return;
        }
        Object[] objectArray = new Object[n4 - n3];
        ByteArrayOutputStream byteArrayOutputStream = null;
        for (int i3 = n3; i3 < n4; ++i3) {
            if (n5 > i3 && formatableBitSet.get(i3)) continue;
            try {
                if (byteArrayOutputStream == null) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                } else {
                    byteArrayOutputStream.reset();
                }
                this.logField(n2, i3, byteArrayOutputStream);
                objectArray[i3 - n3] = new RawField(byteArrayOutputStream.toByteArray());
                continue;
            }
            catch (IOException iOException) {
                throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, this.getPageId()));
            }
        }
        LongColumnException longColumnException = new LongColumnException();
        longColumnException.setExceptionInfo(dynamicByteArrayOutputStream, n3, -1);
        longColumnException.setColumn(objectArray);
        throw longColumnException;
    }

    @Override
    public void restoreRecordFromStream(LimitObjectInput limitObjectInput, Object[] objectArray) throws StandardException, IOException {
        StoredRecordHeader storedRecordHeader = new StoredRecordHeader();
        storedRecordHeader.read(limitObjectInput);
        this.readRecordFromStream(objectArray, objectArray.length - 1, null, null, limitObjectInput, storedRecordHeader, null);
    }

    private boolean qualifyRecordFromRow(Object[] objectArray, Qualifier[][] qualifierArray) throws StandardException {
        Object object;
        int n2;
        boolean bl2 = true;
        for (n2 = 0; n2 < qualifierArray[0].length; ++n2) {
            bl2 = false;
            Qualifier qualifier = qualifierArray[0][n2];
            object = (DataValueDescriptor)objectArray[qualifier.getColumnId()];
            bl2 = object.compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
            if (qualifier.negateCompareResult()) {
                boolean bl3 = bl2 = !bl2;
            }
            if (bl2) continue;
            return false;
        }
        for (n2 = 1; n2 < qualifierArray.length; ++n2) {
            bl2 = false;
            for (int i2 = 0; i2 < qualifierArray[n2].length; ++i2) {
                object = qualifierArray[n2][i2];
                int n3 = object.getColumnId();
                DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)objectArray[object.getColumnId()];
                bl2 = dataValueDescriptor.compare(object.getOperator(), object.getOrderable(), object.getOrderedNulls(), object.getUnknownRV());
                if (object.negateCompareResult()) {
                    boolean bl4 = bl2 = !bl2;
                }
                if (bl2) break;
            }
            if (!bl2) break;
        }
        return bl2;
    }

    private final void readOneColumnFromPage(Object[] objectArray, int n2, int n3, StoredRecordHeader storedRecordHeader, RecordHandle recordHandle) throws StandardException, IOException {
        ErrorObjectInput errorObjectInput = null;
        ArrayInputStream arrayInputStream = this.rawDataIn;
        try {
            Object object = objectArray[n2];
            if (n2 <= storedRecordHeader.getNumberFields() - 1) {
                int n4;
                for (n4 = n2; n4 > 0; --n4) {
                    n3 += StoredFieldHeader.readTotalFieldLength(this.pageData, n3);
                }
                n4 = StoredFieldHeader.readStatus(this.pageData, n3);
                int n5 = StoredFieldHeader.readFieldLengthAndSetStreamPosition(this.pageData, n3 + 1, n4, this.slotFieldSize, arrayInputStream);
                if (!StoredFieldHeader.isNonexistent(n4)) {
                    boolean bl2 = StoredFieldHeader.isOverflow(n4);
                    OverflowInputStream overflowInputStream = null;
                    if (bl2) {
                        long l2 = CompressedNumber.readLong(arrayInputStream);
                        int n6 = CompressedNumber.readInt(arrayInputStream);
                        MemByteHolder memByteHolder = new MemByteHolder(this.pageData.length);
                        overflowInputStream = new OverflowInputStream(memByteHolder, this.owner, l2, n6, recordHandle);
                    }
                    if (object instanceof DataValueDescriptor) {
                        DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)object;
                        if (StoredFieldHeader.isNull(n4)) {
                            dataValueDescriptor.restoreToNull();
                        } else if (!bl2) {
                            arrayInputStream.setLimit(n5);
                            errorObjectInput = arrayInputStream;
                            dataValueDescriptor.readExternalFromArray(arrayInputStream);
                            errorObjectInput = null;
                            int n7 = arrayInputStream.clearLimit();
                            if (n7 != 0) {
                                DataInputUtil.skipFully(arrayInputStream, n7);
                            }
                        } else {
                            FormatIdInputStream formatIdInputStream = new FormatIdInputStream(overflowInputStream);
                            if (dataValueDescriptor instanceof StreamStorable) {
                                ((StreamStorable)((Object)dataValueDescriptor)).setStream(formatIdInputStream);
                            } else {
                                errorObjectInput = formatIdInputStream;
                                dataValueDescriptor.readExternal(formatIdInputStream);
                                errorObjectInput = null;
                            }
                        }
                    } else {
                        if (StoredFieldHeader.isNull(n4)) {
                            throw StandardException.newException("XSDA6.S", Integer.toString(n2));
                        }
                        arrayInputStream.setLimit(n5);
                        errorObjectInput = arrayInputStream;
                        objectArray[n2] = arrayInputStream.readObject();
                        errorObjectInput = null;
                        int n8 = arrayInputStream.clearLimit();
                        if (n8 != 0) {
                            DataInputUtil.skipFully(arrayInputStream, n8);
                        }
                    }
                } else if (object instanceof DataValueDescriptor) {
                    ((DataValueDescriptor)object).restoreToNull();
                } else {
                    objectArray[n2] = null;
                }
            } else if (object instanceof DataValueDescriptor) {
                ((DataValueDescriptor)object).restoreToNull();
            } else {
                objectArray[n2] = null;
            }
        }
        catch (IOException iOException) {
            if (errorObjectInput != null) {
                arrayInputStream.clearLimit();
                if (iOException instanceof EOFException) {
                    throw StandardException.newException("XSDA7.S", iOException, errorObjectInput.getErrorInfo());
                }
                Exception exception = errorObjectInput.getNestedException();
                if (exception != null) {
                    if (exception instanceof InstantiationException) {
                        throw StandardException.newException("XSDAM.S", exception, errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof IllegalAccessException) {
                        throw StandardException.newException("XSDAN.S", exception, errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof StandardException) {
                        throw (StandardException)exception;
                    }
                }
                throw StandardException.newException("XSDA8.S", iOException, errorObjectInput.getErrorInfo());
            }
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            arrayInputStream.clearLimit();
            throw StandardException.newException("XSDA9.S", classNotFoundException, errorObjectInput.getErrorInfo());
        }
        catch (LinkageError linkageError) {
            if (errorObjectInput != null) {
                arrayInputStream.clearLimit();
                throw StandardException.newException("XSDA8.S", linkageError, errorObjectInput.getErrorInfo());
            }
            throw linkageError;
        }
    }

    private final boolean qualifyRecordFromSlot(Object[] objectArray, int n2, FetchDescriptor fetchDescriptor, StoredRecordHeader storedRecordHeader, RecordHandle recordHandle) throws StandardException, IOException {
        int n3;
        boolean bl2 = true;
        Qualifier[][] qualifierArray = fetchDescriptor.getQualifierList();
        int[] nArray = fetchDescriptor.getMaterializedColumns();
        for (n3 = 0; n3 < qualifierArray[0].length; ++n3) {
            bl2 = false;
            Qualifier qualifier = qualifierArray[0][n3];
            int n4 = qualifier.getColumnId();
            if (nArray[n4] == 0) {
                this.readOneColumnFromPage(objectArray, n4, n2, storedRecordHeader, recordHandle);
                nArray[n4] = n2;
            }
            bl2 = ((DataValueDescriptor)objectArray[n4]).compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
            if (qualifier.negateCompareResult()) {
                boolean bl3 = bl2 = !bl2;
            }
            if (bl2) continue;
            return false;
        }
        for (n3 = 1; n3 < qualifierArray.length; ++n3) {
            bl2 = false;
            for (int i2 = 0; i2 < qualifierArray[n3].length; ++i2) {
                Qualifier qualifier = qualifierArray[n3][i2];
                int n5 = qualifier.getColumnId();
                if (nArray[n5] == 0) {
                    this.readOneColumnFromPage(objectArray, n5, n2, storedRecordHeader, recordHandle);
                    nArray[n5] = n2;
                }
                bl2 = ((DataValueDescriptor)objectArray[n5]).compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
                if (qualifier.negateCompareResult()) {
                    boolean bl4 = bl2 = !bl2;
                }
                if (bl2) break;
            }
            if (!bl2) break;
        }
        return bl2;
    }

    private final boolean readRecordFromStream(Object[] objectArray, int n2, int[] nArray, int[] nArray2, LimitObjectInput limitObjectInput, StoredRecordHeader storedRecordHeader, RecordHandle recordHandle) throws StandardException, IOException {
        ErrorObjectInput errorObjectInput = null;
        try {
            int n3 = storedRecordHeader.getNumberFields();
            int n4 = storedRecordHeader.getFirstField();
            if (n4 > n2) {
                return true;
            }
            int n5 = n3 + n4;
            int n6 = nArray == null ? 0 : nArray.length;
            for (int i2 = n4; i2 <= n2; ++i2) {
                int n7;
                if (nArray != null && (n6 <= i2 || nArray[i2] == 0) || nArray2 != null && nArray2[i2] != 0) {
                    if (i2 >= n5) continue;
                    this.skipField(limitObjectInput);
                    continue;
                }
                if (i2 >= n5) {
                    Object object = objectArray[i2];
                    if (object instanceof DataValueDescriptor) {
                        ((DataValueDescriptor)object).restoreToNull();
                        continue;
                    }
                    objectArray[i2] = null;
                    continue;
                }
                int n8 = StoredFieldHeader.readStatus(limitObjectInput);
                int n9 = StoredFieldHeader.readFieldDataLength(limitObjectInput, n8, this.slotFieldSize);
                Object object = objectArray[i2];
                OverflowInputStream overflowInputStream = null;
                if (StoredFieldHeader.isNonexistent(n8)) {
                    if (object instanceof DataValueDescriptor) {
                        ((DataValueDescriptor)object).restoreToNull();
                        continue;
                    }
                    objectArray[i2] = null;
                    continue;
                }
                boolean bl2 = StoredFieldHeader.isOverflow(n8);
                if (bl2) {
                    long l2 = CompressedNumber.readLong((InputStream)((Object)limitObjectInput));
                    n7 = CompressedNumber.readInt((InputStream)((Object)limitObjectInput));
                    MemByteHolder memByteHolder = new MemByteHolder(this.pageData.length);
                    overflowInputStream = new OverflowInputStream(memByteHolder, this.owner, l2, n7, recordHandle);
                }
                if (object instanceof DataValueDescriptor) {
                    DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)object;
                    if (StoredFieldHeader.isNull(n8)) {
                        dataValueDescriptor.restoreToNull();
                        continue;
                    }
                    if (!bl2) {
                        limitObjectInput.setLimit(n9);
                        errorObjectInput = limitObjectInput;
                        dataValueDescriptor.readExternal(limitObjectInput);
                        errorObjectInput = null;
                        int n10 = limitObjectInput.clearLimit();
                        if (n10 == 0) continue;
                        DataInputUtil.skipFully(limitObjectInput, n10);
                        continue;
                    }
                    FormatIdInputStream formatIdInputStream = new FormatIdInputStream(overflowInputStream);
                    n7 = 1;
                    if (!(dataValueDescriptor instanceof StreamStorable)) {
                        n7 = 0;
                    }
                    if (n7 != 0) {
                        ((StreamStorable)((Object)dataValueDescriptor)).setStream(formatIdInputStream);
                        continue;
                    }
                    errorObjectInput = formatIdInputStream;
                    dataValueDescriptor.readExternal(formatIdInputStream);
                    errorObjectInput = null;
                    continue;
                }
                if (StoredFieldHeader.isNull(n8)) {
                    throw StandardException.newException("XSDA6.S", Integer.toString(i2));
                }
                limitObjectInput.setLimit(n9);
                errorObjectInput = limitObjectInput;
                objectArray[i2] = limitObjectInput.readObject();
                errorObjectInput = null;
                int n11 = limitObjectInput.clearLimit();
                if (n11 == 0) continue;
                DataInputUtil.skipFully(limitObjectInput, n11);
            }
            return n3 + n4 > n2;
        }
        catch (IOException iOException) {
            if (errorObjectInput != null) {
                limitObjectInput.clearLimit();
                if (iOException instanceof EOFException) {
                    throw StandardException.newException("XSDA7.S", iOException, errorObjectInput.getErrorInfo());
                }
                Exception exception = errorObjectInput.getNestedException();
                if (exception != null) {
                    if (exception instanceof InstantiationException) {
                        throw StandardException.newException("XSDAM.S", exception, errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof IllegalAccessException) {
                        throw StandardException.newException("XSDAN.S", exception, errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof StandardException) {
                        throw (StandardException)exception;
                    }
                }
                throw StandardException.newException("XSDA8.S", iOException, errorObjectInput.getErrorInfo());
            }
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            limitObjectInput.clearLimit();
            throw StandardException.newException("XSDA9.S", classNotFoundException, errorObjectInput.getErrorInfo());
        }
        catch (LinkageError linkageError) {
            if (errorObjectInput != null) {
                limitObjectInput.clearLimit();
                throw StandardException.newException("XSDA8.S", linkageError, errorObjectInput.getErrorInfo());
            }
            throw linkageError;
        }
    }

    private final boolean readRecordFromArray(Object[] objectArray, int n2, int[] nArray, int[] nArray2, ArrayInputStream arrayInputStream, StoredRecordHeader storedRecordHeader, RecordHandle recordHandle) throws StandardException, IOException {
        ErrorObjectInput errorObjectInput = null;
        try {
            int n3 = storedRecordHeader.getNumberFields();
            int n4 = storedRecordHeader.getFirstField();
            if (n4 > n2) {
                return true;
            }
            int n5 = n3 + n4;
            int n6 = nArray == null ? 0 : nArray.length;
            int n7 = arrayInputStream.getPosition();
            for (int i2 = n4; i2 <= n2; ++i2) {
                if (nArray != null && (n6 <= i2 || nArray[i2] == 0) || nArray2 != null && nArray2[i2] != 0) {
                    if (i2 >= n5) continue;
                    n7 += StoredFieldHeader.readTotalFieldLength(this.pageData, n7);
                    continue;
                }
                if (i2 < n5) {
                    int n8 = StoredFieldHeader.readStatus(this.pageData, n7);
                    int n9 = StoredFieldHeader.readFieldLengthAndSetStreamPosition(this.pageData, n7 + 1, n8, this.slotFieldSize, arrayInputStream);
                    Object object = objectArray[i2];
                    OverflowInputStream overflowInputStream = null;
                    if ((n8 & 5) != 5) {
                        int n10;
                        boolean bl2;
                        boolean bl3 = bl2 = (n8 & 2) != 0;
                        if (bl2) {
                            long l2 = CompressedNumber.readLong(arrayInputStream);
                            n10 = CompressedNumber.readInt(arrayInputStream);
                            MemByteHolder memByteHolder = new MemByteHolder(this.pageData.length);
                            overflowInputStream = new OverflowInputStream(memByteHolder, this.owner, l2, n10, recordHandle);
                        }
                        if (object instanceof DataValueDescriptor) {
                            DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)object;
                            if ((n8 & 1) == 0) {
                                if (!bl2) {
                                    arrayInputStream.setLimit(n9);
                                    errorObjectInput = arrayInputStream;
                                    dataValueDescriptor.readExternalFromArray(arrayInputStream);
                                    errorObjectInput = null;
                                    int n11 = arrayInputStream.clearLimit();
                                    if (n11 != 0) {
                                        DataInputUtil.skipFully(arrayInputStream, n11);
                                    }
                                } else {
                                    FormatIdInputStream formatIdInputStream = new FormatIdInputStream(overflowInputStream);
                                    n10 = 1;
                                    if (!(dataValueDescriptor instanceof StreamStorable)) {
                                        n10 = 0;
                                    }
                                    if (n10 != 0) {
                                        ((StreamStorable)((Object)dataValueDescriptor)).setStream(formatIdInputStream);
                                    } else {
                                        errorObjectInput = formatIdInputStream;
                                        dataValueDescriptor.readExternal(formatIdInputStream);
                                        errorObjectInput = null;
                                    }
                                }
                            } else {
                                dataValueDescriptor.restoreToNull();
                            }
                        } else {
                            if (StoredFieldHeader.isNull(n8)) {
                                throw StandardException.newException("XSDA6.S", Integer.toString(i2));
                            }
                            arrayInputStream.setLimit(n9);
                            errorObjectInput = arrayInputStream;
                            objectArray[i2] = arrayInputStream.readObject();
                            errorObjectInput = null;
                            int n12 = arrayInputStream.clearLimit();
                            if (n12 != 0) {
                                DataInputUtil.skipFully(arrayInputStream, n12);
                            }
                        }
                    } else if (object instanceof DataValueDescriptor) {
                        ((DataValueDescriptor)object).restoreToNull();
                    } else {
                        objectArray[i2] = null;
                    }
                    n7 = arrayInputStream.getPosition();
                    continue;
                }
                Object object = objectArray[i2];
                if (object instanceof DataValueDescriptor) {
                    ((DataValueDescriptor)object).restoreToNull();
                    continue;
                }
                objectArray[i2] = null;
            }
            return n3 + n4 > n2;
        }
        catch (IOException iOException) {
            if (errorObjectInput != null) {
                arrayInputStream.clearLimit();
                if (iOException instanceof EOFException) {
                    throw StandardException.newException("XSDA7.S", iOException, errorObjectInput.getErrorInfo());
                }
                Exception exception = errorObjectInput.getNestedException();
                if (exception != null) {
                    if (exception instanceof InstantiationException) {
                        throw StandardException.newException("XSDAM.S", exception, errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof IllegalAccessException) {
                        throw StandardException.newException("XSDAN.S", exception, errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof StandardException) {
                        throw (StandardException)exception;
                    }
                }
                throw StandardException.newException("XSDA8.S", iOException, errorObjectInput.getErrorInfo());
            }
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            arrayInputStream.clearLimit();
            throw StandardException.newException("XSDA9.S", classNotFoundException, errorObjectInput.getErrorInfo());
        }
        catch (LinkageError linkageError) {
            if (errorObjectInput != null) {
                arrayInputStream.clearLimit();
                throw StandardException.newException("XSDA8.S", linkageError, errorObjectInput.getErrorInfo());
            }
            throw linkageError;
        }
    }

    @Override
    public void restorePortionLongColumn(OverflowInputStream overflowInputStream) throws StandardException, IOException {
        int n2 = this.findRecordById(overflowInputStream.getOverflowId(), 0);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n2);
        int n3 = this.getRecordOffset(n2);
        int n4 = storedRecordHeader.getNumberFields();
        this.rawDataIn.setPosition(n3 + storedRecordHeader.size());
        int n5 = StoredFieldHeader.readStatus(this.rawDataIn);
        int n6 = StoredFieldHeader.readFieldDataLength(this.rawDataIn, n5, this.slotFieldSize);
        ByteHolder byteHolder = overflowInputStream.getByteHolder();
        byteHolder.write(this.rawDataIn, n6);
        overflowInputStream.setByteHolder(byteHolder);
        if (n4 == 1) {
            overflowInputStream.setOverflowPage(-1L);
            overflowInputStream.setOverflowId(-1);
        } else {
            int n7 = n5;
            n5 = StoredFieldHeader.readStatus(this.rawDataIn);
            n6 = StoredFieldHeader.readFieldDataLength(this.rawDataIn, n5, this.slotFieldSize);
            long l2 = CompressedNumber.readLong(this.rawDataIn);
            int n8 = CompressedNumber.readInt(this.rawDataIn);
            overflowInputStream.setOverflowPage(l2);
            overflowInputStream.setOverflowId(n8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logColumn(int n2, int n3, Object object, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n4) throws StandardException, IOException {
        int n5 = this.freeSpace;
        int n6 = -1;
        n5 += this.getReservedCount(n2);
        this.rawDataIn.setPosition(this.getFieldOffset(n2, n3));
        int n7 = StoredFieldHeader.readStatus(this.rawDataIn);
        int n8 = StoredFieldHeader.readFieldDataLength(this.rawDataIn, n7, this.slotFieldSize);
        n5 += StoredFieldHeader.size(n7, n8, this.slotFieldSize) + n8;
        try {
            this.setOutputStream(dynamicByteArrayOutputStream);
            n6 = this.rawDataOut.getPosition();
            Object[] objectArray = new Object[]{object};
            if (n5 == this.logColumn(objectArray, 0, dynamicByteArrayOutputStream, n5, 0, n4)) {
                throw new NoSpaceOnPage(this.isOverflowPage());
            }
        }
        finally {
            this.rawDataOut.setPosition(n6);
            this.resetOutputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int logLongColumn(int n2, int n3, Object object, DynamicByteArrayOutputStream dynamicByteArrayOutputStream) throws StandardException, IOException {
        int n4 = this.freeSpace;
        if ((n4 -= this.slotEntrySize) <= 0) {
            throw new NoSpaceOnPage(this.isOverflowPage());
        }
        this.setOutputStream(dynamicByteArrayOutputStream);
        int n5 = dynamicByteArrayOutputStream.getPosition();
        try {
            int n6 = 1;
            StoredRecordHeader storedRecordHeader = new StoredRecordHeader(n3, n6);
            int n7 = storedRecordHeader.write(this.logicalDataOut);
            if ((n4 -= n7) < 0) {
                throw new NoSpaceOnPage(this.isOverflowPage());
            }
            Object[] objectArray = new Object[]{object};
            int n8 = this.logColumn(objectArray, 0, dynamicByteArrayOutputStream, n4, 2, 100);
            return n8;
        }
        finally {
            this.resetOutputStream();
        }
    }

    private int logColumn(Object[] objectArray, int n2, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n3, int n4, int n5) throws StandardException, IOException {
        int n6;
        int n7;
        Object object;
        Object object2;
        Object object3 = object2 = objectArray != null ? objectArray[n2] : null;
        if (object2 instanceof RawField) {
            byte[] byArray = ((RawField)object2).getData();
            if (byArray.length <= n3) {
                dynamicByteArrayOutputStream.write(byArray);
                n3 -= byArray.length;
            }
            return n3;
        }
        boolean bl2 = true;
        int n8 = StoredFieldHeader.setFixed(StoredFieldHeader.setInitial(), true);
        int n9 = dynamicByteArrayOutputStream.getPosition();
        int n10 = 0;
        int n11 = 0;
        if (object2 instanceof StreamStorable && (object = (StreamStorable)object2).returnStream() != null) {
            object2 = object.returnStream();
        }
        if (object2 == null && n4 != 3) {
            n8 = StoredFieldHeader.setNonexistent(n8);
            n7 = StoredFieldHeader.write(this.logicalDataOut, n8, n11, this.slotFieldSize);
        } else if (object2 instanceof InputStream) {
            int n12;
            object = null;
            n6 = 0;
            int n13 = this.getMaxDataLength(n3, n5);
            if (object2 instanceof RememberBytesInputStream) {
                object = (RememberBytesInputStream)object2;
                n6 = ((RememberBytesInputStream)object).numBytesSaved();
            } else {
                object = new RememberBytesInputStream((InputStream)object2, new MemByteHolder(this.maxFieldSize + 1));
                if (objectArray[n2] instanceof StreamStorable) {
                    ((StreamStorable)objectArray[n2]).setStream((InputStream)object);
                }
                object2 = object;
            }
            if (n6 < n13 + 1) {
                n6 = (int)((long)n6 + ((RememberBytesInputStream)object).fillBuf(n13 + 1 - n6));
            }
            if (n6 <= n13) {
                n11 = n6;
                n8 = StoredFieldHeader.setFixed(n8, true);
                n7 = StoredFieldHeader.write(this.logicalDataOut, n8, n11, this.slotFieldSize);
                ((RememberBytesInputStream)object).putBuf(this.logicalDataOut, n11);
            } else if (n4 == 2) {
                bl2 = false;
                n11 = n13 - 12 - 2;
                n8 = StoredFieldHeader.setFixed(n8, true);
                n7 = StoredFieldHeader.write(this.logicalDataOut, n8, n11, this.slotFieldSize);
                ((RememberBytesInputStream)object).putBuf(this.logicalDataOut, n11);
                n12 = ((RememberBytesInputStream)object).available();
                int n14 = ((RememberBytesInputStream)object).shiftToFront();
            } else {
                n12 = this.maxFieldSize - n6 + 1;
                if (n12 > 0) {
                    n6 = (int)((long)n6 + ((RememberBytesInputStream)object).fillBuf(n12));
                }
                n11 = n6;
                object2 = object;
            }
        } else if (n4 == 3) {
            n8 = StoredFieldHeader.setNull(n8, true);
            n7 = StoredFieldHeader.write(this.logicalDataOut, n8, n11, this.slotFieldSize);
        } else if (object2 instanceof DataValueDescriptor) {
            object = (DataValueDescriptor)object2;
            int n15 = n6 = n4 == 3 || object.isNull() ? 1 : 0;
            if (n6 != 0) {
                n8 = StoredFieldHeader.setNull(n8, true);
            }
            n7 = StoredFieldHeader.write(this.logicalDataOut, n8, n11, this.slotFieldSize);
            if (n6 == 0) {
                try {
                    n10 = dynamicByteArrayOutputStream.getPosition();
                    object.writeExternal(this.logicalDataOut);
                }
                catch (IOException iOException) {
                    Exception exception;
                    if (this.logicalDataOut != null && (exception = this.logicalDataOut.getNestedException()) != null && exception instanceof StandardException) {
                        throw (StandardException)exception;
                    }
                    throw StandardException.newException("XSDAJ.S", iOException, new Object[0]);
                }
                n11 = dynamicByteArrayOutputStream.getPosition() - n9 - n7;
            }
        } else if (object2 instanceof RecordHandle) {
            object = (RecordHandle)object2;
            n8 = StoredFieldHeader.setOverflow(n8, true);
            n7 = StoredFieldHeader.write(this.logicalDataOut, n8, n11, this.slotFieldSize);
            n11 += CompressedNumber.writeLong(dynamicByteArrayOutputStream, object.getPageNumber());
            n11 += CompressedNumber.writeInt(dynamicByteArrayOutputStream, object.getId());
        } else {
            n7 = StoredFieldHeader.write(this.logicalDataOut, n8, n11, this.slotFieldSize);
            this.logicalDataOut.writeObject(object2);
            n11 = dynamicByteArrayOutputStream.getPosition() - n9 - n7;
        }
        n8 = StoredFieldHeader.setFixed(n8, false);
        int n16 = StoredFieldHeader.size(n8, n11, this.slotFieldSize) + n11;
        this.userRowSize += n11;
        n6 = this.isLong(n16, n5) ? 1 : 0;
        if ((n3 < n16 || n6 != 0) && n4 != 2) {
            if (n6 != 0) {
                if (!(object2 instanceof InputStream)) {
                    ByteArray byteArray = new ByteArray(dynamicByteArrayOutputStream.getByteArray(), n10, n11);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray.getArray(), n10, n11);
                    MemByteHolder memByteHolder = new MemByteHolder(n11 + 1);
                    RememberBytesInputStream rememberBytesInputStream = new RememberBytesInputStream(byteArrayInputStream, memByteHolder);
                    object2 = rememberBytesInputStream;
                }
                dynamicByteArrayOutputStream.setPosition(n9);
                LongColumnException longColumnException = new LongColumnException();
                longColumnException.setColumn(object2);
                throw longColumnException;
            }
            dynamicByteArrayOutputStream.setPosition(n9);
            return n3;
        }
        dynamicByteArrayOutputStream.setPosition(n9);
        n8 = StoredFieldHeader.setFixed(n8, true);
        n7 = StoredFieldHeader.write(dynamicByteArrayOutputStream, n8, n11, this.slotFieldSize);
        dynamicByteArrayOutputStream.setPosition(n9 + n11 + n7);
        n3 -= n16;
        if (n4 == 2) {
            if (bl2) {
                return -1;
            }
            return 1;
        }
        return n3;
    }

    private int logOverflowRecord(int n2, int n3, DynamicByteArrayOutputStream dynamicByteArrayOutputStream) throws StandardException, IOException {
        int n4;
        this.setOutputStream(dynamicByteArrayOutputStream);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n2);
        StoredRecordHeader storedRecordHeader2 = this.getOverFlowRecordHeader();
        storedRecordHeader2.setOverflowFields(storedRecordHeader);
        int n5 = storedRecordHeader.size();
        int n6 = storedRecordHeader2.size();
        if (n5 < n6 && n3 < (n4 = n6 - n5)) {
            throw new NoSpaceOnPage(this.isOverflowPage());
        }
        storedRecordHeader2.write(this.logicalDataOut);
        this.logRecordDataPortion(n2, 0, storedRecordHeader, null, this.logicalDataOut, null);
        return -1;
    }

    private int logOverflowField(DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n2, long l2, int n3) throws StandardException, IOException {
        int n4;
        int n5;
        int n6 = StoredFieldHeader.setOverflow(StoredFieldHeader.setInitial(), true);
        if ((n2 -= (n4 += StoredFieldHeader.size(n6, n5 = (n4 = CompressedNumber.sizeLong(l2) + CompressedNumber.sizeInt(n3)), this.slotFieldSize))) < 0) {
            throw new NoSpaceOnPage(this.isOverflowPage());
        }
        StoredFieldHeader.write(this.logicalDataOut, n6, n5, this.slotFieldSize);
        CompressedNumber.writeLong(dynamicByteArrayOutputStream, l2);
        CompressedNumber.writeInt(dynamicByteArrayOutputStream, n3);
        return n2;
    }

    @Override
    public void logRecord(int n2, int n3, int n4, FormatableBitSet formatableBitSet, OutputStream outputStream, RecordHandle recordHandle) throws StandardException, IOException {
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n2);
        if (n4 != storedRecordHeader.getId()) {
            StoredRecordHeader storedRecordHeader2 = new StoredRecordHeader(storedRecordHeader);
            storedRecordHeader2.setId(n4);
            storedRecordHeader2.write(outputStream);
            storedRecordHeader2 = null;
        } else {
            storedRecordHeader.write(outputStream);
        }
        this.logRecordDataPortion(n2, n3, storedRecordHeader, formatableBitSet, outputStream, recordHandle);
    }

    private void logRecordDataPortion(int n2, int n3, StoredRecordHeader storedRecordHeader, FormatableBitSet formatableBitSet, OutputStream outputStream, RecordHandle recordHandle) throws StandardException, IOException {
        int n4 = this.getRecordOffset(n2);
        int n5 = storedRecordHeader.size();
        n4 += n5;
        int n6 = storedRecordHeader.getFirstField();
        int n7 = n6 + storedRecordHeader.getNumberFields();
        int n8 = formatableBitSet == null ? 0 : formatableBitSet.getLength();
        for (int i2 = n6; i2 < n7; ++i2) {
            this.rawDataIn.setPosition(n4);
            int n9 = StoredFieldHeader.readStatus(this.rawDataIn);
            int n10 = StoredFieldHeader.readFieldDataLength(this.rawDataIn, n9, this.slotFieldSize);
            if (formatableBitSet != null && (n8 <= i2 || !formatableBitSet.isSet(i2)) || (n3 & 2) != 0 && !StoredFieldHeader.isOverflow(n9)) {
                n4 += StoredFieldHeader.size(n9, n10, this.slotFieldSize);
                n4 += n10;
                n9 = StoredFieldHeader.setInitial();
                n9 = StoredFieldHeader.setNonexistent(n9);
                StoredFieldHeader.write(outputStream, n9, 0, this.slotFieldSize);
                continue;
            }
            if ((n3 & 1) != 0 && recordHandle != null && StoredFieldHeader.isOverflow(n9) && !this.owner.isTemporaryContainer()) {
                int n11 = this.rawDataIn.getPosition();
                long l2 = CompressedNumber.readLong(this.rawDataIn);
                int n12 = CompressedNumber.readInt(this.rawDataIn);
                StoredPage storedPage = this.getOverflowPage(l2);
                PageTimeStamp pageTimeStamp = storedPage.currentTimeStamp();
                storedPage.unlatch();
                RawTransaction rawTransaction = this.owner.getTransaction();
                ReclaimSpace reclaimSpace = new ReclaimSpace(4, recordHandle, i2, l2, n12, pageTimeStamp, rawTransaction.getDataFactory(), true);
                rawTransaction.addPostCommitWork(reclaimSpace);
                this.rawDataIn.setPosition(n11);
            }
            n4 += StoredFieldHeader.write(outputStream, n9, n10, this.slotFieldSize);
            if (n10 == 0) continue;
            outputStream.write(this.pageData, n4, n10);
            n4 += n10;
        }
    }

    @Override
    public void logField(int n2, int n3, OutputStream outputStream) throws StandardException, IOException {
        int n4 = this.getFieldOffset(n2, n3);
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(n4);
        int n5 = StoredFieldHeader.readStatus(arrayInputStream);
        int n6 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n5, this.slotFieldSize);
        StoredFieldHeader.write(outputStream, n5, n6, this.slotFieldSize);
        if (n6 != 0) {
            outputStream.write(this.pageData, arrayInputStream.getPosition(), n6);
        }
    }

    @Override
    public RecordHandle insertAtSlot(int n2, Object[] objectArray, FormatableBitSet formatableBitSet, LogicalUndo logicalUndo, byte by, int n3) throws StandardException {
        try {
            return super.insertAtSlot(n2, objectArray, formatableBitSet, logicalUndo, by, n3);
        }
        catch (NoSpaceOnPage noSpaceOnPage) {
            return null;
        }
    }

    @Override
    public RecordHandle updateFieldAtSlot(int n2, int n3, Object object, LogicalUndo logicalUndo) throws StandardException {
        try {
            return super.updateFieldAtSlot(n2, n3, object, logicalUndo);
        }
        catch (NoSpaceOnPage noSpaceOnPage) {
            if (this.slotsInUse == 1) {
                throw StandardException.newException("XSDA3.S", new Object[0]);
            }
            throw StandardException.newException("XSDA3.S", new Object[0]);
        }
    }

    @Override
    public int fetchNumFieldsAtSlot(int n2) throws StandardException {
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n2);
        if (!storedRecordHeader.hasOverflow()) {
            return super.fetchNumFieldsAtSlot(n2);
        }
        StoredPage storedPage = this.getOverflowPage(storedRecordHeader.getOverflowPage());
        int n3 = ((BasePage)storedPage).fetchNumFieldsAtSlot(StoredPage.getOverflowSlot(storedPage, storedRecordHeader));
        ((BasePage)storedPage).unlatch();
        return n3;
    }

    @Override
    public int moveRecordForCompressAtSlot(int n2, Object[] objectArray, RecordHandle[] recordHandleArray, RecordHandle[] recordHandleArray2) throws StandardException {
        long l2 = this.getPageNumber();
        try {
            this.fetchFromSlot(null, n2, objectArray, null, false);
            int n3 = this.getRecordPortionLength(n2);
            int n4 = this.getHeaderAtSlot(n2).getId();
            StoredPage storedPage = (StoredPage)this.owner.getPageForCompress(0, l2);
            if (!(storedPage == null || storedPage.getPageNumber() < this.getPageNumber() && storedPage.spaceForCopy(n3, n4))) {
                storedPage.unlatch();
                storedPage = null;
            }
            if (!(storedPage != null || (storedPage = (StoredPage)this.owner.getPageForCompress(1, l2)) == null || storedPage.getPageNumber() < this.getPageNumber() && storedPage.spaceForCopy(n3, n4))) {
                storedPage.unlatch();
                storedPage = null;
            }
            if (!(storedPage != null || (storedPage = (StoredPage)this.owner.addPage()).getPageNumber() < this.getPageNumber() && storedPage.spaceForCopy(n3, n4))) {
                this.owner.removePage(storedPage);
                storedPage = null;
            }
            if (storedPage != null) {
                int n5 = storedPage.recordCount();
                recordHandleArray[0] = this.getRecordHandleAtSlot(n2);
                this.copyAndPurge(storedPage, n2, 1, n5);
                recordHandleArray2[0] = storedPage.getRecordHandleAtSlot(n5);
                storedPage.unlatch();
                return 1;
            }
            return 0;
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
    }

    public void logAction(LogInstant logInstant) throws StandardException {
        if (this.rawDataOut == null) {
            this.createOutStreams();
        }
        if (!this.isActuallyDirty()) {
            this.initialRowCount = !this.isOverflowPage() && (this.getPageStatus() & 1) != 0 ? this.internalNonDeletedRecordCount() : 0;
        }
        this.setDirty();
        this.bumpPageVersion();
        this.updateLastLogInstant(logInstant);
    }

    private void cleanPage() {
        this.setDirty();
        this.clearSection(0, this.getPageSize());
        this.slotsInUse = 0;
        this.deletedRowCount = 0;
        this.headerOutOfDate = true;
        this.clearAllSpace();
    }

    @Override
    public void initPage(LogInstant logInstant, byte by, int n2, boolean bl2, boolean bl3) throws StandardException {
        this.logAction(logInstant);
        if (bl3) {
            this.cleanPage();
            super.cleanPageForReuse();
        }
        this.headerOutOfDate = true;
        this.setPageStatus(by);
        this.isOverflowPage = bl2;
        this.nextId = n2;
    }

    @Override
    public void setPageStatus(LogInstant logInstant, byte by) throws StandardException {
        this.logAction(logInstant);
        this.headerOutOfDate = true;
        this.setPageStatus(by);
    }

    @Override
    public void setReservedSpace(LogInstant logInstant, int n2, int n3) throws StandardException, IOException {
        this.logAction(logInstant);
        this.headerOutOfDate = true;
        int n4 = n3 - this.getReservedCount(n2);
        int n5 = this.getRecordOffset(n2) + this.getTotalSpace(n2);
        if (n4 > 0) {
            this.expandPage(n5, n4);
        } else {
            this.shrinkPage(n5, -n4);
        }
        this.rawDataOut.setPosition(this.getSlotOffset(n2) + 2 * this.slotFieldSize);
        if (this.slotFieldSize == 2) {
            this.logicalDataOut.writeShort(n3);
        } else {
            this.logicalDataOut.writeInt(n3);
        }
    }

    @Override
    public void storeRecord(LogInstant logInstant, int n2, boolean bl2, ObjectInput objectInput) throws StandardException, IOException {
        this.logAction(logInstant);
        if (bl2) {
            this.storeRecordForInsert(n2, objectInput);
        } else {
            this.storeRecordForUpdate(n2, objectInput);
        }
    }

    private void storeRecordForInsert(int n2, ObjectInput objectInput) throws StandardException, IOException {
        int n3;
        int n4;
        int n5;
        int n6;
        StoredRecordHeader storedRecordHeader = this.shiftUp(n2);
        if (storedRecordHeader == null) {
            storedRecordHeader = new StoredRecordHeader();
            this.setHeaderAtSlot(n2, storedRecordHeader);
        }
        this.bumpRecordCount(1);
        storedRecordHeader.read(objectInput);
        if (storedRecordHeader.isDeleted()) {
            ++this.deletedRowCount;
            this.headerOutOfDate = true;
        }
        if (this.nextId <= storedRecordHeader.getId()) {
            this.nextId = storedRecordHeader.getId() + 1;
        }
        int n7 = n6 = this.firstFreeByte;
        int n8 = storedRecordHeader.getNumberFields();
        this.rawDataOut.setPosition(n7);
        n7 += storedRecordHeader.write(this.rawDataOut);
        int n9 = 0;
        for (n5 = 0; n5 < n8; ++n5) {
            n4 = StoredFieldHeader.readStatus(objectInput);
            n3 = StoredFieldHeader.readFieldDataLength(objectInput, n4, this.slotFieldSize);
            n4 = StoredFieldHeader.setFixed(n4, false);
            this.rawDataOut.setPosition(n7);
            n7 += StoredFieldHeader.write(this.rawDataOut, n4, n3, this.slotFieldSize);
            if (n3 == 0) continue;
            objectInput.readFully(this.pageData, n7, n3);
            n7 += n3;
            n9 += n3;
        }
        n5 = n7 - this.firstFreeByte;
        this.freeSpace -= n5;
        this.firstFreeByte += n5;
        n4 = 0;
        if (this.minimumRecordSize > 0 && n9 < this.minimumRecordSize) {
            n4 = this.minimumRecordSize - n9;
            this.freeSpace -= n4;
            this.firstFreeByte += n4;
        }
        if (this.isOverflowPage() && (n3 = 17 - (n5 + n4)) > 0) {
            this.freeSpace -= n3;
            this.firstFreeByte += n3;
            n4 += n3;
        }
        this.addSlotEntry(n2, n6, n5, n4);
        if (this.firstFreeByte > this.getSlotOffset(n2) || this.freeSpace < 0) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", this.getPageId()));
        }
    }

    private void storeRecordForUpdate(int n2, ObjectInput objectInput) throws StandardException, IOException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n2);
        StoredRecordHeader storedRecordHeader2 = new StoredRecordHeader();
        storedRecordHeader2.read(objectInput);
        int n8 = storedRecordHeader.getNumberFields();
        int n9 = storedRecordHeader2.getNumberFields();
        int n10 = storedRecordHeader.getFirstField();
        if (n9 < n8) {
            n7 = this.getFieldOffset(n2, n10 + n9);
            n6 = this.getRecordOffset(n2) + this.getRecordPortionLength(n2) - n7;
            this.updateRecordPortionLength(n2, -n6, n6);
        }
        n6 = n7 = this.getRecordOffset(n2);
        int n11 = n7;
        int n12 = n9 < n8 ? n9 - 1 : n8 - 1;
        n12 += n10;
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = null;
        this.rawDataOut.setPosition(n6);
        int n13 = storedRecordHeader.size();
        int n14 = storedRecordHeader2.size();
        int n15 = n13;
        if (n12 < n10) {
            n15 += this.getReservedCount(n2);
        }
        if (n15 >= n14) {
            storedRecordHeader2.write(this.rawDataOut);
            n6 += n14;
            n15 -= n14;
        } else {
            dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream(this.getPageSize());
            storedRecordHeader2.write(dynamicByteArrayOutputStream);
        }
        n11 += n13;
        int n16 = n14 - n13;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = n10 + n8;
        int n22 = n10 + n9;
        for (n5 = n10; n5 < n22; ++n5) {
            int n23;
            int n24;
            n4 = 0;
            if (n5 < n21) {
                this.rawDataIn.setPosition(n11);
                n17 = StoredFieldHeader.readStatus(this.rawDataIn);
                n18 = StoredFieldHeader.readFieldDataLength(this.rawDataIn, n17, this.slotFieldSize);
                n4 = StoredFieldHeader.size(n17, n18, this.slotFieldSize) + n18;
            }
            n19 = StoredFieldHeader.readStatus(objectInput);
            n20 = StoredFieldHeader.readFieldDataLength(objectInput, n19, this.slotFieldSize);
            if (StoredFieldHeader.isNonexistent(n19) && n5 < n21) {
                if (dynamicByteArrayOutputStream == null || dynamicByteArrayOutputStream.getUsed() == 0) {
                    if (n6 != n11) {
                        System.arraycopy(this.pageData, n11, this.pageData, n6, n4);
                    }
                    n6 += n4;
                    if (n5 == n12) {
                        n15 += this.getReservedCount(n2);
                    }
                } else {
                    n3 = dynamicByteArrayOutputStream.getPosition();
                    dynamicByteArrayOutputStream.setPosition(n3 + n4);
                    System.arraycopy(this.pageData, n11, dynamicByteArrayOutputStream.getByteArray(), n3, n4);
                    n15 += n4;
                    if (n5 == n12) {
                        n15 += this.getReservedCount(n2);
                    }
                    n24 = this.moveSavedDataToPage(dynamicByteArrayOutputStream, n15, n6);
                    n6 += n24;
                    n15 -= n24;
                }
                n11 += n4;
                continue;
            }
            n19 = StoredFieldHeader.setFixed(n19, false);
            n3 = StoredFieldHeader.size(n19, n20, this.slotFieldSize);
            n24 = n3 + n20;
            n16 += n24 - n4;
            n15 += n4;
            n11 += n4;
            if (n5 == n12) {
                n15 += this.getReservedCount(n2);
            }
            if (dynamicByteArrayOutputStream != null && dynamicByteArrayOutputStream.getUsed() != 0) {
                n23 = this.moveSavedDataToPage(dynamicByteArrayOutputStream, n15, n6);
                n6 += n23;
                n15 -= n23;
            }
            if ((dynamicByteArrayOutputStream == null || dynamicByteArrayOutputStream.getUsed() == 0) && n15 >= n3) {
                this.rawDataOut.setPosition(n6);
                n6 += StoredFieldHeader.write(this.rawDataOut, n19, n20, this.slotFieldSize);
                n15 -= n3;
                if (n20 == 0) continue;
                int n25 = n23 = n15 >= n20 ? n20 : n15;
                if (n23 != 0) {
                    objectInput.readFully(this.pageData, n6, n23);
                    n6 += n23;
                    n15 -= n23;
                }
                if ((n23 = n20 - n23) == 0) continue;
                if (dynamicByteArrayOutputStream == null) {
                    dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream(n24 * 2);
                }
                int n26 = dynamicByteArrayOutputStream.getPosition();
                dynamicByteArrayOutputStream.setPosition(n26 + n23);
                objectInput.readFully(dynamicByteArrayOutputStream.getByteArray(), n26, n23);
                continue;
            }
            if (dynamicByteArrayOutputStream == null) {
                dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream(n24 * 2);
            }
            StoredFieldHeader.write(dynamicByteArrayOutputStream, n19, n20, this.slotFieldSize);
            if (n20 == 0) continue;
            n23 = dynamicByteArrayOutputStream.getPosition();
            dynamicByteArrayOutputStream.setPosition(n23 + n20);
            objectInput.readFully(dynamicByteArrayOutputStream.getByteArray(), n23, n20);
        }
        if (dynamicByteArrayOutputStream != null && dynamicByteArrayOutputStream.getUsed() != 0) {
            n4 = n7 + this.getTotalSpace(n2);
            n3 = dynamicByteArrayOutputStream.getUsed() - (n4 - n6);
            if (n3 > this.freeSpace) {
                throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", this.getPageId()));
            }
            this.expandPage(n4, n3);
            this.moveSavedDataToPage(dynamicByteArrayOutputStream, n15 += n3, n6);
            n5 = -1 * this.getReservedCount(n2);
        } else {
            n5 = -1 * n16;
        }
        this.updateRecordPortionLength(n2, n16, n5);
        this.setHeaderAtSlot(n2, storedRecordHeader2);
    }

    private int moveSavedDataToPage(DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n2, int n3) {
        if (n2 > dynamicByteArrayOutputStream.getUsed() / 2) {
            int n4 = n2 <= dynamicByteArrayOutputStream.getUsed() ? n2 : dynamicByteArrayOutputStream.getUsed();
            System.arraycopy(dynamicByteArrayOutputStream.getByteArray(), 0, this.pageData, n3, n4);
            dynamicByteArrayOutputStream.discardLeft(n4);
            return n4;
        }
        return 0;
    }

    private void createSpaceForUpdate(int n2, int n3, int n4, int n5) throws StandardException, IOException {
        int n6;
        if (n5 <= n4) {
            int n7 = n4 - n5;
            if (n7 == 0) {
                return;
            }
            int n8 = this.shiftRemainingData(n2, n3, n4, n5);
            this.clearSection(n3 + n5 + n8, n7);
            this.updateRecordPortionLength(n2, -n7, n7);
            return;
        }
        int n9 = n5 - n4;
        int n10 = this.getReservedCount(n2);
        int n11 = 0;
        int n12 = n9 - n10;
        if (n12 > 0) {
            n6 = this.getRecordOffset(n2) + this.getTotalSpace(n2);
            this.expandPage(n6, n12);
            n11 = -n10;
        } else {
            n11 = -n9;
        }
        n6 = this.shiftRemainingData(n2, n3, n4, n5);
        this.updateRecordPortionLength(n2, n9, n11);
    }

    @Override
    public void storeField(LogInstant logInstant, int n2, int n3, ObjectInput objectInput) throws StandardException, IOException {
        this.logAction(logInstant);
        int n4 = this.getFieldOffset(n2, n3);
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(n4);
        int n5 = StoredFieldHeader.readStatus(arrayInputStream);
        int n6 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n5, this.slotFieldSize);
        int n7 = StoredFieldHeader.readStatus(objectInput);
        int n8 = StoredFieldHeader.readFieldDataLength(objectInput, n7, this.slotFieldSize);
        n7 = StoredFieldHeader.setFixed(n7, false);
        int n9 = StoredFieldHeader.size(n5, n6, this.slotFieldSize) + n6;
        int n10 = StoredFieldHeader.size(n7, n8, this.slotFieldSize) + n8;
        this.createSpaceForUpdate(n2, n4, n9, n10);
        this.rawDataOut.setPosition(n4);
        n4 += StoredFieldHeader.write(this.rawDataOut, n7, n8, this.slotFieldSize);
        if (n8 != 0) {
            objectInput.readFully(this.pageData, n4, n8);
        }
    }

    @Override
    public void reserveSpaceForSlot(LogInstant logInstant, int n2, int n3) throws StandardException, IOException {
        this.logAction(logInstant);
        int n4 = n3 - this.getReservedCount(n2);
        if (n4 <= 0) {
            return;
        }
        if (this.freeSpace < n4) {
            throw new NoSpaceOnPage(this.isOverflowPage());
        }
        int n5 = this.getRecordOffset(n2);
        int n6 = n5 + this.getTotalSpace(n2);
        this.expandPage(n6, n4);
        this.setSlotEntry(n2, n5, this.getRecordPortionLength(n2), n3);
    }

    @Override
    public void skipField(ObjectInput objectInput) throws IOException {
        int n2 = StoredFieldHeader.readStatus(objectInput);
        int n3 = StoredFieldHeader.readFieldDataLength(objectInput, n2, this.slotFieldSize);
        if (n3 != 0) {
            DataInputUtil.skipFully(objectInput, n3);
        }
    }

    @Override
    public void skipRecord(ObjectInput objectInput) throws IOException {
        StoredRecordHeader storedRecordHeader = new StoredRecordHeader();
        storedRecordHeader.read(objectInput);
        for (int i2 = storedRecordHeader.getNumberFields(); i2 > 0; --i2) {
            this.skipField(objectInput);
        }
    }

    private int shiftRemainingData(int n2, int n3, int n4, int n5) throws IOException {
        int n6 = this.getRecordOffset(n2) + this.getRecordPortionLength(n2) - (n3 + n4);
        if (n6 != 0) {
            System.arraycopy(this.pageData, n3 + n4, this.pageData, n3 + n5, n6);
        }
        return n6;
    }

    @Override
    public void setDeleteStatus(LogInstant logInstant, int n2, boolean bl2) throws StandardException, IOException {
        this.logAction(logInstant);
        this.deletedRowCount += super.setDeleteStatus(n2, bl2);
        this.headerOutOfDate = true;
        int n3 = this.getRecordOffset(n2);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n2);
        this.rawDataOut.setPosition(n3);
        storedRecordHeader.write(this.logicalDataOut);
    }

    @Override
    protected int internalDeletedRecordCount() {
        return this.deletedRowCount;
    }

    @Override
    public void purgeRecord(LogInstant logInstant, int n2, int n3) throws StandardException, IOException {
        this.logAction(logInstant);
        if (this.getHeaderAtSlot(n2).isDeleted()) {
            --this.deletedRowCount;
        }
        int n4 = this.getRecordOffset(n2);
        int n5 = n4 + this.getTotalSpace(n2) - 1;
        this.compressPage(n4, n5);
        this.removeSlotEntry(n2);
        this.removeAndShiftDown(n2);
    }

    private int getFieldOffset(int n2, int n3) throws IOException {
        int n4 = this.getRecordOffset(n2);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n2);
        int n5 = storedRecordHeader.getFirstField();
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(n4 + storedRecordHeader.size());
        for (int i2 = n5; i2 < n3; ++i2) {
            this.skipField(arrayInputStream);
        }
        return this.rawDataIn.getPosition();
    }

    @Override
    public PageTimeStamp currentTimeStamp() {
        return new PageVersion(this.getPageNumber(), this.getPageVersion());
    }

    @Override
    public void setTimeStamp(PageTimeStamp pageTimeStamp) throws StandardException {
        if (pageTimeStamp == null) {
            throw StandardException.newException("XSDAB.S", new Object[0]);
        }
        if (!(pageTimeStamp instanceof PageVersion)) {
            throw StandardException.newException("XSDAA.S", pageTimeStamp);
        }
        PageVersion pageVersion = (PageVersion)pageTimeStamp;
        pageVersion.setPageNumber(this.getPageNumber());
        pageVersion.setPageVersion(this.getPageVersion());
    }

    @Override
    public boolean equalTimeStamp(PageTimeStamp pageTimeStamp) throws StandardException {
        if (pageTimeStamp == null) {
            return false;
        }
        if (!(pageTimeStamp instanceof PageVersion)) {
            throw StandardException.newException("XSDAA.S", pageTimeStamp);
        }
        PageVersion pageVersion = (PageVersion)pageTimeStamp;
        if (pageVersion.getPageNumber() != this.getPageNumber()) {
            throw StandardException.newException("XSDAA.S", pageTimeStamp);
        }
        return pageVersion.getPageVersion() == this.getPageVersion();
    }

    public String toString() {
        return null;
    }

    public String toUncheckedString() {
        return null;
    }

    private static String pagedataToHexDump(byte[] byArray) {
        return StringUtil.hexDump(byArray);
    }

    private String pageHeaderToString() {
        return null;
    }

    String getPageDumpString() {
        return MessageService.getTextMessage("D016", this.getIdentity(), this.isOverflowPage, this.getPageVersion(), this.slotsInUse, this.deletedRowCount, this.getPageStatus(), this.nextId, this.firstFreeByte, this.freeSpace, this.totalSpace, this.spareSpace, this.minimumRecordSize, this.getPageSize(), StoredPage.pagedataToHexDump(this.pageData));
    }

    private String recordToString(int n2) {
        return null;
    }

    protected StoredPage getOverflowPage(long l2) throws StandardException {
        StoredPage storedPage = (StoredPage)this.owner.getPage(l2);
        if (storedPage == null) {
            // empty if block
        }
        return storedPage;
    }

    @Override
    protected BasePage getNewOverflowPage() throws StandardException {
        FileContainer fileContainer = (FileContainer)this.containerCache.find(this.identity.getContainerId());
        try {
            BasePage basePage = (BasePage)fileContainer.addPage(this.owner, true);
            return basePage;
        }
        finally {
            this.containerCache.release(fileContainer);
        }
    }

    protected static int getOverflowSlot(BasePage basePage, StoredRecordHeader storedRecordHeader) throws StandardException {
        int n2 = basePage.findRecordById(storedRecordHeader.getOverflowId(), 0);
        if (n2 < 0) {
            throw StandardException.newException("XSDA1.S", new Object[0]);
        }
        return n2;
    }

    public BasePage getOverflowPageForInsert(int n2, Object[] objectArray, FormatableBitSet formatableBitSet) throws StandardException {
        return this.getOverflowPageForInsert(n2, objectArray, formatableBitSet, 0);
    }

    @Override
    public BasePage getOverflowPageForInsert(int n2, Object[] objectArray, FormatableBitSet formatableBitSet, int n3) throws StandardException {
        int n4;
        int n5;
        long[] lArray = new long[5];
        int n6 = 0;
        long l2 = 0L;
        block2: for (n5 = 0; n5 < this.slotsInUse && n6 < lArray.length; ++n5) {
            StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n5);
            if (!storedRecordHeader.hasOverflow()) continue;
            long l3 = storedRecordHeader.getOverflowPage();
            if (n5 == n2) {
                l2 = l3;
                continue;
            }
            for (n4 = 0; n4 < n6; ++n4) {
                if (lArray[n4] == l3) continue block2;
            }
            lArray[n6++] = l3;
        }
        for (n5 = 0; n5 < n6; ++n5) {
            long l4 = lArray[n5];
            if (l4 == l2) continue;
            StoredPage storedPage = null;
            n4 = 0;
            try {
                storedPage = this.getOverflowPage(l4);
                if (storedPage.spaceForInsert(objectArray, formatableBitSet, n4, n3, 100)) {
                    return storedPage;
                }
                n4 = storedPage.getCurrentFreeSpace();
                storedPage.unlatch();
                storedPage = null;
                continue;
            }
            catch (StandardException standardException) {
                if (storedPage == null) continue;
                storedPage.unlatch();
                storedPage = null;
            }
        }
        return this.getNewOverflowPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateOverflowed(RawTransaction rawTransaction, int n2, Object[] objectArray, FormatableBitSet formatableBitSet, StoredRecordHeader storedRecordHeader) throws StandardException {
        StoredPage storedPage = this.getOverflowPage(storedRecordHeader.getOverflowPage());
        try {
            int n3 = StoredPage.getOverflowSlot(storedPage, storedRecordHeader);
            ((BasePage)storedPage).doUpdateAtSlot(rawTransaction, n3, storedRecordHeader.getOverflowId(), objectArray, formatableBitSet);
            ((BasePage)storedPage).unlatch();
            storedPage = null;
            return;
        }
        finally {
            if (storedPage != null) {
                ((BasePage)storedPage).unlatch();
                storedPage = null;
            }
        }
    }

    @Override
    public void updateOverflowDetails(RecordHandle recordHandle, RecordHandle recordHandle2) throws StandardException {
        long l2 = recordHandle.getPageNumber();
        if (l2 == this.getPageNumber()) {
            this.updateOverflowDetails(this, recordHandle, recordHandle2);
            return;
        }
        StoredPage storedPage = (StoredPage)this.owner.getPage(l2);
        this.updateOverflowDetails(storedPage, recordHandle, recordHandle2);
        storedPage.unlatch();
    }

    private void updateOverflowDetails(StoredPage storedPage, RecordHandle recordHandle, RecordHandle recordHandle2) throws StandardException {
        storedPage.getOverFlowRecordHeader().setOverflowDetails(recordHandle2);
        int n2 = storedPage.getSlotNumber(recordHandle);
        storedPage.doUpdateAtSlot(this.owner.getTransaction(), n2, recordHandle.getId(), null, null);
    }

    @Override
    public void updateFieldOverflowDetails(RecordHandle recordHandle, RecordHandle recordHandle2) throws StandardException {
        Object[] objectArray = new Object[2];
        objectArray[1] = recordHandle2;
        FormatableBitSet formatableBitSet = new FormatableBitSet(2);
        formatableBitSet.set(1);
        int n2 = this.getSlotNumber(recordHandle);
        this.doUpdateAtSlot(this.owner.getTransaction(), n2, recordHandle.getId(), objectArray, formatableBitSet);
    }

    @Override
    public int appendOverflowFieldHeader(DynamicByteArrayOutputStream dynamicByteArrayOutputStream, RecordHandle recordHandle) throws StandardException, IOException {
        int n2 = StoredFieldHeader.setInitial();
        n2 = StoredFieldHeader.setOverflow(n2, true);
        long l2 = recordHandle.getPageNumber();
        int n3 = recordHandle.getId();
        int n4 = CompressedNumber.sizeLong(l2) + CompressedNumber.sizeInt(n3);
        int n5 = StoredFieldHeader.write(dynamicByteArrayOutputStream, n2, n4, this.slotFieldSize);
        n5 += CompressedNumber.writeLong(dynamicByteArrayOutputStream, l2);
        return n5 += CompressedNumber.writeInt(dynamicByteArrayOutputStream, n3);
    }

    protected int getSlotsInUse() {
        return this.slotsInUse;
    }

    private int getMaxDataLength(int n2, int n3) {
        int n4 = this.totalSpace * n3 / 100;
        int n5 = 0;
        n5 = n2 < 62 ? n2 - 2 : (n2 < 16380 ? n2 - 3 : n2 - 5);
        return n5 > n4 ? n4 : n5;
    }

    private boolean isLong(int n2, int n3) {
        int n4 = this.maxFieldSize * n3 / 100;
        return n2 > n4;
    }

    @Override
    public void doUpdateAtSlot(RawTransaction rawTransaction, int n2, int n3, Object[] objectArray, FormatableBitSet formatableBitSet) throws StandardException {
        Object object;
        RecordHandle recordHandle;
        RecordHandle recordHandle2 = recordHandle = this.isOverflowPage() ? null : this.getRecordHandleAtSlot(n2);
        if (objectArray == null) {
            this.owner.getActionSet().actionUpdate(rawTransaction, this, n2, n3, objectArray, formatableBitSet, -1, null, -1, recordHandle);
            return;
        }
        int n4 = RowUtil.nextColumn(objectArray, formatableBitSet, 0);
        if (n4 == -1) {
            return;
        }
        boolean bl2 = false;
        StoredPage storedPage = this;
        while (true) {
            object = storedPage.getHeaderAtSlot(n2);
            int n5 = ((StoredRecordHeader)object).getFirstField();
            int n6 = n5 + ((StoredRecordHeader)object).getNumberFields();
            long l2 = -1L;
            int n7 = -1;
            int n8 = -1;
            if (!((StoredRecordHeader)object).hasOverflow() || n4 >= n5 && n4 < n6) {
                int n9;
                boolean bl3;
                int n10 = -1;
                Object[] objectArray2 = null;
                DynamicByteArrayOutputStream dynamicByteArrayOutputStream = null;
                do {
                    try {
                        n10 = this.owner.getActionSet().actionUpdate(rawTransaction, storedPage, n2, n3, objectArray, formatableBitSet, n7, dynamicByteArrayOutputStream, n8, recordHandle);
                        bl3 = false;
                    }
                    catch (LongColumnException longColumnException) {
                        if (longColumnException.getRealSpaceOnPage() == -1) {
                            dynamicByteArrayOutputStream = longColumnException.getLogBuffer();
                            objectArray2 = (Object[])longColumnException.getColumn();
                            n7 = longColumnException.getNextColumn();
                            n8 = -1;
                            bl3 = true;
                            continue;
                        }
                        dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream(longColumnException.getLogBuffer());
                        RecordHandle recordHandle3 = this.insertLongColumn(storedPage, longColumnException, (byte)2);
                        int n11 = 0;
                        try {
                        }
                        catch (IOException iOException) {
                            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
                        }
                        n7 = longColumnException.getNextColumn() + 1;
                        n8 = longColumnException.getRealSpaceOnPage() - (n11 += this.appendOverflowFieldHeader(dynamicByteArrayOutputStream, recordHandle3));
                        bl3 = true;
                    }
                    catch (NoSpaceOnPage noSpaceOnPage) {
                        throw StandardException.newException("XSDAP.S", noSpaceOnPage, ((PageKey)storedPage.getIdentity()).toString(), this.getPageDumpString(), n2, n3, formatableBitSet.toString(), n7, 0, recordHandle);
                    }
                } while (bl3);
                int n12 = n9 = formatableBitSet == null ? 0 : formatableBitSet.getLength();
                if (n10 != -1) {
                    RecordHandle recordHandle4;
                    int n13 = n6;
                    if (!((StoredRecordHeader)object).hasOverflow()) {
                        if (formatableBitSet == null) {
                            if (objectArray.length > n13) {
                                n13 = objectArray.length;
                            }
                        } else if (n9 > n13) {
                            n13 = n9;
                        }
                    }
                    Object[] objectArray3 = new Object[n13];
                    FormatableBitSet formatableBitSet2 = new FormatableBitSet(n13);
                    Object var25_30 = null;
                    for (int i2 = n10; i2 < n13; ++i2) {
                        if (formatableBitSet == null || n9 > i2 && formatableBitSet.isSet(i2)) {
                            formatableBitSet2.set(i2);
                            objectArray3[i2] = RowUtil.getColumn(objectArray, formatableBitSet, i2);
                            continue;
                        }
                        if (i2 >= n6) continue;
                        formatableBitSet2.set(i2);
                        objectArray3[i2] = objectArray2[i2 - n10];
                    }
                    RecordHandle recordHandle5 = storedPage.getRecordHandleAtSlot(n2);
                    if (((StoredRecordHeader)object).hasOverflow()) {
                        l2 = ((StoredRecordHeader)object).getOverflowPage();
                        n3 = ((StoredRecordHeader)object).getOverflowId();
                        n4 = RowUtil.nextColumn(objectArray, formatableBitSet, n6);
                    } else {
                        n4 = -1;
                        l2 = 0L;
                    }
                    if (!bl2 && recordHandle != null && storedPage != null && !this.owner.isTemporaryContainer()) {
                        bl2 = storedPage.checkRowReservedSpace(n2);
                    }
                    BasePage basePage = storedPage.getOverflowPageForInsert(n2, objectArray3, formatableBitSet2, n10);
                    if (storedPage != this) {
                        storedPage.unlatch();
                        storedPage = null;
                    }
                    byte by = 8;
                    if (l2 != 0L) {
                        by = (byte)(by | 0x10);
                    }
                    RecordHandle recordHandle6 = l2 == 0L ? null : this.owner.makeRecordHandle(l2, n3);
                    try {
                        recordHandle4 = basePage.insertAllowOverflow(0, objectArray3, formatableBitSet2, n10, by, 100, recordHandle6);
                    }
                    catch (NoSpaceOnPage noSpaceOnPage) {
                        throw StandardException.newException("XSDAP.S", noSpaceOnPage, ((PageKey)basePage.getIdentity()).toString(), this.getPageDumpString(), n2, n3, formatableBitSet2.toString(), n10, by, recordHandle6);
                    }
                    if (storedPage == this) {
                        this.updateOverflowDetails(this, recordHandle5, recordHandle4);
                    } else {
                        this.updateOverflowDetails(recordHandle5, recordHandle4);
                    }
                    basePage.unlatch();
                } else {
                    if (!bl2 && recordHandle != null && storedPage != null && !this.owner.isTemporaryContainer()) {
                        bl2 = storedPage.checkRowReservedSpace(n2);
                    }
                    int n14 = n4 = ((StoredRecordHeader)object).hasOverflow() ? RowUtil.nextColumn(objectArray, formatableBitSet, n6) : -1;
                }
                if (n4 == -1) {
                    if (storedPage == this || storedPage == null) break;
                    storedPage.unlatch();
                    break;
                }
            }
            if (l2 == -1L) {
                l2 = ((StoredRecordHeader)object).getOverflowPage();
                n3 = ((StoredRecordHeader)object).getOverflowId();
            }
            if (storedPage != this && storedPage != null) {
                storedPage.unlatch();
            }
            storedPage = (StoredPage)this.owner.getPage(l2);
            n2 = storedPage.findRecordById(n3, 0);
        }
        if (bl2) {
            object = this.owner.getTransaction();
            ReclaimSpace reclaimSpace = new ReclaimSpace(3, recordHandle, ((RawTransaction)object).getDataFactory(), true);
            object.addPostCommitWork(reclaimSpace);
        }
    }

    private boolean checkRowReservedSpace(int n2) throws StandardException {
        boolean bl2 = false;
        try {
            int n3 = this.getReservedCount(n2);
            int n4 = 12;
            if (n3 > n4) {
                int n5 = this.getRecordPortionLength(n2) + n3;
                if (this.isOverflowPage()) {
                    if (n5 > 17 + n4) {
                        bl2 = true;
                    }
                } else if (n5 > this.minimumRecordSize + n4) {
                    bl2 = true;
                }
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void compactRecord(RawTransaction rawTransaction, int n2, int n3) throws StandardException {
        int n4;
        int n5;
        if (!this.isOverflowPage()) {
            StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n2);
            while (storedRecordHeader.hasOverflow()) {
                StoredPage storedPage = this.getOverflowPage(storedRecordHeader.getOverflowPage());
                try {
                    n5 = storedRecordHeader.getOverflowId();
                    n4 = StoredPage.getOverflowSlot(storedPage, storedRecordHeader);
                    storedPage.compactRecord(rawTransaction, n4, n5);
                    storedRecordHeader = storedPage.getHeaderAtSlot(n4);
                }
                finally {
                    storedPage.unlatch();
                }
            }
        }
        int n6 = 12;
        try {
            int n7 = this.getReservedCount(n2);
            if (n7 > n6) {
                n5 = this.getRecordPortionLength(n2);
                n4 = n7;
                int n8 = n5 + n7;
                if (this.isOverflowPage()) {
                    if (n8 > 17 + n6) {
                        n4 = n5 >= 17 ? 0 : 17 - n5;
                    }
                } else if (n8 > this.minimumRecordSize + n6) {
                    n4 = n5 >= this.minimumRecordSize ? 0 : this.minimumRecordSize - n5;
                }
                if (n4 < n7) {
                    this.owner.getActionSet().actionShrinkReservedSpace(rawTransaction, this, n2, n3, n4, n7);
                }
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
    }
}

