/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PageBasicOperation;

public final class SetReservedSpaceOperation
extends PageBasicOperation {
    protected int doMeSlot;
    protected int recordId;
    protected int newValue;
    protected int oldValue;

    SetReservedSpaceOperation(BasePage basePage, int n2, int n3, int n4, int n5) {
        super(basePage);
        this.doMeSlot = n2;
        this.recordId = n3;
        this.newValue = n4;
        this.oldValue = n5;
    }

    public SetReservedSpaceOperation() {
    }

    @Override
    public int getTypeFormatId() {
        return 287;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.doMeSlot);
        CompressedNumber.writeInt(objectOutput, this.recordId);
        CompressedNumber.writeInt(objectOutput, this.newValue);
        CompressedNumber.writeInt(objectOutput, this.oldValue);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.doMeSlot = CompressedNumber.readInt(objectInput);
        this.recordId = CompressedNumber.readInt(objectInput);
        this.newValue = CompressedNumber.readInt(objectInput);
        this.oldValue = CompressedNumber.readInt(objectInput);
    }

    @Override
    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.page.setReservedSpace(logInstant, this.doMeSlot, this.newValue);
    }

    @Override
    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        int n2 = basePage.findRecordById(this.recordId, 0);
        this.page.setReservedSpace(logInstant, n2, this.oldValue);
    }

    @Override
    public String toString() {
        return null;
    }
}

