/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.io.StorageFile;

public class RemoveFileOperation
implements Undoable {
    private String name;
    private long generationId;
    private boolean removeAtOnce;
    private transient StorageFile fileToGo;

    public RemoveFileOperation() {
    }

    RemoveFileOperation(String string, long l2, boolean bl2) {
        this.name = string;
        this.generationId = l2;
        this.removeAtOnce = bl2;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.name);
        objectOutput.writeLong(this.generationId);
        objectOutput.writeBoolean(this.removeAtOnce);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.name = objectInput.readUTF();
        this.generationId = objectInput.readLong();
        this.removeAtOnce = objectInput.readBoolean();
    }

    @Override
    public int getTypeFormatId() {
        return 291;
    }

    @Override
    public ByteArray getPreparedLog() {
        return null;
    }

    @Override
    public void releaseResource(Transaction transaction) {
    }

    @Override
    public int group() {
        return 1280;
    }

    @Override
    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException {
        if (this.fileToGo == null) {
            return;
        }
        BaseDataFileFactory baseDataFileFactory = (BaseDataFileFactory)((RawTransaction)transaction).getDataFactory();
        baseDataFileFactory.fileToRemove(this.fileToGo, true);
    }

    @Override
    public boolean needsRedo(Transaction transaction) throws StandardException {
        if (!this.removeAtOnce) {
            return false;
        }
        FileResource fileResource = ((RawTransaction)transaction).getDataFactory().getFileHandler();
        this.fileToGo = fileResource.getAsFile(this.name, this.generationId);
        if (this.fileToGo == null) {
            return false;
        }
        return this.fileToGo.exists();
    }

    @Override
    public Compensation generateUndo(Transaction transaction, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        if (this.fileToGo != null) {
            BaseDataFileFactory baseDataFileFactory = (BaseDataFileFactory)((RawTransaction)transaction).getDataFactory();
            baseDataFileFactory.fileToRemove(this.fileToGo, false);
        }
        return null;
    }
}

