/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.util.Hashtable;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.RowLock;

public final class RecordId
implements RecordHandle {
    private final PageKey pageId;
    private final int recordId;
    private transient int slotNumberHint;

    public RecordId(ContainerKey containerKey, long l2, int n2) {
        this.pageId = new PageKey(containerKey, l2);
        this.recordId = n2;
    }

    public RecordId(PageKey pageKey, int n2) {
        this.pageId = pageKey;
        this.recordId = n2;
    }

    public RecordId(PageKey pageKey, int n2, int n3) {
        this.pageId = pageKey;
        this.recordId = n2;
        this.slotNumberHint = n3;
    }

    @Override
    public int getId() {
        return this.recordId;
    }

    @Override
    public long getPageNumber() {
        return this.pageId.getPageNumber();
    }

    @Override
    public Object getPageId() {
        return this.pageId;
    }

    @Override
    public ContainerKey getContainerId() {
        return this.pageId.getContainerId();
    }

    @Override
    public int getSlotNumberHint() {
        return this.slotNumberHint;
    }

    @Override
    public void lockEvent(Latch latch) {
    }

    @Override
    public boolean requestCompatible(Object object, Object object2) {
        RowLock rowLock = (RowLock)object;
        RowLock rowLock2 = (RowLock)object2;
        return rowLock.isCompatible(rowLock2);
    }

    @Override
    public boolean lockerAlwaysCompatible() {
        return true;
    }

    @Override
    public void unlockEvent(Latch latch) {
    }

    public boolean equals(Object object) {
        if (!(object instanceof RecordId)) {
            return false;
        }
        RecordId recordId = (RecordId)object;
        return this.recordId == recordId.recordId && this.pageId.equals(recordId.pageId);
    }

    public int hashCode() {
        int n2 = 7;
        n2 = 89 * n2 + this.pageId.hashCode();
        n2 = 89 * n2 + this.recordId;
        return n2;
    }

    public String toString() {
        return null;
    }

    @Override
    public boolean lockAttributes(int n2, Hashtable<String, Object> hashtable) {
        if ((n2 & 2) == 0) {
            return false;
        }
        hashtable.put("CONTAINERID", this.pageId.getContainerId().getContainerId());
        hashtable.put("LOCKNAME", "(" + this.pageId.getPageNumber() + "," + this.recordId + ")");
        hashtable.put("TYPE", "ROW");
        return true;
    }
}

