/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PhysicalPageOperation;

public final class PurgeOperation
extends PhysicalPageOperation {
    protected int slot;
    protected int num_rows;
    protected int[] recordIds;
    protected transient ByteArray preparedLog;

    PurgeOperation(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, int[] nArray, boolean bl2) throws StandardException {
        super(basePage);
        this.slot = n2;
        this.num_rows = n3;
        this.recordIds = nArray;
        try {
            this.writeOptionalDataToBuffer(rawTransaction, bl2);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
    }

    public PurgeOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.slot);
        CompressedNumber.writeInt(objectOutput, this.num_rows);
        for (int i2 = 0; i2 < this.num_rows; ++i2) {
            CompressedNumber.writeInt(objectOutput, this.recordIds[i2]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.slot = CompressedNumber.readInt(objectInput);
        this.num_rows = CompressedNumber.readInt(objectInput);
        this.recordIds = new int[this.num_rows];
        for (int i2 = 0; i2 < this.num_rows; ++i2) {
            this.recordIds[i2] = CompressedNumber.readInt(objectInput);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 106;
    }

    @Override
    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        for (int i2 = this.num_rows - 1; i2 >= 0; --i2) {
            this.page.purgeRecord(logInstant, this.slot + i2, this.recordIds[i2]);
        }
    }

    @Override
    public void undoMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        for (int i2 = 0; i2 < this.num_rows; ++i2) {
            basePage.storeRecord(logInstant, this.slot + i2, true, limitObjectInput);
        }
        basePage.setAuxObject(null);
    }

    @Override
    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.undoMe(transaction, basePage, logInstant, limitObjectInput);
    }

    @Override
    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    private void writeOptionalDataToBuffer(RawTransaction rawTransaction, boolean bl2) throws StandardException, IOException {
        int n2;
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = rawTransaction.getLogBuffer();
        int n3 = dynamicByteArrayOutputStream.getPosition();
        for (n2 = 0; n2 < this.num_rows; ++n2) {
            if (bl2) {
                this.page.logRecord(n2 + this.slot, 0, this.recordIds[n2], null, dynamicByteArrayOutputStream, null);
                continue;
            }
            this.page.logRecord(n2 + this.slot, 2, this.recordIds[n2], null, dynamicByteArrayOutputStream, null);
        }
        n2 = dynamicByteArrayOutputStream.getPosition() - n3;
        dynamicByteArrayOutputStream.setPosition(n3);
        this.preparedLog = new ByteArray(dynamicByteArrayOutputStream.getByteArray(), n3, n2);
    }

    @Override
    public String toString() {
        return null;
    }
}

