/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.CopyRowsOperation;
import org.apache.derby.impl.store.raw.data.DeleteOperation;
import org.apache.derby.impl.store.raw.data.InitPageOperation;
import org.apache.derby.impl.store.raw.data.InsertOperation;
import org.apache.derby.impl.store.raw.data.InvalidatePageOperation;
import org.apache.derby.impl.store.raw.data.PageActions;
import org.apache.derby.impl.store.raw.data.PurgeOperation;
import org.apache.derby.impl.store.raw.data.SetReservedSpaceOperation;
import org.apache.derby.impl.store.raw.data.UpdateFieldOperation;
import org.apache.derby.impl.store.raw.data.UpdateOperation;

public class LoggableActions
implements PageActions {
    @Override
    public void actionDelete(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, boolean bl2, LogicalUndo logicalUndo) throws StandardException {
        DeleteOperation deleteOperation = new DeleteOperation(rawTransaction, basePage, n2, n3, bl2, logicalUndo);
        this.doAction(rawTransaction, basePage, deleteOperation);
    }

    @Override
    public int actionUpdate(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, Object[] objectArray, FormatableBitSet formatableBitSet, int n4, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n5, RecordHandle recordHandle) throws StandardException {
        UpdateOperation updateOperation = new UpdateOperation(rawTransaction, basePage, n2, n3, objectArray, formatableBitSet, n4, dynamicByteArrayOutputStream, n5, recordHandle);
        this.doAction(rawTransaction, basePage, updateOperation);
        return updateOperation.getNextStartColumn();
    }

    @Override
    public void actionPurge(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, int[] nArray, boolean bl2) throws StandardException {
        PurgeOperation purgeOperation = new PurgeOperation(rawTransaction, basePage, n2, n3, nArray, bl2);
        this.doAction(rawTransaction, basePage, purgeOperation);
    }

    @Override
    public void actionUpdateField(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, int n4, Object object, LogicalUndo logicalUndo) throws StandardException {
        UpdateFieldOperation updateFieldOperation = new UpdateFieldOperation(rawTransaction, basePage, n2, n3, n4, object, logicalUndo);
        this.doAction(rawTransaction, basePage, updateFieldOperation);
    }

    @Override
    public int actionInsert(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, Object[] objectArray, FormatableBitSet formatableBitSet, LogicalUndo logicalUndo, byte by, int n4, boolean bl2, int n5, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n6, int n7) throws StandardException {
        InsertOperation insertOperation = new InsertOperation(rawTransaction, basePage, n2, n3, objectArray, formatableBitSet, logicalUndo, by, n4, bl2, n5, dynamicByteArrayOutputStream, n6, n7);
        this.doAction(rawTransaction, basePage, insertOperation);
        return insertOperation.getNextStartColumn();
    }

    @Override
    public void actionCopyRows(RawTransaction rawTransaction, BasePage basePage, BasePage basePage2, int n2, int n3, int n4, int[] nArray) throws StandardException {
        CopyRowsOperation copyRowsOperation = new CopyRowsOperation(rawTransaction, basePage, basePage2, n2, n3, n4, nArray);
        this.doAction(rawTransaction, basePage, copyRowsOperation);
    }

    @Override
    public void actionInvalidatePage(RawTransaction rawTransaction, BasePage basePage) throws StandardException {
        InvalidatePageOperation invalidatePageOperation = new InvalidatePageOperation(basePage);
        this.doAction(rawTransaction, basePage, invalidatePageOperation);
    }

    @Override
    public void actionInitPage(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, long l2) throws StandardException {
        InitPageOperation initPageOperation = new InitPageOperation(basePage, n2, n3, l2);
        this.doAction(rawTransaction, basePage, initPageOperation);
    }

    @Override
    public void actionShrinkReservedSpace(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, int n4, int n5) throws StandardException {
        SetReservedSpaceOperation setReservedSpaceOperation = new SetReservedSpaceOperation(basePage, n2, n3, n4, n5);
        this.doAction(rawTransaction, basePage, setReservedSpaceOperation);
    }

    private void doAction(RawTransaction rawTransaction, BasePage basePage, Loggable loggable) throws StandardException {
        long l2 = 0L;
        Object var6_5 = null;
        basePage.preDirty();
        rawTransaction.logAndDo(loggable);
    }
}

