/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.LogicalPageOperation;
import org.apache.derby.impl.store.raw.data.ReclaimSpace;

public final class InsertOperation
extends LogicalPageOperation {
    protected int doMeSlot;
    protected byte insertFlag;
    protected transient int startColumn;
    protected transient ByteArray preparedLog;

    InsertOperation(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, Object[] objectArray, FormatableBitSet formatableBitSet, LogicalUndo logicalUndo, byte by, int n4, boolean bl2, int n5, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n6, int n7) throws StandardException {
        super(basePage, logicalUndo, n3);
        this.doMeSlot = n2;
        this.insertFlag = by;
        this.startColumn = n4;
        try {
            this.writeOptionalDataToBuffer(rawTransaction, dynamicByteArrayOutputStream, objectArray, formatableBitSet, bl2, n5, n6, n7);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
    }

    public InsertOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.doMeSlot);
        objectOutput.writeByte(this.insertFlag);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.doMeSlot = CompressedNumber.readInt(objectInput);
        this.insertFlag = objectInput.readByte();
    }

    @Override
    public int getTypeFormatId() {
        return 103;
    }

    @Override
    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.page.storeRecord(logInstant, this.doMeSlot, true, limitObjectInput);
    }

    @Override
    public void undoMe(Transaction transaction, BasePage basePage, int n2, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        int n3 = basePage.findRecordById(n2, 0);
        RawTransaction rawTransaction = (RawTransaction)transaction;
        if ((this.insertFlag & 2) != 0) {
            basePage.purgeRecord(logInstant, n3, n2);
            if (rawTransaction.handlesPostTerminationWork() && basePage.isOverflowPage() && basePage.recordCount() == 0) {
                ReclaimSpace reclaimSpace = new ReclaimSpace(2, (PageKey)basePage.getIdentity(), rawTransaction.getDataFactory(), true);
                rawTransaction.addPostTerminationWork(reclaimSpace);
            }
        } else {
            basePage.setDeleteStatus(logInstant, n3, true);
            if (rawTransaction.handlesPostTerminationWork() && !basePage.isOverflowPage() && basePage.shouldReclaimSpace(basePage.getPageNumber() == 1L ? 1 : 0, n3)) {
                ((BaseDataFileFactory)rawTransaction.getDataFactory()).insertUndoNotify(rawTransaction, basePage.getPageKey());
            }
        }
        basePage.setAuxObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreLoggedRow(Object[] objectArray, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        Page page = null;
        try {
            page = this.getContainer().getPage(this.getPageId().getPageNumber());
            ((BasePage)page).restoreRecordFromStream(limitObjectInput, objectArray);
        }
        finally {
            if (page != null) {
                page.unlatch();
                page = null;
            }
        }
    }

    @Override
    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.insertFlag = (byte)(this.insertFlag | 2);
        this.undoMe(transaction, basePage, this.recordId, logInstant, limitObjectInput);
    }

    @Override
    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    public int getNextStartColumn() {
        return this.startColumn;
    }

    private void writeOptionalDataToBuffer(RawTransaction rawTransaction, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, Object[] objectArray, FormatableBitSet formatableBitSet, boolean bl2, int n2, int n3, int n4) throws StandardException, IOException {
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream2 = null;
        if (dynamicByteArrayOutputStream != null) {
            dynamicByteArrayOutputStream2 = dynamicByteArrayOutputStream;
        } else {
            n2 = -1;
            n3 = -1;
            dynamicByteArrayOutputStream2 = rawTransaction.getLogBuffer();
        }
        this.startColumn = bl2 ? this.page.logLongColumn(this.doMeSlot, this.recordId, objectArray[0], dynamicByteArrayOutputStream2) : this.page.logRow(this.doMeSlot, true, this.recordId, objectArray, formatableBitSet, dynamicByteArrayOutputStream2, this.startColumn, this.insertFlag, n2, n3, n4);
        int n5 = dynamicByteArrayOutputStream2.getBeginPosition();
        int n6 = dynamicByteArrayOutputStream2.getPosition() - n5;
        this.preparedLog = new ByteArray(dynamicByteArrayOutputStream2.getByteArray(), n5, n6);
    }

    @Override
    public String toString() {
        return null;
    }
}

