/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.io.StorageFile;

final class InputStreamContainer
extends FileContainer {
    private StorageFile containerPath;

    InputStreamContainer(BaseDataFileFactory baseDataFileFactory) {
        super(baseDataFileFactory);
        this.canUpdate = false;
    }

    @Override
    final boolean openContainer(ContainerKey containerKey) throws StandardException {
        FilterInputStream filterInputStream = null;
        try {
            InputStream inputStream = null;
            this.containerPath = this.dataFactory.getContainerPath(containerKey, false);
            try {
                inputStream = this.containerPath.getInputStream();
            }
            catch (IOException iOException) {
                this.containerPath = this.dataFactory.getContainerPath(containerKey, true);
                try {
                    inputStream = this.getInputStream();
                }
                catch (IOException iOException2) {
                    this.containerPath = null;
                    boolean bl2 = false;
                    if (filterInputStream != null) {
                        try {
                            filterInputStream.close();
                        }
                        catch (IOException iOException3) {
                            // empty catch block
                        }
                    }
                    return bl2;
                }
            }
            filterInputStream = new DataInputStream(inputStream);
            this.readHeader(this.getEmbryonicPage((DataInput)((Object)filterInputStream)));
            boolean bl3 = true;
            return bl3;
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDG3.D", iOException, this.getIdentity().toString(), "open", containerKey.toString());
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    void closeContainer() {
        this.containerPath = null;
    }

    @Override
    public final void clean(boolean bl2) throws StandardException {
    }

    @Override
    protected final int preAllocate(long l2, int n2) {
        return 0;
    }

    @Override
    protected void truncatePages(long l2) {
    }

    @Override
    void createContainer(ContainerKey containerKey) throws StandardException {
    }

    @Override
    protected final void removeContainer(LogInstant logInstant, boolean bl2) throws StandardException {
    }

    @Override
    protected final void readPage(long l2, byte[] byArray) throws IOException, StandardException {
        long l3 = l2 * (long)this.pageSize;
        this.readPositionedPage(l3, byArray);
        if (this.dataFactory.databaseEncrypted() && l2 != 0L) {
            this.decryptPage(byArray, this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPositionedPage(long l2, byte[] byArray) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream();
            InputStreamUtil.skipFully(inputStream, l2);
            InputStreamUtil.readFully(inputStream, byArray, 0, this.pageSize);
            inputStream.close();
            inputStream = null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected final void writePage(long l2, byte[] byArray, boolean bl2) throws IOException, StandardException {
    }

    @Override
    protected final void flushAll() {
    }

    protected InputStream getInputStream() throws IOException {
        return this.containerPath.getInputStream();
    }

    @Override
    protected void backupContainer(BaseContainerHandle baseContainerHandle, String string) throws StandardException {
        throw StandardException.newException("XSAI3.S", new Object[0]);
    }

    @Override
    protected void encryptOrDecryptContainer(BaseContainerHandle baseContainerHandle, String string, boolean bl2) throws StandardException {
        throw StandardException.newException("XSAI3.S", new Object[0]);
    }
}

