/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.impl.store.raw.data.BufferedByteHolderInputStream;
import org.apache.derby.impl.store.raw.data.ByteHolder;

public class DecryptInputStream
extends BufferedByteHolderInputStream {
    protected DataFactory dataFactory;
    protected InputStream in;

    public DecryptInputStream(InputStream inputStream, ByteHolder byteHolder, DataFactory dataFactory) throws IOException {
        super(byteHolder);
        this.in = inputStream;
        this.dataFactory = dataFactory;
        this.fillByteHolder();
    }

    @Override
    public void fillByteHolder() throws IOException {
        if (this.bh.available() == 0) {
            this.bh.clear();
            try {
                int n2 = CompressedNumber.readInt(this.in);
                if (n2 == -1) {
                    return;
                }
                int n3 = n2 % this.dataFactory.getEncryptionBlockSize();
                int n4 = n3 == 0 ? 0 : this.dataFactory.getEncryptionBlockSize() - n3;
                int n5 = n2 + n4;
                byte[] byArray = new byte[n5];
                this.in.read(byArray, 0, n5);
                byte[] byArray2 = new byte[n5];
                this.dataFactory.decrypt(byArray, 0, n5, byArray2, 0);
                this.bh.write(byArray2, n4, n2);
            }
            catch (StandardException standardException) {
                throw new IOException();
            }
            this.bh.startReading();
        }
    }
}

