/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PhysicalPageOperation;

public class CopyRowsOperation
extends PhysicalPageOperation {
    protected int num_rows;
    protected int destSlot;
    protected int[] recordIds;
    protected int[] reservedSpace;
    protected transient ByteArray preparedLog;

    CopyRowsOperation(RawTransaction rawTransaction, BasePage basePage, BasePage basePage2, int n2, int n3, int n4, int[] nArray) throws StandardException {
        super(basePage);
        this.num_rows = n3;
        this.destSlot = n2;
        this.recordIds = nArray;
        try {
            this.reservedSpace = new int[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                this.reservedSpace[i2] = basePage2.getReservedCount(i2 + n4);
            }
            this.writeOptionalDataToBuffer(rawTransaction, basePage2, n4);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
    }

    public CopyRowsOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.num_rows);
        CompressedNumber.writeInt(objectOutput, this.destSlot);
        for (int i2 = 0; i2 < this.num_rows; ++i2) {
            CompressedNumber.writeInt(objectOutput, this.recordIds[i2]);
            CompressedNumber.writeInt(objectOutput, this.reservedSpace[i2]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.num_rows = CompressedNumber.readInt(objectInput);
        this.destSlot = CompressedNumber.readInt(objectInput);
        this.recordIds = new int[this.num_rows];
        this.reservedSpace = new int[this.num_rows];
        for (int i2 = 0; i2 < this.num_rows; ++i2) {
            this.recordIds[i2] = CompressedNumber.readInt(objectInput);
            this.reservedSpace[i2] = CompressedNumber.readInt(objectInput);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 210;
    }

    @Override
    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        for (int i2 = 0; i2 < this.num_rows; ++i2) {
            this.page.storeRecord(logInstant, this.destSlot + i2, true, limitObjectInput);
            if (this.reservedSpace[i2] <= 0) continue;
            this.page.reserveSpaceForSlot(logInstant, this.destSlot + i2, this.reservedSpace[i2]);
        }
    }

    @Override
    public void undoMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        for (int i2 = this.num_rows - 1; i2 >= 0; --i2) {
            int n2 = basePage.findRecordById(this.recordIds[i2], i2);
            basePage.purgeRecord(logInstant, n2, this.recordIds[i2]);
        }
        basePage.setAuxObject(null);
    }

    @Override
    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.undoMe(transaction, basePage, logInstant, limitObjectInput);
    }

    @Override
    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    private void writeOptionalDataToBuffer(RawTransaction rawTransaction, BasePage basePage, int n2) throws StandardException, IOException {
        int n3;
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = rawTransaction.getLogBuffer();
        int n4 = dynamicByteArrayOutputStream.getPosition();
        int[] nArray = new int[this.num_rows];
        int n5 = dynamicByteArrayOutputStream.getPosition();
        for (n3 = 0; n3 < this.num_rows; ++n3) {
            basePage.logRecord(n3 + n2, 0, this.recordIds[n3], null, dynamicByteArrayOutputStream, null);
            nArray[n3] = dynamicByteArrayOutputStream.getPosition() - n5;
            n5 = dynamicByteArrayOutputStream.getPosition();
            int n6 = n3;
            nArray[n6] = nArray[n6] + this.reservedSpace[n3];
        }
        if (!this.page.spaceForCopy(this.num_rows, nArray)) {
            throw StandardException.newException("XSDA3.S", new Object[0]);
        }
        n3 = dynamicByteArrayOutputStream.getPosition() - n4;
        dynamicByteArrayOutputStream.setPosition(n4);
        this.preparedLog = new ByteArray(dynamicByteArrayOutputStream.getByteArray(), n4, n3);
    }

    @Override
    public String toString() {
        return null;
    }
}

