/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.impl.store.raw.data.AllocExtent;
import org.apache.derby.impl.store.raw.data.AllocPage;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.SpaceInformation;

class AllocationCache {
    private int numExtents = 0;
    private long[] lowRange;
    private long[] hiRange;
    private boolean[] isDirty;
    private AllocExtent[] extents;
    private long[] extentPageNums;
    private boolean isValid = false;

    protected AllocationCache() {
    }

    protected void reset() {
        this.numExtents = 0;
        this.isValid = false;
        if (this.lowRange != null) {
            for (int i2 = 0; i2 < this.lowRange.length; ++i2) {
                this.lowRange[i2] = -1L;
                this.hiRange[i2] = -1L;
                this.extentPageNums[i2] = -1L;
                this.extents[i2] = null;
                this.isDirty[i2] = false;
            }
        }
    }

    protected long getAllocPageNumber(BaseContainerHandle baseContainerHandle, long l2, long l3) throws StandardException {
        int n2;
        for (n2 = 0; n2 < this.numExtents; ++n2) {
            if (this.lowRange[n2] > l2 || l2 > this.hiRange[n2]) continue;
            return this.extentPageNums[n2];
        }
        if (!this.isValid) {
            this.validate(baseContainerHandle, l3);
            for (n2 = 0; n2 < this.numExtents; ++n2) {
                if (this.lowRange[n2] > l2 || l2 > this.hiRange[n2]) continue;
                return this.extentPageNums[n2];
            }
        }
        return -1L;
    }

    protected long getLastPageNumber(BaseContainerHandle baseContainerHandle, long l2) throws StandardException {
        if (!this.isValid) {
            this.validate(baseContainerHandle, l2);
        }
        return this.hiRange[this.numExtents - 1];
    }

    protected void trackUnfilledPage(long l2, boolean bl2) {
        if (!this.isValid || this.numExtents <= 0) {
            return;
        }
        for (int i2 = 0; i2 < this.numExtents; ++i2) {
            if (this.lowRange[i2] > l2 || l2 > this.hiRange[i2]) continue;
            AllocExtent allocExtent = this.extents[i2];
            if (allocExtent == null || !allocExtent.trackUnfilledPage(l2, bl2) || this.extents[i2] == null) break;
            this.isDirty[i2] = true;
            break;
        }
    }

    protected long getUnfilledPageNumber(BaseContainerHandle baseContainerHandle, long l2, long l3) throws StandardException {
        if (!this.isValid) {
            this.validate(baseContainerHandle, l2);
        }
        if (l3 == -1L) {
            for (int i2 = 0; i2 < this.numExtents; ++i2) {
                if (this.extents[i2] == null) continue;
                return this.extents[i2].getUnfilledPageNumber(l3);
            }
        } else {
            for (int i3 = 0; i3 < this.numExtents; ++i3) {
                if (l3 > this.hiRange[i3] || this.extents[i3] == null) continue;
                return this.extents[i3].getUnfilledPageNumber(l3);
            }
        }
        return -1L;
    }

    protected long getEstimatedPageCount(BaseContainerHandle baseContainerHandle, long l2) throws StandardException {
        if (!this.isValid) {
            this.validate(baseContainerHandle, l2);
        }
        long l3 = 0L;
        for (int i2 = 0; i2 < this.numExtents; ++i2) {
            if (this.extents[i2] == null) continue;
            l3 += (long)this.extents[i2].getAllocatedPageCount();
        }
        return l3;
    }

    protected SpaceInformation getAllPageCounts(BaseContainerHandle baseContainerHandle, long l2) throws StandardException {
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        if (!this.isValid) {
            this.validate(baseContainerHandle, l2);
        }
        for (int i2 = 0; i2 < this.numExtents; ++i2) {
            if (this.extents[i2] == null) continue;
            l3 = this.extents[i2].getAllocatedPageCount();
            l4 += l3;
            l6 += (long)this.extents[i2].getUnfilledPageCount();
            l5 += (long)this.extents[i2].getTotalPageCount() - l3;
        }
        return new SpaceInformation(l4, l5, l6);
    }

    protected void invalidate() {
        for (int i2 = 0; i2 < this.numExtents; ++i2) {
            this.isDirty[i2] = false;
            this.extents[i2] = null;
        }
        this.isValid = false;
    }

    protected void invalidate(AllocPage allocPage, long l2) throws StandardException {
        this.isValid = false;
        if (this.numExtents == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.numExtents; ++i2) {
            if (this.extentPageNums[i2] != l2) continue;
            if (allocPage != null && this.extents[i2] != null && this.isDirty[i2]) {
                allocPage.updateUnfilledPageInfo(this.extents[i2]);
                this.isDirty[i2] = false;
            }
            this.extents[i2] = null;
            return;
        }
        if (l2 > this.hiRange[this.numExtents - 1]) {
            return;
        }
    }

    protected void invalidateLastExtent() {
        this.isValid = false;
        if (this.numExtents > 0) {
            this.extents[this.numExtents - 1] = null;
        }
    }

    protected long getLastValidPage(BaseContainerHandle baseContainerHandle, long l2) throws StandardException {
        AllocExtent allocExtent = null;
        long l3 = -1L;
        if (!this.isValid) {
            this.validate(baseContainerHandle, l2);
        }
        if (this.numExtents == 0) {
            return -1L;
        }
        for (int i2 = this.numExtents - 1; i2 >= 0 && (l3 = (allocExtent = this.extents[i2]).getLastValidPageNumber()) == -1L; --i2) {
        }
        return l3;
    }

    protected long getNextValidPage(BaseContainerHandle baseContainerHandle, long l2, long l3) throws StandardException {
        int n2;
        if (!this.isValid) {
            this.validate(baseContainerHandle, l3);
        }
        if (this.numExtents == 0) {
            return -1L;
        }
        AllocExtent allocExtent = null;
        for (n2 = 0; n2 < this.numExtents; ++n2) {
            if (l2 >= this.hiRange[n2]) continue;
            allocExtent = this.extents[n2];
            break;
        }
        if (allocExtent == null) {
            return -1L;
        }
        long l4 = -1L;
        while (n2 < this.numExtents && (l4 = (allocExtent = this.extents[n2]).getNextValidPageNumber(l2)) == -1L) {
            ++n2;
        }
        return l4;
    }

    protected int getPageStatus(BaseContainerHandle baseContainerHandle, long l2, long l3) throws StandardException {
        int n2;
        AllocExtent allocExtent = null;
        for (n2 = 0; n2 < this.numExtents; ++n2) {
            if (this.lowRange[n2] > l2 || l2 > this.hiRange[n2]) continue;
            allocExtent = this.extents[n2];
            break;
        }
        if (allocExtent == null) {
            if (!this.isValid) {
                this.validate(baseContainerHandle, l3);
            }
            for (n2 = 0; n2 < this.numExtents; ++n2) {
                if (this.lowRange[n2] > l2 || l2 > this.hiRange[n2]) continue;
                allocExtent = this.extents[n2];
                break;
            }
        }
        return allocExtent.getPageStatus(l2);
    }

    private void validate(BaseContainerHandle baseContainerHandle, long l2) throws StandardException {
        if (this.numExtents == 0) {
            long l3 = l2;
            while (!this.isValid) {
                this.growArrays(++this.numExtents);
                Page page = baseContainerHandle.getAllocPage(l3);
                AllocPage allocPage = (AllocPage)page;
                this.setArrays(this.numExtents - 1, allocPage);
                if (allocPage.isLast()) {
                    this.isValid = true;
                } else {
                    l3 = allocPage.getNextAllocPageNumber();
                }
                allocPage.unlatch();
            }
        } else {
            for (int i2 = 0; i2 < this.numExtents - 1; ++i2) {
                if (this.extents[i2] != null) continue;
                AllocPage allocPage = (AllocPage)baseContainerHandle.getAllocPage(this.extentPageNums[i2]);
                this.setArrays(i2, allocPage);
                allocPage.unlatch();
            }
            long l4 = this.extentPageNums[this.numExtents - 1];
            while (!this.isValid) {
                AllocPage allocPage = (AllocPage)baseContainerHandle.getAllocPage(l4);
                if (this.extents[this.numExtents - 1] == null) {
                    this.setArrays(this.numExtents - 1, allocPage);
                }
                if (!allocPage.isLast()) {
                    this.growArrays(++this.numExtents);
                    l4 = allocPage.getNextAllocPageNumber();
                } else {
                    this.isValid = true;
                }
                allocPage.unlatch();
            }
        }
    }

    private void setArrays(int n2, AllocPage allocPage) {
        AllocExtent allocExtent;
        this.extents[n2] = allocExtent = allocPage.getAllocExtent();
        this.lowRange[n2] = allocExtent.getFirstPagenum();
        this.hiRange[n2] = allocExtent.getLastPagenum();
        this.extentPageNums[n2] = allocPage.getPageNumber();
    }

    private void growArrays(int n2) {
        int n3 = this.lowRange == null || this.lowRange.length == 0 ? 0 : this.lowRange.length;
        if (n3 >= n2) {
            return;
        }
        long[] lArray = this.lowRange;
        long[] lArray2 = this.hiRange;
        AllocExtent[] allocExtentArray = this.extents;
        boolean[] blArray = this.isDirty;
        long[] lArray3 = this.extentPageNums;
        this.lowRange = new long[n2];
        this.hiRange = new long[n2];
        this.isDirty = new boolean[n2];
        this.extents = new AllocExtent[n2];
        this.extentPageNums = new long[n2];
        if (n3 > 0) {
            System.arraycopy(lArray, 0, this.lowRange, 0, lArray.length);
            System.arraycopy(lArray2, 0, this.hiRange, 0, lArray2.length);
            System.arraycopy(blArray, 0, this.isDirty, 0, blArray.length);
            System.arraycopy(allocExtentArray, 0, this.extents, 0, allocExtentArray.length);
            System.arraycopy(lArray3, 0, this.extentPageNums, 0, lArray3.length);
        }
        for (int i2 = n3; i2 < n2; ++i2) {
            this.lowRange[i2] = -1L;
            this.hiRange[i2] = -1L;
            this.isDirty[i2] = false;
            this.extentPageNums[i2] = -1L;
            this.extents[i2] = null;
        }
    }

    protected void dumpAllocationCache() {
    }
}

