/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.store.raw.data.AllocExtent;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.PageCreationArgs;
import org.apache.derby.impl.store.raw.data.StoredPage;

public class AllocPage
extends StoredPage {
    public static final int FORMAT_NUMBER = 118;
    private long nextAllocPageNumber;
    private long nextAllocPageOffset;
    private long reserved1;
    private long reserved2;
    private long reserved3;
    private long reserved4;
    private AllocExtent extent;
    private int borrowedSpace;
    protected static final int ALLOC_PAGE_HEADER_OFFSET = 60;
    protected static final int ALLOC_PAGE_HEADER_SIZE = 48;
    protected static final int BORROWED_SPACE_OFFSET = 108;
    protected static final int BORROWED_SPACE_LEN = 1;
    protected static final int MAX_BORROWED_SPACE = 204;
    public static final String TEST_MULTIPLE_ALLOC_PAGE = null;

    @Override
    public int getTypeFormatId() {
        return 118;
    }

    @Override
    protected int getMaxFreeSpace() {
        return super.getMaxFreeSpace() - 48 - 1 - this.borrowedSpace;
    }

    @Override
    protected void createPage(PageKey pageKey, PageCreationArgs pageCreationArgs) throws StandardException {
        this.borrowedSpace = pageCreationArgs.containerInfoSize;
        super.createPage(pageKey, pageCreationArgs);
        this.pageData[108] = (byte)this.borrowedSpace;
        if (this.borrowedSpace > 0) {
            this.clearSection(109, this.borrowedSpace);
        }
        this.nextAllocPageNumber = -1L;
        this.nextAllocPageOffset = 0L;
        this.reserved4 = 0L;
        this.reserved3 = 0L;
        this.reserved2 = 0L;
        this.reserved1 = 0L;
        this.extent = this.createExtent(pageKey.getPageNumber() + 1L, this.getPageSize(), 0, this.totalSpace);
    }

    private AllocExtent createExtent(long l2, int n2, int n3, int n4) {
        int n5 = AllocExtent.MAX_RANGE(n4);
        return new AllocExtent(l2 * (long)n2, l2, n3, n2, n5);
    }

    @Override
    protected void initFromData(FileContainer fileContainer, PageKey pageKey) throws StandardException {
        int n2;
        if (this.pageData.length < 109) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", pageKey));
        }
        this.borrowedSpace = n2 = this.pageData[108];
        if (this.pageData.length < 109 + n2) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", pageKey));
        }
        if (this.borrowedSpace > 0) {
            this.clearSection(109, this.borrowedSpace);
        }
        super.initFromData(fileContainer, pageKey);
        try {
            this.readAllocPageHeader();
            int n3 = 109 + this.borrowedSpace;
            this.extent = this.readExtent(n3);
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, pageKey));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", classNotFoundException, pageKey));
        }
    }

    @Override
    protected void writePage(PageKey pageKey) throws StandardException {
        try {
            this.updateAllocPageHeader();
            byte by = this.pageData[108];
            if (by > 0) {
                this.clearSection(109, by);
            }
            int n2 = 109 + by;
            this.writeExtent(n2);
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, pageKey));
        }
        super.writePage(pageKey);
    }

    private void readAllocPageHeader() throws IOException {
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(60);
        this.nextAllocPageNumber = arrayInputStream.readLong();
        this.nextAllocPageOffset = arrayInputStream.readLong();
        this.reserved1 = arrayInputStream.readLong();
        this.reserved2 = arrayInputStream.readLong();
        this.reserved3 = arrayInputStream.readLong();
        this.reserved4 = arrayInputStream.readLong();
    }

    private void updateAllocPageHeader() throws IOException {
        this.rawDataOut.setPosition(60);
        this.logicalDataOut.writeLong(this.nextAllocPageNumber);
        this.logicalDataOut.writeLong(this.nextAllocPageOffset);
        this.logicalDataOut.writeLong(0L);
        this.logicalDataOut.writeLong(0L);
        this.logicalDataOut.writeLong(0L);
        this.logicalDataOut.writeLong(0L);
    }

    private AllocExtent readExtent(int n2) throws IOException, ClassNotFoundException {
        ArrayInputStream arrayInputStream = this.rawDataIn;
        this.rawDataIn.setPosition(n2);
        AllocExtent allocExtent = new AllocExtent();
        allocExtent.readExternal(arrayInputStream);
        return allocExtent;
    }

    private void writeExtent(int n2) throws IOException {
        this.rawDataOut.setPosition(n2);
        this.extent.writeExternal(this.logicalDataOut);
    }

    public static void WriteContainerInfo(byte[] byArray, byte[] byArray2, boolean bl2) throws StandardException {
        int n2;
        int n3 = n2 = byArray == null ? 0 : byArray.length;
        if (n2 + 1 + 108 > byArray2.length) {
            // empty if block
        }
        if (bl2) {
            byArray2[108] = (byte)n2;
        } else {
            byte by = byArray2[108];
            if (by != n2) {
                throw StandardException.newException("XSDB3.D", (int)by, n2);
            }
        }
        if (n2 != 0) {
            System.arraycopy(byArray, 0, byArray2, 109, n2);
        }
    }

    public static void ReadContainerInfo(byte[] byArray, byte[] byArray2) throws StandardException {
        byte by = byArray2[108];
        if (by != 0) {
            try {
                System.arraycopy(byArray2, 109, byArray, 0, by);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw StandardException.newException("XSDA4.S", StandardException.newException("XSDG4.D", arrayIndexOutOfBoundsException, byArray2.length, byArray.length, 204, 108, 1, 109, (int)by, StringUtil.hexDump(byArray2)), new Object[0]);
            }
        }
    }

    public long nextFreePageNumber(long l2) {
        return this.extent.getFreePageNumber(l2);
    }

    public void addPage(FileContainer fileContainer, long l2, RawTransaction rawTransaction, BaseContainerHandle baseContainerHandle) throws StandardException {
        this.owner.getAllocationActionSet().actionAllocatePage(rawTransaction, this, l2, 0, 2);
    }

    public void deallocatePage(BaseContainerHandle baseContainerHandle, long l2) throws StandardException {
        this.owner.getAllocationActionSet().actionAllocatePage(baseContainerHandle.getTransaction(), this, l2, 1, 0);
    }

    protected void updateUnfilledPageInfo(AllocExtent allocExtent) {
        this.extent.updateUnfilledPageInfo(allocExtent);
    }

    public boolean canAddFreePage(long l2) {
        if (this.extent.isRetired()) {
            return false;
        }
        if (l2 != -1L && this.extent.getLastPagenum() <= l2 && !this.isLast()) {
            return false;
        }
        return this.extent.canAddFreePage(l2);
    }

    public long getNextAllocPageOffset() {
        return this.nextAllocPageOffset;
    }

    public void chainNewAllocPage(BaseContainerHandle baseContainerHandle, long l2, long l3) throws StandardException {
        this.owner.getAllocationActionSet().actionChainAllocPage(baseContainerHandle.getTransaction(), this, l2, l3);
    }

    public long getNextAllocPageNumber() {
        return this.nextAllocPageNumber;
    }

    public boolean isLast() {
        return this.nextAllocPageNumber == -1L;
    }

    public long getLastPagenum() {
        return this.extent.getLastPagenum();
    }

    public long getMaxPagenum() {
        return this.extent.getExtentEnd();
    }

    protected long getLastPreallocPagenum() {
        return this.extent.getLastPreallocPagenum();
    }

    protected int getPageStatus(long l2) {
        return this.extent.getPageStatus(l2);
    }

    protected void setPageStatus(LogInstant logInstant, long l2, int n2) throws StandardException {
        this.logAction(logInstant);
        switch (n2) {
            case 0: {
                this.extent.allocPage(l2);
                break;
            }
            case 1: {
                this.extent.deallocPage(l2);
                break;
            }
            case 2: {
                this.extent.deallocPage(l2);
            }
        }
    }

    protected void chainNextAllocPage(LogInstant logInstant, long l2, long l3) throws StandardException {
        this.logAction(logInstant);
        this.nextAllocPageNumber = l2;
        this.nextAllocPageOffset = l3;
    }

    protected void compressSpace(LogInstant logInstant, int n2, int n3) throws StandardException {
        this.logAction(logInstant);
        this.extent.compressPages(n2, n3);
    }

    protected void undoCompressSpace(LogInstant logInstant, int n2, int n3) throws StandardException {
        this.logAction(logInstant);
        this.extent.undoCompressPages(n2, n3);
    }

    @Override
    public String toString() {
        return null;
    }

    protected AllocExtent getAllocExtent() {
        return this.extent;
    }

    protected void preAllocatePage(FileContainer fileContainer, int n2, int n3) {
        long l2 = this.extent.getLastPreallocPagenum();
        if (l2 < (long)n2) {
            return;
        }
        if (this.extent.getExtentEnd() < l2 + (long)n3) {
            n3 = (int)(this.extent.getExtentEnd() - l2);
        }
        if (n3 <= 0) {
            return;
        }
        int n4 = fileContainer.preAllocate(l2, n3);
        if (n4 > 0) {
            this.extent.setLastPreallocPagenum(l2 + (long)n4);
        }
    }

    protected boolean compress(RawTransaction rawTransaction, FileContainer fileContainer) throws StandardException {
        boolean bl2 = false;
        int n2 = this.extent.compress(this.owner, rawTransaction, this);
        if (n2 >= 0) {
            fileContainer.truncatePages(this.extent.getPagenum(n2));
            if (n2 == 0) {
                bl2 = true;
            }
        }
        return bl2;
    }
}

