/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.conglomerate.ScanControllerRowSource;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.sort.Scan;
import org.apache.derby.impl.store.access.sort.SortBuffer;

public class SortBufferRowSource
extends Scan
implements ScanControllerRowSource {
    SortBuffer sortBuffer = null;
    protected TransactionManager tran = null;
    private int maxFreeListSize;
    private boolean writingToDisk;
    private SortObserver sortObserver;

    SortBufferRowSource(SortBuffer sortBuffer, TransactionManager transactionManager, SortObserver sortObserver, boolean bl2, int n2) {
        this.sortBuffer = sortBuffer;
        this.tran = transactionManager;
        this.sortObserver = sortObserver;
        this.writingToDisk = bl2;
        this.maxFreeListSize = n2;
    }

    @Override
    public DataValueDescriptor[] getNextRowFromRowSource() {
        if (this.sortBuffer == null) {
            return null;
        }
        DataValueDescriptor[] dataValueDescriptorArray = this.sortBuffer.removeFirst();
        if (dataValueDescriptorArray != null && this.writingToDisk) {
            this.sortObserver.addToFreeList(dataValueDescriptorArray, this.maxFreeListSize);
        }
        return dataValueDescriptorArray;
    }

    @Override
    public boolean needsRowLocation() {
        return false;
    }

    @Override
    public boolean needsRowLocationForDeferredCheckConstraints() {
        return false;
    }

    @Override
    public boolean needsToClone() {
        return false;
    }

    @Override
    public void rowLocation(RowLocation rowLocation) {
    }

    @Override
    public void offendingRowLocation(RowLocation rowLocation, long l2) throws StandardException {
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return null;
    }

    @Override
    public void close() {
        if (this.sortBuffer != null) {
            this.sortBuffer.close();
            this.sortBuffer = null;
        }
        this.tran.closeMe(this);
    }

    @Override
    public boolean closeForEndTransaction(boolean bl2) {
        this.close();
        return true;
    }

    @Override
    public void closeRowSource() {
        this.close();
    }

    @Override
    public boolean next() throws StandardException {
        throw StandardException.newException("XSAS0.S", new Object[0]);
    }

    @Override
    public void fetchWithoutQualify(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        throw StandardException.newException("XSAS0.S", new Object[0]);
    }

    @Override
    public void fetch(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        throw StandardException.newException("XSAS0.S", new Object[0]);
    }

    @Override
    public final boolean fetchNext(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        throw StandardException.newException("XSAS0.S", new Object[0]);
    }
}

