/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.conglomerate.ScanControllerRowSource;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.access.conglomerate.Sort;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.sort.MergeInserter;
import org.apache.derby.impl.store.access.sort.MergeScan;
import org.apache.derby.impl.store.access.sort.MergeScanRowSource;
import org.apache.derby.impl.store.access.sort.Scan;
import org.apache.derby.impl.store.access.sort.SortBuffer;
import org.apache.derby.impl.store.access.sort.SortBufferRowSource;
import org.apache.derby.impl.store.access.sort.SortBufferScan;

class MergeSort
implements Sort {
    private static final int STATE_CLOSED = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_INSERTING = 2;
    private static final int STATE_DONE_INSERTING = 3;
    private static final int STATE_SCANNING = 4;
    private static final int STATE_DONE_SCANNING = 5;
    private int state = 0;
    protected DataValueDescriptor[] template;
    protected ColumnOrdering[] columnOrdering;
    protected int[] columnOrderingMap;
    protected boolean[] columnOrderingAscendingMap;
    protected boolean[] columnOrderingNullsLowMap;
    SortObserver sortObserver;
    protected boolean alreadyInOrder;
    private MergeInserter inserter = null;
    private Scan scan = null;
    private Vector<Long> mergeRuns = null;
    private SortBuffer sortBuffer = null;
    int sortBufferMax;
    int sortBufferMin;
    static Properties properties = null;

    MergeSort() {
    }

    @Override
    public SortController open(TransactionManager transactionManager) throws StandardException {
        this.state = 2;
        this.inserter = new MergeInserter();
        if (!this.inserter.initialize(this, transactionManager)) {
            throw StandardException.newException("XSAS6.S", new Object[0]);
        }
        return this.inserter;
    }

    @Override
    public ScanManager openSortScan(TransactionManager transactionManager, boolean bl2) throws StandardException {
        if (this.mergeRuns == null || this.mergeRuns.size() == 0) {
            this.scan = new SortBufferScan(this, transactionManager, this.sortBuffer, bl2);
            this.sortBuffer = null;
        } else {
            MergeScan mergeScan;
            long l2 = this.createMergeRun(transactionManager, this.sortBuffer);
            this.mergeRuns.addElement(l2);
            if (this.mergeRuns.size() > 512 || this.mergeRuns.size() > this.sortBuffer.capacity()) {
                this.multiStageMerge(transactionManager);
            }
            if (!(mergeScan = new MergeScan(this, transactionManager, this.sortBuffer, this.mergeRuns, this.sortObserver, bl2)).init(transactionManager)) {
                throw StandardException.newException("XSAS6.S", new Object[0]);
            }
            this.scan = mergeScan;
            this.sortBuffer = null;
            this.mergeRuns = null;
        }
        this.state = 4;
        return this.scan;
    }

    @Override
    public ScanControllerRowSource openSortRowSource(TransactionManager transactionManager) throws StandardException {
        ScanControllerRowSource scanControllerRowSource = null;
        if (this.mergeRuns == null || this.mergeRuns.size() == 0) {
            this.scan = new SortBufferRowSource(this.sortBuffer, transactionManager, this.sortObserver, false, this.sortBufferMax);
            scanControllerRowSource = (ScanControllerRowSource)((Object)this.scan);
            this.sortBuffer = null;
        } else {
            MergeScanRowSource mergeScanRowSource;
            long l2 = this.createMergeRun(transactionManager, this.sortBuffer);
            this.mergeRuns.addElement(l2);
            if (this.mergeRuns.size() > 512 || this.mergeRuns.size() > this.sortBuffer.capacity()) {
                this.multiStageMerge(transactionManager);
            }
            if (!(mergeScanRowSource = new MergeScanRowSource(this, transactionManager, this.sortBuffer, this.mergeRuns, this.sortObserver, false)).init(transactionManager)) {
                throw StandardException.newException("XSAS6.S", new Object[0]);
            }
            this.scan = mergeScanRowSource;
            scanControllerRowSource = mergeScanRowSource;
            this.sortBuffer = null;
            this.mergeRuns = null;
        }
        this.state = 4;
        return scanControllerRowSource;
    }

    @Override
    public void drop(TransactionController transactionController) throws StandardException {
        if (this.inserter != null) {
            this.inserter.completedInserts();
        }
        this.inserter = null;
        if (this.scan != null) {
            this.scan.close();
            this.scan = null;
        }
        if (this.sortBuffer != null) {
            this.sortBuffer.close();
            this.sortBuffer = null;
        }
        this.template = null;
        this.columnOrdering = null;
        this.sortObserver = null;
        this.dropMergeRuns((TransactionManager)transactionController);
        this.state = 0;
    }

    private boolean checkColumnOrdering(DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray) {
        int n2 = dataValueDescriptorArray.length;
        boolean[] blArray = new boolean[n2];
        for (int i2 = 0; i2 < columnOrderingArray.length; ++i2) {
            int n3 = columnOrderingArray[i2].getColumnId();
            if (n3 < 0 || n3 >= n2) {
                return false;
            }
            if (blArray[n3]) {
                return false;
            }
            blArray[n3] = true;
            DataValueDescriptor dataValueDescriptor = RowUtil.getColumn(dataValueDescriptorArray, (FormatableBitSet)null, n3);
            if (dataValueDescriptor != null) continue;
            return false;
        }
        return true;
    }

    void checkColumnTypes(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        int n2 = dataValueDescriptorArray.length;
        if (this.template.length != n2) {
            throw StandardException.newException("XSAS3.S", new Object[0]);
        }
    }

    protected int compare(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2) throws StandardException {
        int n2 = this.columnOrdering.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl2;
            int n3;
            int n4;
            if (i2 == n2 - 1 && this.sortObserver.deferrable()) {
                if (!this.sortObserver.deferred()) break;
                this.sortObserver.rememberDuplicate(dataValueDescriptorArray);
            }
            if ((n4 = dataValueDescriptorArray[n3 = this.columnOrderingMap[i2]].compare(dataValueDescriptorArray2[n3], bl2 = this.columnOrderingNullsLowMap[i2])) == 0) continue;
            if (this.columnOrderingAscendingMap[i2]) {
                return n4;
            }
            return -n4;
        }
        return 0;
    }

    public void initialize(DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, SortObserver sortObserver, boolean bl2, long l2, int n2) throws StandardException {
        this.template = dataValueDescriptorArray;
        this.columnOrdering = columnOrderingArray;
        this.sortObserver = sortObserver;
        this.alreadyInOrder = bl2;
        this.columnOrderingMap = new int[columnOrderingArray.length];
        this.columnOrderingAscendingMap = new boolean[columnOrderingArray.length];
        this.columnOrderingNullsLowMap = new boolean[columnOrderingArray.length];
        for (int i2 = 0; i2 < columnOrderingArray.length; ++i2) {
            this.columnOrderingMap[i2] = columnOrderingArray[i2].getColumnId();
            this.columnOrderingAscendingMap[i2] = columnOrderingArray[i2].getIsAscending();
            this.columnOrderingNullsLowMap[i2] = columnOrderingArray[i2].getIsNullsOrderedLow();
        }
        this.inserter = null;
        this.scan = null;
        this.mergeRuns = null;
        this.sortBuffer = null;
        this.sortBufferMax = n2;
        this.sortBufferMin = l2 > (long)n2 ? n2 : (int)l2;
        this.state = 1;
    }

    void doneInserting(MergeInserter mergeInserter, SortBuffer sortBuffer, Vector<Long> vector) {
        this.sortBuffer = sortBuffer;
        this.mergeRuns = vector;
        this.inserter = null;
        this.state = 3;
    }

    void doneScanning(Scan scan, SortBuffer sortBuffer) {
        this.sortBuffer = sortBuffer;
        this.scan = null;
        this.state = 5;
    }

    void doneScanning(Scan scan, SortBuffer sortBuffer, Vector<Long> vector) {
        this.mergeRuns = vector;
        this.doneScanning(scan, sortBuffer);
    }

    void dropMergeRuns(TransactionManager transactionManager) {
        if (this.mergeRuns != null) {
            Enumeration<Long> enumeration = this.mergeRuns.elements();
            try {
                Transaction transaction = transactionManager.getRawStoreXact();
                long l2 = -1L;
                while (enumeration.hasMoreElements()) {
                    long l3 = enumeration.nextElement();
                    transaction.dropStreamContainer(l2, l3);
                }
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            this.mergeRuns = null;
        }
    }

    private void multiStageMerge(TransactionManager transactionManager) throws StandardException {
        int n2 = this.sortBuffer.capacity();
        if (n2 > 512) {
            n2 = 512;
        }
        while (this.mergeRuns.size() > n2) {
            Object object;
            Vector<Long> vector = new Vector<Long>(n2);
            Vector<Long> vector2 = new Vector<Long>(this.mergeRuns.size() - n2);
            Enumeration<Long> enumeration = this.mergeRuns.elements();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (vector.size() < n2) {
                    vector.addElement((Long)object);
                    continue;
                }
                vector2.addElement((Long)object);
            }
            this.mergeRuns = vector2;
            object = new MergeScanRowSource(this, transactionManager, this.sortBuffer, vector, this.sortObserver, false);
            if (!((MergeScan)object).init(transactionManager)) {
                throw StandardException.newException("XSAS6.S", new Object[0]);
            }
            Transaction transaction = transactionManager.getRawStoreXact();
            int n3 = -1;
            long l2 = transaction.addAndLoadStreamContainer(n3, properties, (RowSource)object);
            this.mergeRuns.addElement(l2);
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Long l3 = enumeration.nextElement();
                transaction.dropStreamContainer(n3, l3);
            }
        }
    }

    long createMergeRun(TransactionManager transactionManager, SortBuffer sortBuffer) throws StandardException {
        SortBufferRowSource sortBufferRowSource = new SortBufferRowSource(sortBuffer, null, this.sortObserver, true, this.sortBufferMax);
        Transaction transaction = transactionManager.getRawStoreXact();
        int n2 = -1;
        long l2 = transaction.addAndLoadStreamContainer(n2, properties, sortBufferRowSource);
        sortBufferRowSource = null;
        return l2;
    }

    static {
        properties = new Properties();
        properties.put("derby.storage.streamFileBufferSize", "16384");
    }
}

