/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortInfo;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.sort.MergeSort;
import org.apache.derby.impl.store.access.sort.MergeSortInfo;
import org.apache.derby.impl.store.access.sort.SortBuffer;

final class MergeInserter
implements SortController {
    private MergeSort sort;
    private TransactionManager tran;
    private Vector<Long> mergeRuns;
    private SortBuffer sortBuffer;
    private long beginMemoryUsage;
    private boolean avoidMergeRun;
    private int runSize;
    private int totalRunSize;
    String stat_sortType;
    int stat_numRowsInput;
    int stat_numRowsOutput;
    int stat_numMergeRuns;
    Vector<Integer> stat_mergeRunsSize;

    MergeInserter() {
    }

    @Override
    public void insert(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        this.sort.checkColumnTypes(dataValueDescriptorArray);
        int n2 = this.sortBuffer.insert(dataValueDescriptorArray);
        ++this.stat_numRowsInput;
        if (n2 != 1) {
            ++this.stat_numRowsOutput;
        }
        if (n2 == 2) {
            if (this.avoidMergeRun) {
                Runtime runtime = Runtime.getRuntime();
                long l2 = runtime.freeMemory();
                long l3 = runtime.totalMemory();
                long l4 = l3 - l2;
                long l5 = l4 - this.beginMemoryUsage;
                if (l5 < 0L) {
                    this.beginMemoryUsage = l4;
                }
                if (l5 < 0L || 2L * l5 < (l5 + l2) / 2L || 2L * l5 < 0x100000L && l3 < 0x500000L) {
                    this.sortBuffer.grow(100);
                    if (this.sortBuffer.insert(dataValueDescriptorArray) != 2) {
                        return;
                    }
                }
                this.avoidMergeRun = false;
            }
            this.stat_sortType = "external";
            long l6 = this.sort.createMergeRun(this.tran, this.sortBuffer);
            if (this.mergeRuns == null) {
                this.mergeRuns = new Vector();
            }
            this.mergeRuns.addElement(l6);
            ++this.stat_numMergeRuns;
            this.runSize = this.stat_numRowsInput - this.totalRunSize - 1;
            this.totalRunSize += this.runSize;
            this.stat_mergeRunsSize.addElement(this.runSize);
            this.sortBuffer.insert(dataValueDescriptorArray);
        }
    }

    @Override
    public void completedInserts() {
        if (this.sort != null) {
            this.sort.doneInserting(this, this.sortBuffer, this.mergeRuns);
        }
        if (this.stat_sortType == "external") {
            ++this.stat_numMergeRuns;
            this.stat_mergeRunsSize.addElement(this.stat_numRowsInput - this.totalRunSize);
        }
        this.tran.closeMe(this);
        this.sort = null;
        this.tran = null;
        this.mergeRuns = null;
        this.sortBuffer = null;
    }

    @Override
    public SortInfo getSortInfo() throws StandardException {
        return new MergeSortInfo(this);
    }

    boolean initialize(MergeSort mergeSort, TransactionManager transactionManager) {
        Runtime runtime = Runtime.getRuntime();
        this.beginMemoryUsage = runtime.totalMemory() - runtime.freeMemory();
        this.avoidMergeRun = true;
        this.stat_sortType = "internal";
        this.stat_numMergeRuns = 0;
        this.stat_numRowsInput = 0;
        this.stat_numRowsOutput = 0;
        this.stat_mergeRunsSize = new Vector();
        this.runSize = 0;
        this.totalRunSize = 0;
        this.sort = mergeSort;
        this.tran = transactionManager;
        this.sortBuffer = new SortBuffer(mergeSort);
        return this.sortBuffer.init();
    }
}

