/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanInfo;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.conglomerate.GenericScanController;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;
import org.apache.derby.impl.store.access.heap.HeapPostCommit;
import org.apache.derby.impl.store.access.heap.HeapRowLocation;
import org.apache.derby.impl.store.access.heap.HeapScanInfo;

class HeapScan
extends GenericScanController
implements ScanManager {
    private DataValueDescriptor[][] fetchNext_one_slot_array = new DataValueDescriptor[1][];

    @Override
    protected void queueDeletePostCommitWork(RowPosition rowPosition) throws StandardException {
        TransactionManager transactionManager = this.open_conglom.getXactMgr();
        transactionManager.addPostCommitWork(new HeapPostCommit(transactionManager.getAccessManager(), rowPosition.current_page.getPageKey()));
    }

    @Override
    protected void setRowLocationArray(RowLocation[] rowLocationArray, int n2, RowPosition rowPosition) throws StandardException {
        if (rowLocationArray[n2] == null) {
            rowLocationArray[n2] = new HeapRowLocation(rowPosition.current_rh);
        } else {
            ((HeapRowLocation)rowLocationArray[n2]).setFrom(rowPosition.current_rh);
        }
    }

    @Override
    protected RowLocation makeRowLocation(RowPosition rowPosition) throws StandardException {
        return new HeapRowLocation(rowPosition.current_rh);
    }

    protected void setRowLocationArray(RowLocation[] rowLocationArray, int n2, RecordHandle recordHandle) throws StandardException {
        if (rowLocationArray[n2] == null) {
            rowLocationArray[n2] = new HeapRowLocation(recordHandle);
        } else {
            ((HeapRowLocation)rowLocationArray[n2]).setFrom(recordHandle);
        }
    }

    private boolean reopenScanByRecordHandleAndSetLocks(RecordHandle recordHandle) throws StandardException {
        if (recordHandle == null) {
            return false;
        }
        if (this.scan_position.current_rh != null) {
            this.open_conglom.unlockPositionAfterRead(this.scan_position);
        }
        this.scan_position.current_rh = recordHandle;
        this.scan_position.current_rh_qualified = false;
        boolean bl2 = this.open_conglom.latchPageAndRepositionScan(this.scan_position);
        if (!bl2) {
            this.setScanState(2);
            this.open_conglom.lockPositionForRead(this.scan_position, null, true, true);
        }
        this.scan_position.unlatch();
        return !bl2;
    }

    @Override
    public boolean fetchNext(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        this.fetchNext_one_slot_array[0] = dataValueDescriptorArray == null ? RowUtil.EMPTY_ROW : dataValueDescriptorArray;
        boolean bl2 = this.fetchRows(this.fetchNext_one_slot_array, null, null, 1L, null) == 1;
        return bl2;
    }

    @Override
    public boolean next() throws StandardException {
        this.fetchNext_one_slot_array[0] = this.open_conglom.getRuntimeMem().get_scratch_row(this.open_conglom.getRawTran());
        boolean bl2 = this.fetchRows(this.fetchNext_one_slot_array, null, null, 1L, null) == 1;
        return bl2;
    }

    @Override
    public boolean positionAtRowLocation(RowLocation rowLocation) throws StandardException {
        if (this.open_conglom.isClosed() && !this.rowLocationsInvalidated) {
            this.reopenAfterEndTransaction();
        }
        if (this.rowLocationsInvalidated) {
            return false;
        }
        return this.reopenScanByRecordHandleAndSetLocks(((HeapRowLocation)rowLocation).getRecordHandle(this.open_conglom.getContainer()));
    }

    @Override
    public void fetchLocation(RowLocation rowLocation) throws StandardException {
        if (this.open_conglom.getContainer() == null || this.scan_position.current_rh == null) {
            throw StandardException.newException("XSCH7.S", new Object[0]);
        }
        HeapRowLocation heapRowLocation = (HeapRowLocation)rowLocation;
        heapRowLocation.setFrom(this.scan_position.current_rh);
    }

    @Override
    public int fetchNextGroup(DataValueDescriptor[][] dataValueDescriptorArray, RowLocation[] rowLocationArray) throws StandardException {
        return this.fetchRows(dataValueDescriptorArray, rowLocationArray, null, dataValueDescriptorArray.length, null);
    }

    @Override
    public int fetchNextGroup(DataValueDescriptor[][] dataValueDescriptorArray, RowLocation[] rowLocationArray, RowLocation[] rowLocationArray2) throws StandardException {
        throw StandardException.newException("XSCH8.S", new Object[0]);
    }

    @Override
    public ScanInfo getScanInfo() throws StandardException {
        return new HeapScanInfo(this);
    }

    @Override
    public void reopenScanByRowLocation(RowLocation rowLocation, Qualifier[][] qualifierArray) throws StandardException {
        this.reopenScanByRecordHandle(((HeapRowLocation)rowLocation).getRecordHandle(this.open_conglom.getContainer()), qualifierArray);
    }
}

