/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSet;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RefDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.raw.data.RecordId;

public class HeapRowLocation
extends DataType
implements RefDataValue,
RowLocation {
    private long pageno;
    private int recid;
    private RecordHandle rh;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(HeapRowLocation.class);
    private static final int RECORD_HANDLE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(RecordId.class);

    @Override
    public int estimateMemoryUsage() {
        int n2 = BASE_MEMORY_USAGE;
        if (null != this.rh) {
            n2 += RECORD_HANDLE_MEMORY_USAGE;
        }
        return n2;
    }

    @Override
    public String getTypeName() {
        return "RowLocation";
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int n2, boolean bl2) {
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new HeapRowLocation();
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl2) {
        return new HeapRowLocation(this);
    }

    @Override
    public DataValueDescriptor recycle() {
        this.pageno = 0L;
        this.recid = 0;
        this.rh = null;
        return this;
    }

    @Override
    public int getLength() {
        return 10;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    @Override
    public boolean compare(int n2, DataValueDescriptor dataValueDescriptor, boolean bl2, boolean bl3) {
        int n3 = this.compare(dataValueDescriptor);
        switch (n2) {
            case 1: {
                return n3 < 0;
            }
            case 2: {
                return n3 == 0;
            }
            case 3: {
                return n3 <= 0;
            }
        }
        return false;
    }

    @Override
    public int compare(DataValueDescriptor dataValueDescriptor) {
        HeapRowLocation heapRowLocation = (HeapRowLocation)dataValueDescriptor;
        long l2 = this.pageno;
        long l3 = heapRowLocation.pageno;
        if (l2 < l3) {
            return -1;
        }
        if (l2 > l3) {
            return 1;
        }
        int n2 = this.recid;
        int n3 = heapRowLocation.recid;
        if (n2 == n3) {
            return 0;
        }
        if (n2 < n3) {
            return -1;
        }
        return 1;
    }

    @Override
    public void setValue(RowLocation rowLocation) {
        HeapRowLocation heapRowLocation = (HeapRowLocation)rowLocation;
        this.setFrom(heapRowLocation.rh);
    }

    HeapRowLocation(RecordHandle recordHandle) {
        this.setFrom(recordHandle);
    }

    public HeapRowLocation() {
        this.pageno = 0L;
        this.recid = 0;
    }

    private HeapRowLocation(HeapRowLocation heapRowLocation) {
        this.pageno = heapRowLocation.pageno;
        this.recid = heapRowLocation.recid;
        this.rh = heapRowLocation.rh;
    }

    public RecordHandle getRecordHandle(ContainerHandle containerHandle) throws StandardException {
        if (this.rh != null) {
            return this.rh;
        }
        this.rh = containerHandle.makeRecordHandle(this.pageno, this.recid);
        return this.rh;
    }

    void setFrom(RecordHandle recordHandle) {
        this.pageno = recordHandle.getPageNumber();
        this.recid = recordHandle.getId();
        this.rh = recordHandle;
    }

    @Override
    public int getTypeFormatId() {
        return 90;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        CompressedNumber.writeLong(objectOutput, this.pageno);
        CompressedNumber.writeInt(objectOutput, this.recid);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.pageno = CompressedNumber.readLong(objectInput);
        this.recid = CompressedNumber.readInt(objectInput);
        this.rh = null;
    }

    @Override
    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException, ClassNotFoundException {
        this.pageno = arrayInputStream.readCompressedLong();
        this.recid = arrayInputStream.readCompressedInt();
        this.rh = null;
    }

    @Override
    public void restoreToNull() {
    }

    @Override
    protected void setFrom(DataValueDescriptor dataValueDescriptor) {
        HeapRowLocation heapRowLocation = (HeapRowLocation)dataValueDescriptor;
        this.pageno = heapRowLocation.pageno;
        this.recid = heapRowLocation.recid;
        this.rh = heapRowLocation.rh;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof HeapRowLocation) {
            HeapRowLocation heapRowLocation = (HeapRowLocation)object;
            return this.pageno == heapRowLocation.pageno && this.recid == heapRowLocation.recid;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.pageno ^ this.recid;
    }

    public String toString() {
        String string = "(" + this.pageno + "," + this.recid + ")";
        return string;
    }
}

