/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.impl.store.access.heap.Heap;
import org.apache.derby.impl.store.access.heap.HeapController;

class HeapPostCommit
implements Serviceable {
    private AccessFactory access_factory = null;
    private PageKey page_key = null;

    HeapPostCommit(AccessFactory accessFactory, PageKey pageKey) {
        this.access_factory = accessFactory;
        this.page_key = pageKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void purgeCommittedDeletes(HeapController heapController, long l2) throws StandardException {
        Page page = heapController.getUserPageWait(l2);
        boolean bl2 = false;
        if (page != null) {
            try {
                int n2 = page.recordCount() - page.nonDeletedRecordCount();
                if (n2 > 0) {
                    for (int i2 = page.recordCount() - 1; i2 >= 0; --i2) {
                        RecordHandle recordHandle;
                        boolean bl3 = page.isDeletedAtSlot(i2);
                        if (!bl3 || !(bl3 = heapController.lockRowAtSlotNoWaitExclusive(recordHandle = page.fetchFromSlot(null, i2, RowUtil.EMPTY_ROW, RowUtil.EMPTY_ROW_FETCH_DESCRIPTOR, true)))) continue;
                        bl2 = true;
                        page.purgeAtSlot(i2, 1, false);
                    }
                }
                if (page.recordCount() == 0) {
                    bl2 = true;
                    heapController.removePage(page);
                }
            }
            finally {
                if (!bl2) {
                    page.unlatch();
                    page = null;
                }
            }
        }
    }

    @Override
    public boolean serviceASAP() {
        return true;
    }

    @Override
    public boolean serviceImmediately() {
        return false;
    }

    @Override
    public int performWork(ContextManager contextManager) throws StandardException {
        boolean bl2;
        TransactionManager transactionManager;
        block2: {
            TransactionManager transactionManager2 = (TransactionManager)this.access_factory.getAndNameTransaction(contextManager, "SystemTransaction");
            transactionManager = transactionManager2.getInternalTransaction();
            bl2 = false;
            try {
                HeapController heapController = (HeapController)Heap.openByContainerKey(this.page_key.getContainerId(), transactionManager, transactionManager.getRawStoreXact(), false, 132, 6, transactionManager.getRawStoreXact().newLockingPolicy(1, 4, true), null, null);
                this.purgeCommittedDeletes(heapController, this.page_key.getPageNumber());
            }
            catch (StandardException standardException) {
                if (!standardException.isLockTimeoutOrDeadlock()) break block2;
                bl2 = true;
            }
        }
        transactionManager.commitNoSync(1);
        transactionManager.destroy();
        return bl2 ? 2 : 1;
    }
}

