/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.store.access.StoreCostResult;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.conglomerate.GenericCostController;
import org.apache.derby.impl.store.access.conglomerate.OpenConglomerate;

public class HeapCostController
extends GenericCostController
implements StoreCostController {
    long num_pages;
    long num_rows;
    long page_size;
    long row_size;

    @Override
    public void init(OpenConglomerate openConglomerate) throws StandardException {
        super.init(openConglomerate);
        ContainerHandle containerHandle = openConglomerate.getContainer();
        this.num_rows = containerHandle.getEstimatedRowCount(0);
        if (this.num_rows == 0L) {
            this.num_rows = 1L;
        }
        this.num_pages = containerHandle.getEstimatedPageCount(0);
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "");
        containerHandle.getContainerProperties(properties);
        this.page_size = Integer.parseInt(properties.getProperty("derby.storage.pageSize"));
        this.row_size = this.num_pages * this.page_size / this.num_rows;
    }

    @Override
    public double getFetchFromRowLocationCost(FormatableBitSet formatableBitSet, int n2) throws StandardException {
        double d2 = (double)this.row_size * 0.004;
        long l2 = this.row_size / this.page_size + 1L;
        d2 = (n2 & 1) == 0 ? (d2 += 1.5 * (double)l2) : (d2 += 0.17 * (double)l2);
        return d2;
    }

    @Override
    public void getScanCost(int n2, long l2, int n3, boolean bl2, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, int n4, DataValueDescriptor[] dataValueDescriptorArray3, int n5, boolean bl3, int n6, StoreCostResult storeCostResult) throws StandardException {
        long l3 = l2 < 0L ? this.num_rows : l2;
        double d2 = (double)this.num_pages * 1.5;
        d2 += (double)(l3 * this.row_size) * 0.004;
        long l4 = l3 - this.num_pages;
        if (l4 < 0L) {
            l4 = 0L;
        }
        d2 = n2 == 2 ? (d2 += (double)l4 * 0.12) : (d2 += (double)l4 * 0.14);
        storeCostResult.setEstimatedCost(d2);
        storeCostResult.setEstimatedRowCount(l3);
    }
}

