/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.conglomerate.GenericConglomerateController;
import org.apache.derby.impl.store.access.conglomerate.OpenConglomerate;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;
import org.apache.derby.impl.store.access.heap.Heap;
import org.apache.derby.impl.store.access.heap.HeapPostCommit;
import org.apache.derby.impl.store.access.heap.HeapRowLocation;
import org.apache.derby.impl.store.access.heap.OpenHeap;

public class HeapController
extends GenericConglomerateController
implements ConglomerateController {
    @Override
    protected final void getRowPositionFromRowLocation(RowLocation rowLocation, RowPosition rowPosition) throws StandardException {
        rowPosition.current_rh = ((HeapRowLocation)rowLocation).getRecordHandle(this.open_conglom.getContainer());
        rowPosition.current_rh_qualified = true;
    }

    @Override
    protected void queueDeletePostCommitWork(RowPosition rowPosition) throws StandardException {
        TransactionManager transactionManager = this.open_conglom.getXactMgr();
        transactionManager.addPostCommitWork(new HeapPostCommit(transactionManager.getAccessManager(), rowPosition.current_page.getPageKey()));
    }

    protected final boolean purgeCommittedDeletes(Page page) throws StandardException {
        boolean bl2 = false;
        int n2 = page.recordCount() - page.nonDeletedRecordCount();
        if (n2 > 0) {
            for (int i2 = page.recordCount() - 1; i2 >= 0; --i2) {
                RecordHandle recordHandle;
                boolean bl3 = page.isDeletedAtSlot(i2);
                if (!bl3 || !(bl3 = this.lockRowAtSlotNoWaitExclusive(recordHandle = page.fetchFromSlot(null, i2, RowUtil.EMPTY_ROW, RowUtil.EMPTY_ROW_FETCH_DESCRIPTOR, true)))) continue;
                bl2 = true;
                page.purgeAtSlot(i2, 1, false);
            }
        }
        if (page.recordCount() == 0) {
            this.removePage(page);
            bl2 = true;
        }
        return bl2;
    }

    private RecordHandle doInsert(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        RecordHandle recordHandle;
        byte by;
        Page page = null;
        page = this.open_conglom.getContainer().getPageForInsert(0);
        if (page != null) {
            by = page.recordCount() == 0 ? (byte)8 : 1;
            recordHandle = page.insert(dataValueDescriptorArray, null, by, 100);
            page.unlatch();
            page = null;
            if (recordHandle != null) {
                return recordHandle;
            }
        }
        if ((page = this.open_conglom.getContainer().getPageForInsert(1)) != null) {
            by = page.recordCount() == 0 ? (byte)8 : 1;
            recordHandle = page.insert(dataValueDescriptorArray, null, by, 100);
            page.unlatch();
            page = null;
            if (recordHandle != null) {
                return recordHandle;
            }
        }
        page = this.open_conglom.getContainer().addPage();
        recordHandle = page.insert(dataValueDescriptorArray, null, (byte)8, 100);
        page.unlatch();
        page = null;
        return recordHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long load(TransactionManager transactionManager, Heap heap, boolean bl2, RowLocationRetRowSource rowLocationRetRowSource) throws StandardException {
        OpenHeap openHeap;
        long l2 = 0L;
        int n2 = 5;
        if (bl2) {
            n2 |= 2;
        }
        if ((openHeap = new OpenHeap()).init(null, heap, heap.format_ids, heap.collation_ids, transactionManager, transactionManager.getRawStoreXact(), false, n2, 7, transactionManager.getRawStoreXact().newLockingPolicy(2, 5, true), null) == null) {
            throw StandardException.newException("XSCH1.S", heap.getId().getContainerId());
        }
        this.init(openHeap);
        Page page = openHeap.getContainer().addPage();
        boolean bl3 = rowLocationRetRowSource.needsRowLocation();
        HeapRowLocation heapRowLocation = bl3 || rowLocationRetRowSource.needsRowLocationForDeferredCheckConstraints() ? new HeapRowLocation() : null;
        FormatableBitSet formatableBitSet = rowLocationRetRowSource.getValidColumns();
        try {
            Object[] objectArray;
            while ((objectArray = rowLocationRetRowSource.getNextRowFromRowSource()) != null) {
                ++l2;
                RecordHandle recordHandle = page.insert(objectArray, formatableBitSet, (byte)1, 100);
                if (recordHandle == null) {
                    page.unlatch();
                    page = null;
                    page = openHeap.getContainer().addPage();
                    recordHandle = page.insert(objectArray, formatableBitSet, (byte)8, 100);
                }
                if (bl3) {
                    heapRowLocation.setFrom(recordHandle);
                    rowLocationRetRowSource.rowLocation(heapRowLocation);
                }
                if (!rowLocationRetRowSource.needsRowLocationForDeferredCheckConstraints()) continue;
                heapRowLocation.setFrom(recordHandle);
                rowLocationRetRowSource.offendingRowLocation(heapRowLocation, heap.getContainerid());
            }
            page.unlatch();
            page = null;
            if (!heap.isTemporary()) {
                openHeap.getContainer().flushContainer();
            }
        }
        finally {
            this.close();
        }
        return l2;
    }

    protected boolean lockRow(RecordHandle recordHandle, int n2, boolean bl2, int n3) throws StandardException {
        boolean bl3;
        boolean bl4;
        boolean bl5 = (1 & n2) != 0;
        boolean bl6 = bl4 = (8 & n2) != 0;
        if (bl5 && !bl4) {
            boolean bl7;
            boolean bl8 = (2 & n2) != 0;
            boolean bl9 = bl7 = (4 & n2) != 0;
            bl3 = n3 == 1 ? this.open_conglom.getContainer().getLockingPolicy().zeroDurationLockRecordForWrite(this.open_conglom.getRawTran(), recordHandle, bl7, bl2) : this.open_conglom.getContainer().getLockingPolicy().lockRecordForWrite(this.open_conglom.getRawTran(), recordHandle, bl8, bl2);
        } else {
            bl3 = this.open_conglom.getContainer().getLockingPolicy().lockRecordForRead(this.open_conglom.getRawTran(), this.open_conglom.getContainer(), recordHandle, bl2, bl5);
        }
        return bl3;
    }

    protected Page getUserPageNoWait(long l2) throws StandardException {
        return this.open_conglom.getContainer().getUserPageNoWait(l2);
    }

    protected Page getUserPageWait(long l2) throws StandardException {
        return this.open_conglom.getContainer().getUserPageWait(l2);
    }

    protected boolean lockRowAtSlotNoWaitExclusive(RecordHandle recordHandle) throws StandardException {
        try {
            return this.open_conglom.getContainer().getLockingPolicy().lockRecordForWrite(this.open_conglom.getRawTran(), recordHandle, false, false);
        }
        catch (StandardException standardException) {
            if (standardException.isSelfDeadlock()) {
                return false;
            }
            throw standardException;
        }
    }

    protected void removePage(Page page) throws StandardException {
        this.open_conglom.getContainer().removePage(page);
    }

    @Override
    public int insert(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                this.open_conglom.reopen();
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        this.doInsert(dataValueDescriptorArray);
        return 0;
    }

    @Override
    public void insertAndFetchLocation(DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation) throws StandardException {
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                this.open_conglom.reopen();
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        RecordHandle recordHandle = this.doInsert(dataValueDescriptorArray);
        HeapRowLocation heapRowLocation = (HeapRowLocation)rowLocation;
        heapRowLocation.setFrom(recordHandle);
    }

    @Override
    public boolean lockRow(RowLocation rowLocation, int n2, boolean bl2, int n3) throws StandardException {
        RecordHandle recordHandle = ((HeapRowLocation)rowLocation).getRecordHandle(this.open_conglom.getContainer());
        return this.lockRow(recordHandle, n2, bl2, n3);
    }

    @Override
    public void unlockRowAfterRead(RowLocation rowLocation, boolean bl2, boolean bl3) throws StandardException {
        RecordHandle recordHandle = ((HeapRowLocation)rowLocation).getRecordHandle(this.open_conglom.getContainer());
        this.open_conglom.getContainer().getLockingPolicy().unlockRecordAfterRead(this.open_conglom.getRawTran(), this.open_conglom.getContainer(), recordHandle, this.open_conglom.isForUpdate(), bl3);
    }

    @Override
    public boolean lockRow(long l2, int n2, int n3, boolean bl2, int n4) throws StandardException {
        RecordHandle recordHandle = this.open_conglom.getContainer().makeRecordHandle(l2, n2);
        return this.lockRow(recordHandle, n3, bl2, n4);
    }

    @Override
    public RowLocation newRowLocationTemplate() throws StandardException {
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                this.open_conglom.reopen();
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        return new HeapRowLocation();
    }

    public OpenConglomerate getOpenConglomerate() {
        return this.open_conglom;
    }
}

