/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.conglomerate;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLLongint;

public final class TemplateRow {
    private TemplateRow() {
    }

    private static DataValueDescriptor[] allocate_objects(Transaction transaction, int n2, FormatableBitSet formatableBitSet, int[] nArray, int[] nArray2) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[n2];
        int n3 = formatableBitSet == null ? nArray.length : formatableBitSet.size();
        DataValueFactory dataValueFactory = transaction.getDataValueFactory();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (formatableBitSet != null && !formatableBitSet.get(i2)) continue;
            dataValueDescriptorArray[i2] = dataValueFactory.getNull(nArray[i2], nArray2[i2]);
        }
        return dataValueDescriptorArray;
    }

    public static DataValueDescriptor[] newU8Row(int n2) {
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[n2];
        for (int i2 = 0; i2 < dataValueDescriptorArray.length; ++i2) {
            dataValueDescriptorArray[i2] = new SQLLongint(Long.MIN_VALUE);
        }
        return dataValueDescriptorArray;
    }

    public static DataValueDescriptor[] newRow(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length];
        int n2 = dataValueDescriptorArray.length;
        while (n2-- > 0) {
            dataValueDescriptorArray2[n2] = dataValueDescriptorArray[n2].getNewNull();
        }
        return dataValueDescriptorArray2;
    }

    public static DataValueDescriptor[] newRow(Transaction transaction, FormatableBitSet formatableBitSet, int[] nArray, int[] nArray2) throws StandardException {
        return TemplateRow.allocate_objects(transaction, nArray.length, formatableBitSet, nArray, nArray2);
    }

    public static DataValueDescriptor[] newBranchRow(Transaction transaction, int[] nArray, int[] nArray2, DataValueDescriptor dataValueDescriptor) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.allocate_objects(transaction, nArray.length + 1, null, nArray, nArray2);
        dataValueDescriptorArray[nArray.length] = dataValueDescriptor;
        return dataValueDescriptorArray;
    }

    public static boolean checkColumnTypes(DataValueFactory dataValueFactory, int[] nArray, int[] nArray2, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        boolean bl2;
        block0: {
            bl2 = true;
            int n2 = dataValueDescriptorArray.length;
            if (nArray.length == dataValueDescriptorArray.length) break block0;
            bl2 = false;
        }
        return bl2;
    }
}

