/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree.index;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.BTreeRowPosition;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.WaitError;
import org.apache.derby.impl.store.access.btree.index.B2I;
import org.apache.derby.impl.store.access.heap.HeapController;

class B2IRowLocking3
implements BTreeLockingPolicy {
    protected ConglomerateController base_cc;
    protected OpenBTree open_btree;
    private Transaction rawtran;

    B2IRowLocking3(Transaction transaction, int n2, LockingPolicy lockingPolicy, ConglomerateController conglomerateController, OpenBTree openBTree) {
        this.rawtran = transaction;
        this.base_cc = conglomerateController;
        this.open_btree = openBTree;
    }

    private boolean lockPreviousToFirstKey(LeafControlRow leafControlRow, LeafControlRow leafControlRow2, int n2, int n3) throws StandardException {
        boolean bl2 = this.base_cc.lockRow(1L, 3, n2, false, n3);
        if (!bl2) {
            leafControlRow.release();
            leafControlRow = null;
            if (leafControlRow2 != null) {
                leafControlRow2.release();
                leafControlRow2 = null;
            }
            this.base_cc.lockRow(1L, 3, n2, true, n3);
        }
        return bl2;
    }

    private boolean lockRowOnPage(LeafControlRow leafControlRow, LeafControlRow leafControlRow2, int n2, BTreeRowPosition bTreeRowPosition, FetchDescriptor fetchDescriptor, DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation, int n3, int n4) throws StandardException {
        RecordHandle recordHandle = leafControlRow.getPage().fetchFromSlot(null, n2, dataValueDescriptorArray, fetchDescriptor, true);
        boolean bl2 = this.base_cc.lockRow(rowLocation, n3, false, n4);
        if (!bl2) {
            if (bTreeRowPosition != null) {
                bTreeRowPosition.saveMeAndReleasePage();
            } else if (leafControlRow != null) {
                leafControlRow.release();
                leafControlRow = null;
            }
            if (leafControlRow2 != null) {
                leafControlRow2.release();
                leafControlRow2 = null;
            }
            if ((((HeapController)this.base_cc).getOpenConglomerate().getOpenMode() & 0x8000) != 0) {
                throw StandardException.newException("40XL1", new Object[0]);
            }
            this.base_cc.lockRow(rowLocation, n3, true, n4);
        }
        return bl2;
    }

    private boolean searchLeftAndLockPreviousKey(LeafControlRow leafControlRow, FetchDescriptor fetchDescriptor, DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation, OpenBTree openBTree, int n2, int n3) throws StandardException {
        long l2;
        LeafControlRow leafControlRow2;
        boolean bl2 = false;
        try {
            leafControlRow2 = (LeafControlRow)leafControlRow.getLeftSibling(openBTree);
        }
        catch (WaitError waitError) {
            l2 = leafControlRow.getleftSiblingPageNumber();
            leafControlRow.release();
            leafControlRow = null;
            leafControlRow2 = (LeafControlRow)ControlRow.get(openBTree, l2);
            bl2 = true;
        }
        block4: while (true) {
            try {
                while (true) {
                    if (leafControlRow2.getPage().recordCount() > 1) {
                        boolean bl3 = this.lockRowOnPage(leafControlRow2, leafControlRow, leafControlRow2.getPage().recordCount() - 1, null, fetchDescriptor, dataValueDescriptorArray, rowLocation, n2, n3);
                        if (bl3) break block4;
                        leafControlRow2 = null;
                        leafControlRow = null;
                        bl2 = true;
                        break block4;
                    }
                    if (leafControlRow2.isLeftmostLeaf()) {
                        boolean bl4 = this.lockPreviousToFirstKey(leafControlRow2, leafControlRow, n2, n3);
                        if (bl4) break block4;
                        leafControlRow2 = null;
                        leafControlRow = null;
                        bl2 = true;
                        break block4;
                    }
                    LeafControlRow leafControlRow3 = (LeafControlRow)leafControlRow2.getLeftSibling(openBTree);
                    leafControlRow2.release();
                    leafControlRow2 = leafControlRow3;
                    leafControlRow3 = null;
                }
            }
            catch (WaitError waitError) {
                l2 = leafControlRow2.getleftSiblingPageNumber();
                if (leafControlRow != null) {
                    leafControlRow.release();
                    leafControlRow = null;
                }
                leafControlRow2.release();
                leafControlRow2 = null;
                leafControlRow2 = (LeafControlRow)ControlRow.get(openBTree, l2);
                bl2 = true;
                continue;
            }
            break;
        }
        if (leafControlRow2 != null) {
            leafControlRow2.release();
        }
        return !bl2;
    }

    protected boolean _lockScanRow(OpenBTree openBTree, BTreeRowPosition bTreeRowPosition, boolean bl2, FetchDescriptor fetchDescriptor, DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation, boolean bl3, boolean bl4, int n2) throws StandardException {
        boolean bl5 = false;
        if (bl2) {
            bl5 = bTreeRowPosition.current_slot == 0 ? !this.lockNonScanPreviousRow(bTreeRowPosition.current_leaf, 1, fetchDescriptor, dataValueDescriptorArray, rowLocation, openBTree, n2, 2) : !this.lockRowOnPage(bTreeRowPosition.current_leaf, null, bTreeRowPosition.current_slot, bTreeRowPosition, fetchDescriptor, dataValueDescriptorArray, rowLocation, n2, 2);
        }
        return !bl5;
    }

    @Override
    public boolean lockScanCommittedDeletedRow(OpenBTree openBTree, LeafControlRow leafControlRow, DataValueDescriptor[] dataValueDescriptorArray, FetchDescriptor fetchDescriptor, int n2) throws StandardException {
        RowLocation rowLocation = (RowLocation)dataValueDescriptorArray[((B2I)openBTree.getConglomerate()).rowLocationColumn];
        leafControlRow.getPage().fetchFromSlot(null, n2, dataValueDescriptorArray, fetchDescriptor, true);
        return this.base_cc.lockRow(rowLocation, 1, false, 2);
    }

    @Override
    public boolean lockScanRow(OpenBTree openBTree, BTreeRowPosition bTreeRowPosition, FetchDescriptor fetchDescriptor, DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation, boolean bl2, boolean bl3, int n2) throws StandardException {
        return this._lockScanRow(openBTree, bTreeRowPosition, true, fetchDescriptor, dataValueDescriptorArray, rowLocation, bl2, bl3, n2);
    }

    @Override
    public void unlockScanRecordAfterRead(BTreeRowPosition bTreeRowPosition, boolean bl2) throws StandardException {
    }

    @Override
    public boolean lockNonScanPreviousRow(LeafControlRow leafControlRow, int n2, FetchDescriptor fetchDescriptor, DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation, OpenBTree openBTree, int n3, int n4) throws StandardException {
        boolean bl2 = n2 > 1 ? this.lockRowOnPage(leafControlRow, null, n2 - 1, null, fetchDescriptor, dataValueDescriptorArray, rowLocation, n3, n4) : (leafControlRow.isLeftmostLeaf() ? this.lockPreviousToFirstKey(leafControlRow, null, n3, n4) : this.searchLeftAndLockPreviousKey(leafControlRow, fetchDescriptor, dataValueDescriptorArray, rowLocation, openBTree, n3, n4));
        return bl2;
    }

    @Override
    public boolean lockNonScanRow(BTree bTree, LeafControlRow leafControlRow, LeafControlRow leafControlRow2, DataValueDescriptor[] dataValueDescriptorArray, int n2) throws StandardException {
        B2I b2I = (B2I)bTree;
        boolean bl2 = this.base_cc.lockRow((RowLocation)dataValueDescriptorArray[b2I.rowLocationColumn], n2, false, 2);
        if (!bl2) {
            if (leafControlRow != null) {
                leafControlRow.release();
                leafControlRow = null;
            }
            if (leafControlRow2 != null) {
                leafControlRow2.release();
                leafControlRow2 = null;
            }
            this.base_cc.lockRow((RowLocation)dataValueDescriptorArray[b2I.rowLocationColumn], n2, true, 2);
        }
        return bl2;
    }

    @Override
    public boolean lockNonScanRowOnPage(LeafControlRow leafControlRow, int n2, FetchDescriptor fetchDescriptor, DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation, int n3) throws StandardException {
        return this.lockRowOnPage(leafControlRow, null, n2, null, fetchDescriptor, dataValueDescriptorArray, rowLocation, n3, 2);
    }
}

