/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree.index;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.BTreeForwardScan;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.index.B2I;
import org.apache.derby.impl.store.access.btree.index.B2IStaticCompiledInfo;
import org.apache.derby.impl.store.access.btree.index.B2IUndo;

public class B2IForwardScan
extends BTreeForwardScan {
    private ConglomerateController base_cc_for_locking;
    private int init_isolation_level;

    B2IForwardScan() {
    }

    @Override
    public void close() throws StandardException {
        super.close();
        if (this.base_cc_for_locking != null) {
            this.base_cc_for_locking.close();
            this.base_cc_for_locking = null;
        }
    }

    @Override
    public boolean closeForEndTransaction(boolean bl2) throws StandardException {
        boolean bl3 = super.closeForEndTransaction(bl2);
        if (this.base_cc_for_locking != null) {
            this.base_cc_for_locking.close();
            this.base_cc_for_locking = null;
        }
        return bl3;
    }

    @Override
    public ContainerHandle reopen() throws StandardException {
        ContainerHandle containerHandle = super.reopen();
        B2I b2I = (B2I)this.getConglomerate();
        int n2 = this.getOpenMode() | 0x40;
        this.base_cc_for_locking = this.getXactMgr().openConglomerate(b2I.baseConglomerateId, false, n2, this.init_lock_level, this.init_isolation_level);
        this.setLockingPolicy(b2I.getBtreeLockingPolicy(this.getXactMgr().getRawStoreXact(), this.getLockLevel(), this.getOpenMode(), this.init_isolation_level, this.base_cc_for_locking, this));
        return containerHandle;
    }

    public void init(TransactionManager transactionManager, Transaction transaction, boolean bl2, int n2, int n3, LockingPolicy lockingPolicy, int n4, boolean bl3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n5, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n6, B2I b2I, B2IUndo b2IUndo, B2IStaticCompiledInfo b2IStaticCompiledInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        int n7 = n2 | 0x40;
        this.base_cc_for_locking = b2IStaticCompiledInfo != null ? transactionManager.openCompiledConglomerate(false, n7, n3, n4, b2IStaticCompiledInfo.base_table_static_info, ((Conglomerate)b2IStaticCompiledInfo.getConglom()).getDynamicCompiledConglomInfo()) : transactionManager.openConglomerate(b2I.baseConglomerateId, false, n7, n3, n4);
        BTreeLockingPolicy bTreeLockingPolicy = b2I.getBtreeLockingPolicy(transaction, n3, n2, n4, this.base_cc_for_locking, this);
        super.init(transactionManager, transaction, bl2, n2, n3, bTreeLockingPolicy, formatableBitSet, dataValueDescriptorArray, n5, qualifierArray, dataValueDescriptorArray2, n6, b2I, b2IUndo, b2IStaticCompiledInfo, dynamicCompiledOpenConglomInfo);
        this.init_isolation_level = n4;
    }
}

