/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree.index;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.index.B2IController;
import org.apache.derby.impl.store.access.btree.index.B2ICostController;
import org.apache.derby.impl.store.access.btree.index.B2IForwardScan;
import org.apache.derby.impl.store.access.btree.index.B2IMaxScan;
import org.apache.derby.impl.store.access.btree.index.B2IRowLocking1;
import org.apache.derby.impl.store.access.btree.index.B2IRowLocking2;
import org.apache.derby.impl.store.access.btree.index.B2IRowLocking3;
import org.apache.derby.impl.store.access.btree.index.B2IRowLockingRR;
import org.apache.derby.impl.store.access.btree.index.B2IStaticCompiledInfo;
import org.apache.derby.impl.store.access.btree.index.B2ITableLocking3;
import org.apache.derby.impl.store.access.btree.index.B2IUndo;
import org.apache.derby.impl.store.access.conglomerate.ConglomerateUtil;

public class B2I
extends BTree {
    private static final String PROPERTY_BASECONGLOMID = "baseConglomerateId";
    private static final String PROPERTY_ROWLOCCOLUMN = "rowLocationColumn";
    static final int FORMAT_NUMBER = 470;
    long baseConglomerateId;
    int rowLocationColumn;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(B2I.class);

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    @Override
    protected BTreeLockingPolicy getBtreeLockingPolicy(Transaction transaction, int n2, int n3, int n4, ConglomerateController conglomerateController, OpenBTree openBTree) throws StandardException {
        BTreeLockingPolicy bTreeLockingPolicy = null;
        if (n2 == 7) {
            bTreeLockingPolicy = new B2ITableLocking3(transaction, n2, transaction.newLockingPolicy(2, n4, true), conglomerateController, openBTree);
        } else if (n2 == 6) {
            if (n4 == 5) {
                bTreeLockingPolicy = new B2IRowLocking3(transaction, n2, transaction.newLockingPolicy(1, n4, true), conglomerateController, openBTree);
            } else if (n4 == 4) {
                bTreeLockingPolicy = new B2IRowLockingRR(transaction, n2, transaction.newLockingPolicy(1, n4, true), conglomerateController, openBTree);
            } else if (n4 == 2 || n4 == 3) {
                bTreeLockingPolicy = new B2IRowLocking2(transaction, n2, transaction.newLockingPolicy(1, n4, true), conglomerateController, openBTree);
            } else if (n4 == 1) {
                bTreeLockingPolicy = new B2IRowLocking1(transaction, n2, transaction.newLockingPolicy(1, n4, true), conglomerateController, openBTree);
            }
        }
        return bTreeLockingPolicy;
    }

    @Override
    public final ConglomerateController lockTable(TransactionManager transactionManager, int n2, int n3, int n4) throws StandardException {
        ConglomerateController conglomerateController = transactionManager.openConglomerate(this.baseConglomerateId, false, n2 |= 0x40, n3, n4);
        return conglomerateController;
    }

    private void traverseRight() {
    }

    public void create(TransactionManager transactionManager, int n2, long l2, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, int[] nArray, Properties properties, int n3) throws StandardException {
        String string = null;
        Transaction transaction = transactionManager.getRawStoreXact();
        if (properties == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_BASECONGLOMID);
        }
        string = properties.getProperty(PROPERTY_BASECONGLOMID);
        if (string == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_BASECONGLOMID);
        }
        this.baseConglomerateId = Long.parseLong(string);
        string = properties.getProperty(PROPERTY_ROWLOCCOLUMN);
        if (string == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_BASECONGLOMID);
        }
        this.rowLocationColumn = Integer.parseInt(string);
        this.ascDescInfo = new boolean[dataValueDescriptorArray.length];
        for (int i2 = 0; i2 < this.ascDescInfo.length; ++i2) {
            this.ascDescInfo[i2] = columnOrderingArray != null && i2 < columnOrderingArray.length ? columnOrderingArray[i2].getIsAscending() : true;
        }
        this.collation_ids = ConglomerateUtil.createCollationIds(dataValueDescriptorArray.length, nArray);
        this.hasCollatedTypes = B2I.hasCollatedColumns(this.collation_ids);
        super.create(transaction, n2, l2, dataValueDescriptorArray, properties, this.getTypeFormatId(), n3);
        ConglomerateController conglomerateController = transactionManager.openConglomerate(this.baseConglomerateId, false, 64, 7, 5);
        OpenBTree openBTree = new OpenBTree();
        B2ITableLocking3 b2ITableLocking3 = new B2ITableLocking3(transaction, 7, transaction.newLockingPolicy(2, 5, true), conglomerateController, openBTree);
        openBTree.init(transactionManager, transactionManager, null, transaction, false, 4, 7, b2ITableLocking3, this, null, null);
        LeafControlRow.initEmptyBtree(openBTree);
        openBTree.close();
        conglomerateController.close();
    }

    @Override
    public boolean fetchMaxOnBTree(TransactionManager transactionManager, Transaction transaction, long l2, int n2, int n3, LockingPolicy lockingPolicy, int n4, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        B2IMaxScan b2IMaxScan = new B2IMaxScan();
        b2IMaxScan.init(transactionManager, transaction, n2, n3, lockingPolicy, n4, true, formatableBitSet, this, new B2IUndo());
        boolean bl2 = b2IMaxScan.fetchMax(dataValueDescriptorArray);
        b2IMaxScan.close();
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long load(TransactionManager transactionManager, boolean bl2, RowLocationRetRowSource rowLocationRetRowSource) throws StandardException {
        long l2 = 0L;
        try (B2IController b2IController = new B2IController();){
            int n2 = 4;
            if (bl2) {
                n2 |= 3;
            }
            b2IController.init(transactionManager, transactionManager.getRawStoreXact(), false, n2, 7, transactionManager.getRawStoreXact().newLockingPolicy(2, 5, true), true, this, new B2IUndo(), (B2IStaticCompiledInfo)null, (DynamicCompiledOpenConglomInfo)null);
            l2 = b2IController.load(transactionManager, bl2, rowLocationRetRowSource);
        }
        return l2;
    }

    @Override
    public ConglomerateController open(TransactionManager transactionManager, Transaction transaction, boolean bl2, int n2, int n3, LockingPolicy lockingPolicy, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        B2IController b2IController = new B2IController();
        b2IController.init(transactionManager, transaction, bl2, n2, n3, lockingPolicy, true, this, new B2IUndo(), (B2IStaticCompiledInfo)staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
        return b2IController;
    }

    @Override
    public ScanManager openScan(TransactionManager transactionManager, Transaction transaction, boolean bl2, int n2, int n3, LockingPolicy lockingPolicy, int n4, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n5, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n6, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        B2IForwardScan b2IForwardScan = new B2IForwardScan();
        b2IForwardScan.init(transactionManager, transaction, bl2, n2, n3, lockingPolicy, n4, true, formatableBitSet, dataValueDescriptorArray, n5, qualifierArray, dataValueDescriptorArray2, n6, this, new B2IUndo(), (B2IStaticCompiledInfo)staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
        return b2IForwardScan;
    }

    @Override
    public ScanManager defragmentConglomerate(TransactionManager transactionManager, Transaction transaction, boolean bl2, int n2, int n3, LockingPolicy lockingPolicy, int n4) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public void purgeConglomerate(TransactionManager transactionManager, Transaction transaction) throws StandardException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compressConglomerate(TransactionManager transactionManager, Transaction transaction) throws StandardException {
        try (B2IController b2IController = new B2IController();){
            int n2 = 4;
            b2IController.init(transactionManager, transactionManager.getRawStoreXact(), false, n2, 7, transactionManager.getRawStoreXact().newLockingPolicy(2, 5, true), true, this, new B2IUndo(), (B2IStaticCompiledInfo)null, (DynamicCompiledOpenConglomInfo)null);
            b2IController.getContainer().compressContainer();
        }
    }

    @Override
    public StoreCostController openStoreCost(TransactionManager transactionManager, Transaction transaction) throws StandardException {
        B2ICostController b2ICostController = new B2ICostController();
        b2ICostController.init(transactionManager, this, transaction);
        return b2ICostController;
    }

    @Override
    public void drop(TransactionManager transactionManager) throws StandardException {
        ConglomerateController conglomerateController = null;
        conglomerateController = this.lockTable(transactionManager, 4, 7, 4);
        transactionManager.getRawStoreXact().dropContainer(this.id);
        if (conglomerateController != null) {
            conglomerateController.close();
        }
    }

    @Override
    public StaticCompiledOpenConglomInfo getStaticCompiledConglomInfo(TransactionController transactionController, long l2) throws StandardException {
        return new B2IStaticCompiledInfo(transactionController, this);
    }

    @Override
    public int getTypeFormatId() {
        return 470;
    }

    public void writeExternal_v10_2(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeLong(this.baseConglomerateId);
        objectOutput.writeInt(this.rowLocationColumn);
        FormatableBitSet formatableBitSet = new FormatableBitSet(this.ascDescInfo.length);
        for (int i2 = 0; i2 < this.ascDescInfo.length; ++i2) {
            if (!this.ascDescInfo[i2]) continue;
            formatableBitSet.set(i2);
        }
        formatableBitSet.writeExternal(objectOutput);
    }

    public void writeExternal_v10_3(ObjectOutput objectOutput) throws IOException {
        this.writeExternal_v10_2(objectOutput);
        if (this.conglom_format_id == 466 || this.conglom_format_id == 470) {
            ConglomerateUtil.writeCollationIdArray(this.collation_ids, objectOutput);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.writeExternal_v10_3(objectOutput);
        if (this.conglom_format_id == 470) {
            objectOutput.writeBoolean(this.isUniqueWithDuplicateNulls());
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n2;
        super.readExternal(objectInput);
        this.baseConglomerateId = objectInput.readLong();
        this.rowLocationColumn = objectInput.readInt();
        FormatableBitSet formatableBitSet = new FormatableBitSet();
        formatableBitSet.readExternal(objectInput);
        this.ascDescInfo = new boolean[formatableBitSet.getLength()];
        for (n2 = 0; n2 < formatableBitSet.getLength(); ++n2) {
            this.ascDescInfo[n2] = formatableBitSet.isSet(n2);
        }
        this.collation_ids = new int[this.format_ids.length];
        for (n2 = 0; n2 < this.format_ids.length; ++n2) {
            this.collation_ids[n2] = 0;
        }
        this.setUniqueWithDuplicateNulls(false);
        if (this.conglom_format_id == 466 || this.conglom_format_id == 470) {
            this.hasCollatedTypes = ConglomerateUtil.readCollationIdArray(this.collation_ids, objectInput);
        } else if (this.conglom_format_id != 388) {
            // empty if block
        }
        if (this.conglom_format_id == 470) {
            this.setUniqueWithDuplicateNulls(objectInput.readBoolean());
        }
    }
}

