/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.store.access.RAMTransaction;

final class RAMTransactionContext
extends ContextImpl {
    private RAMTransaction transaction;
    private final boolean abortAll;

    @Override
    public void cleanupOnError(Throwable throwable) throws StandardException {
        boolean bl2 = false;
        if (!this.abortAll && throwable instanceof StandardException) {
            StandardException standardException = (StandardException)throwable;
            if (standardException.getSeverity() < 30000) {
                return;
            }
            if (standardException.getSeverity() >= 40000) {
                bl2 = true;
            }
        } else {
            bl2 = true;
        }
        if (this.transaction != null) {
            try {
                this.transaction.invalidateConglomerateCache();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            this.transaction.closeControllers(true);
        }
        if (bl2) {
            this.transaction = null;
            this.popMe();
        }
    }

    RAMTransactionContext(ContextManager contextManager, String string, RAMTransaction rAMTransaction, boolean bl2) throws StandardException {
        super(contextManager, string);
        this.abortAll = bl2;
        this.transaction = rAMTransaction;
        this.transaction.setContext(this);
    }

    RAMTransaction getTransaction() {
        return this.transaction;
    }

    void setTransaction(RAMTransaction rAMTransaction) {
        this.transaction = rAMTransaction;
    }
}

