/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;

public class RealSetOpResultSetStatistics
extends RealNoPutResultSetStatistics {
    public int opType;
    public int rowsSeenLeft;
    public int rowsSeenRight;
    public int rowsReturned;
    public ResultSetStatistics leftResultSetStatistics;
    public ResultSetStatistics rightResultSetStatistics;

    public RealSetOpResultSetStatistics(int n2, int n3, int n4, int n5, long l2, long l3, long l4, long l5, int n6, int n7, int n8, int n9, double d2, double d3, ResultSetStatistics resultSetStatistics, ResultSetStatistics resultSetStatistics2) {
        super(n3, n4, n5, l2, l3, l4, l5, n6, d2, d3);
        this.opType = n2;
        this.rowsSeenLeft = n7;
        this.rowsSeenRight = n8;
        this.rowsReturned = n9;
        this.leftResultSetStatistics = resultSetStatistics;
        this.rightResultSetStatistics = resultSetStatistics2;
    }

    @Override
    public String getStatementExecutionPlanText(int n2) {
        this.initFormatInfo(n2);
        String string = this.opType == 1 ? "INTERSECT ResultSet" : "EXCEPT ResultSet";
        return this.indent + MessageService.getTextMessage(string, new Object[0]) + ":\n" + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X79.U", new Object[0]) + " = " + this.rowsSeenLeft + "\n" + this.indent + MessageService.getTextMessage("43X80.U", new Object[0]) + " = " + this.rowsSeenRight + "\n" + this.indent + MessageService.getTextMessage("43X81.U", new Object[0]) + " = " + this.rowsReturned + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage("43X82.U", new Object[0]) + ":\n" + this.leftResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n" + this.indent + MessageService.getTextMessage("43X83.U", new Object[0]) + ":\n" + this.rightResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    @Override
    public String getScanStatisticsText(String string, int n2) {
        return this.leftResultSetStatistics.getScanStatisticsText(string, n2) + this.rightResultSetStatistics.getScanStatisticsText(string, n2);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> vector = new Vector<ResultSetStatistics>();
        vector.addElement(this.leftResultSetStatistics);
        vector.addElement(this.rightResultSetStatistics);
        return vector;
    }

    @Override
    public String getNodeName() {
        String string = this.opType == 1 ? "INTERSECT" : "EXCEPT";
        return MessageService.getTextMessage(string, new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor xPLAINVisitor) {
        int n2 = 0;
        if (this.leftResultSetStatistics != null) {
            ++n2;
        }
        if (this.rightResultSetStatistics != null) {
            ++n2;
        }
        xPLAINVisitor.setNumberOfChildren(n2);
        xPLAINVisitor.visit(this);
        if (this.leftResultSetStatistics != null) {
            this.leftResultSetStatistics.accept(xPLAINVisitor);
        }
        if (this.rightResultSetStatistics != null) {
            this.rightResultSetStatistics.accept(xPLAINVisitor);
        }
    }

    @Override
    public String getRSXplainType() {
        return "SET";
    }

    @Override
    public String getRSXplainDetails() {
        String string = "(" + this.resultSetNumber + ")";
        string = string + (this.opType == 1 ? ", INTERSECT" : ", EXCEPT");
        return string;
    }

    @Override
    public Object getResultSetDescriptor(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return new XPLAINResultSetDescriptor((UUID)object, this.getRSXplainType(), this.getRSXplainDetails(), this.numOpens, null, null, null, (UUID)object2, this.optimizerEstimatedRowCount, this.optimizerEstimatedCost, null, null, null, this.rowsSeenLeft, this.rowsSeenRight, this.rowsFiltered, this.rowsReturned, null, null, (UUID)object3, (UUID)object4, (UUID)object5, (UUID)object6);
    }
}

