/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;

public class RealProjectRestrictStatistics
extends RealNoPutResultSetStatistics {
    public boolean doesProjection;
    public boolean restriction;
    public long restrictionTime;
    public long projectionTime;
    public ResultSetStatistics childResultSetStatistics;
    public ResultSetStatistics[] subqueryTrackingArray;

    public RealProjectRestrictStatistics(int n2, int n3, int n4, long l2, long l3, long l4, long l5, int n5, long l6, long l7, ResultSetStatistics[] resultSetStatisticsArray, boolean bl2, boolean bl3, double d2, double d3, ResultSetStatistics resultSetStatistics) {
        super(n2, n3, n4, l2, l3, l4, l5, n5, d2, d3);
        this.restriction = bl2;
        this.doesProjection = bl3;
        this.restrictionTime = l6;
        this.projectionTime = l7;
        this.subqueryTrackingArray = ArrayUtil.copy(resultSetStatisticsArray);
        this.childResultSetStatistics = resultSetStatistics;
    }

    @Override
    public String getStatementExecutionPlanText(int n2) {
        String string = "";
        this.initFormatInfo(n2);
        if (this.subqueryTrackingArray != null) {
            boolean bl2 = false;
            for (int i2 = 0; i2 < this.subqueryTrackingArray.length; ++i2) {
                if (this.subqueryTrackingArray[i2] == null) continue;
                if (!bl2) {
                    string = this.indent + MessageService.getTextMessage("43X56.U", new Object[0]) + ":\n";
                    bl2 = true;
                }
                string = string + this.subqueryTrackingArray[i2].getStatementExecutionPlanText(this.sourceDepth);
            }
        }
        return string + this.indent + MessageService.getTextMessage("43X93.U", new Object[0]) + " (" + this.resultSetNumber + "):" + "\n" + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X04.U", new Object[0]) + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X32.U", new Object[0]) + " = " + this.rowsFiltered + "\n" + this.indent + MessageService.getTextMessage("43X94.U", new Object[0]) + " = " + this.restriction + "\n" + this.indent + MessageService.getTextMessage("43X95.U", new Object[0]) + " = " + this.doesProjection + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.subIndent + MessageService.getTextMessage("43X96.U", new Object[0]) + " = " + this.restrictionTime + "\n" + this.subIndent + MessageService.getTextMessage("43X97.U", new Object[0]) + " = " + this.projectionTime + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage("43X05.U", new Object[0]) + ":" + "\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth);
    }

    @Override
    public String getScanStatisticsText(String string, int n2) {
        String string2 = "";
        if (this.subqueryTrackingArray != null) {
            for (int i2 = 0; i2 < this.subqueryTrackingArray.length; ++i2) {
                if (this.subqueryTrackingArray[i2] == null) continue;
                string2 = string2 + "\n" + MessageService.getTextMessage("43X01.U", new Object[0]) + " " + i2 + "\n" + this.subqueryTrackingArray[i2].getScanStatisticsText(string, n2) + MessageService.getTextMessage("43X06.U", new Object[0]) + " " + i2 + "\n\n";
            }
        }
        return string2 + this.childResultSetStatistics.getScanStatisticsText(string, n2);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> vector = new Vector<ResultSetStatistics>();
        vector.addElement(this.childResultSetStatistics);
        if (this.subqueryTrackingArray != null) {
            for (int i2 = 0; i2 < this.subqueryTrackingArray.length; ++i2) {
                if (this.subqueryTrackingArray[i2] == null) continue;
                vector.addElement(this.subqueryTrackingArray[i2]);
            }
        }
        return vector;
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43X98.U", new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor xPLAINVisitor) {
        int n2 = 0;
        if (this.childResultSetStatistics != null) {
            ++n2;
        }
        if (this.subqueryTrackingArray != null) {
            n2 += this.subqueryTrackingArray.length;
        }
        xPLAINVisitor.setNumberOfChildren(n2);
        xPLAINVisitor.visit(this);
        if (this.childResultSetStatistics != null) {
            this.childResultSetStatistics.accept(xPLAINVisitor);
        }
        if (this.subqueryTrackingArray != null) {
            boolean bl2 = false;
            for (int i2 = 0; i2 < this.subqueryTrackingArray.length; ++i2) {
                if (this.subqueryTrackingArray[i2] == null) continue;
                this.subqueryTrackingArray[i2].accept(xPLAINVisitor);
            }
        }
    }

    @Override
    public String getRSXplainType() {
        if (this.restriction && this.doesProjection) {
            return "PROJECT-FILTER";
        }
        if (this.doesProjection) {
            return "PROJECTION";
        }
        if (this.restriction) {
            return "FILTER";
        }
        return "PROJECT-FILTER";
    }

    @Override
    public String getRSXplainDetails() {
        return this.resultSetNumber + ";";
    }

    @Override
    public Object getResultSetTimingsDescriptor(Object object) {
        return new XPLAINResultSetTimingsDescriptor((UUID)object, this.constructorTime, this.openTime, this.nextTime, this.closeTime, this.getNodeTime(), XPLAINUtil.getAVGNextTime(this.nextTime, this.rowsSeen), this.projectionTime, this.restrictionTime, null, null);
    }
}

