/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;

public class RealHashScanStatistics
extends RealNoPutResultSetStatistics {
    public boolean isConstraint;
    public int hashtableSize;
    public int[] hashKeyColumns;
    public String isolationLevel;
    public String lockString;
    public String tableName;
    public String indexName;
    public String nextQualifiers;
    public String scanQualifiers;
    public String startPosition = null;
    public String stopPosition = null;
    public FormatableProperties scanProperties;

    public RealHashScanStatistics(int n2, int n3, int n4, long l2, long l3, long l4, long l5, int n5, String string, String string2, boolean bl2, int n6, int[] nArray, String string3, String string4, Properties properties, String string5, String string6, String string7, String string8, double d2, double d3) {
        super(n2, n3, n4, l2, l3, l4, l5, n5, d2, d3);
        this.tableName = string;
        this.indexName = string2;
        this.isConstraint = bl2;
        this.hashtableSize = n6;
        this.hashKeyColumns = ArrayUtil.copy(nArray);
        this.scanQualifiers = string3;
        this.nextQualifiers = string4;
        this.scanProperties = new FormatableProperties();
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string9 = (String)enumeration.nextElement();
                this.scanProperties.put(string9, properties.get(string9));
            }
        }
        this.startPosition = string5;
        this.stopPosition = string6;
        this.isolationLevel = string7;
        this.lockString = string8;
    }

    @Override
    public String getStatementExecutionPlanText(int n2) {
        String string;
        Object var3_2 = null;
        this.initFormatInfo(n2);
        String string2 = this.indexName != null ? this.indent + MessageService.getTextMessage("43X51.U", this.tableName, this.isConstraint ? "constraint" : "index", this.indexName) : this.indent + MessageService.getTextMessage("43X52.U", this.tableName);
        string2 = string2 + " " + MessageService.getTextMessage("43X27.U", this.isolationLevel, this.lockString) + ": \n";
        String string3 = this.indent + MessageService.getTextMessage("43X28.U", new Object[0]) + ": \n" + PropertyUtil.sortProperties(this.scanProperties, this.subIndent);
        if (this.hashKeyColumns.length == 1) {
            string = MessageService.getTextMessage("43X53.U", new Object[0]) + " " + this.hashKeyColumns[0];
        } else {
            string = MessageService.getTextMessage("43X54.U", new Object[0]) + " (" + this.hashKeyColumns[0];
            for (int i2 = 1; i2 < this.hashKeyColumns.length; ++i2) {
                string = string + "," + this.hashKeyColumns[i2];
            }
            string = string + ")";
        }
        return string2 + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X31.U", new Object[0]) + " = " + this.hashtableSize + "\n" + this.indent + string + "\n" + this.indent + MessageService.getTextMessage("43X04.U", new Object[0]) + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X32.U", new Object[0]) + " = " + this.rowsFiltered + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + (this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage("43X33.U", new Object[0]) + " = " + this.nextTime / (long)this.rowsSeen + "\n" : "") + "\n" + string3 + this.subIndent + MessageService.getTextMessage("43X34.U", new Object[0]) + ":\n" + StringUtil.ensureIndent(this.startPosition, n2 + 2) + "\n" + this.subIndent + MessageService.getTextMessage("43X35.U", new Object[0]) + ":\n" + StringUtil.ensureIndent(this.stopPosition, n2 + 2) + "\n" + this.subIndent + MessageService.getTextMessage("43X36.U", new Object[0]) + ":\n" + StringUtil.ensureIndent(this.scanQualifiers, n2 + 2) + "\n" + this.subIndent + MessageService.getTextMessage("43X37.U", new Object[0]) + ":\n" + StringUtil.ensureIndent(this.nextQualifiers, n2 + 2) + "\n" + this.dumpEstimatedCosts(this.subIndent);
    }

    @Override
    public String getScanStatisticsText(String string, int n2) {
        if (string == null || string.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(n2);
        }
        return "";
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public String getNodeOn() {
        return MessageService.getTextMessage("43X38.U", this.tableName, this.indexName);
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43X55.U", new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor xPLAINVisitor) {
        xPLAINVisitor.setNumberOfChildren(0);
        xPLAINVisitor.visit(this);
    }

    @Override
    public String getRSXplainType() {
        return "HASHSCAN";
    }

    @Override
    public String getRSXplainDetails() {
        if (this.indexName != null) {
            return (this.isConstraint ? "C: " : "I: ") + this.indexName;
        }
        return "T: " + this.tableName;
    }

    @Override
    public Object getScanPropsDescriptor(Object object) {
        String string;
        String string2;
        if (this.indexName != null) {
            if (this.isConstraint) {
                string2 = "C";
                string = this.indexName;
            } else {
                string2 = "I";
                string = this.indexName;
            }
        } else {
            string2 = "T";
            string = this.tableName;
        }
        String string3 = XPLAINUtil.getIsolationLevelCode(this.isolationLevel);
        String string4 = XPLAINUtil.getHashKeyColumnNumberString(this.hashKeyColumns);
        XPLAINScanPropsDescriptor xPLAINScanPropsDescriptor = new XPLAINScanPropsDescriptor((UUID)object, string, string2, null, string3, null, null, null, null, null, null, null, null, this.startPosition, this.stopPosition, this.scanQualifiers, this.nextQualifiers, string4, this.hashtableSize);
        FormatableProperties formatableProperties = this.scanProperties;
        return XPLAINUtil.extractScanProps(xPLAINScanPropsDescriptor, formatableProperties);
    }

    @Override
    public Object getResultSetDescriptor(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string = XPLAINUtil.getLockModeCode(this.lockString);
        String string2 = XPLAINUtil.getLockGranularityCode(this.lockString);
        return new XPLAINResultSetDescriptor((UUID)object, this.getRSXplainType(), this.getRSXplainDetails(), this.numOpens, null, string, string2, (UUID)object2, this.optimizerEstimatedRowCount, this.optimizerEstimatedCost, null, null, null, this.rowsSeen, null, this.rowsFiltered, this.rowsSeen - this.rowsFiltered, null, null, (UUID)object3, (UUID)object4, (UUID)object5, (UUID)object6);
    }
}

