/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.DataValueDescriptor;

class ValueRow
implements ExecRow {
    private DataValueDescriptor[] column;
    private int ncols;

    public ValueRow(int n2) {
        this.column = new DataValueDescriptor[n2];
        this.ncols = n2;
    }

    @Override
    public int nColumns() {
        return this.ncols;
    }

    @Override
    public void getNewObjectArray() {
        this.column = new DataValueDescriptor[this.ncols];
    }

    @Override
    public DataValueDescriptor getColumn(int n2) {
        if (n2 <= this.column.length) {
            return this.column[n2 - 1];
        }
        return null;
    }

    @Override
    public void setColumn(int n2, DataValueDescriptor dataValueDescriptor) {
        if (n2 > this.column.length) {
            this.realloc(n2);
        }
        this.column[n2 - 1] = dataValueDescriptor;
    }

    @Override
    public ExecRow getClone() {
        return this.getClone(null);
    }

    @Override
    public ExecRow getClone(FormatableBitSet formatableBitSet) {
        int n2 = this.column.length;
        ExecRow execRow = this.cloneMe();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (formatableBitSet != null && !formatableBitSet.get(i2 + 1)) {
                execRow.setColumn(i2 + 1, this.column[i2]);
                continue;
            }
            if (this.column[i2] == null) continue;
            execRow.setColumn(i2 + 1, this.column[i2].cloneValue(false));
        }
        return execRow;
    }

    @Override
    public ExecRow getNewNullRow() {
        int n2 = this.column.length;
        ExecRow execRow = this.cloneMe();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.column[i2] == null) continue;
            execRow.setColumn(i2 + 1, this.column[i2].getNewNull());
        }
        return execRow;
    }

    ExecRow cloneMe() {
        return new ValueRow(this.ncols);
    }

    @Override
    public void resetRowArray() {
        for (int i2 = 0; i2 < this.column.length; ++i2) {
            if (this.column[i2] == null) continue;
            this.column[i2] = this.column[i2].recycle();
        }
    }

    @Override
    public final DataValueDescriptor cloneColumn(int n2) {
        return this.column[n2 - 1].cloneValue(false);
    }

    public String toString() {
        String string = "{ ";
        for (int i2 = 0; i2 < this.column.length; ++i2) {
            string = this.column[i2] == null ? string + "null" : string + this.column[i2].toString();
            if (i2 >= this.column.length - 1) continue;
            string = string + ", ";
        }
        string = string + " }";
        return string;
    }

    @Override
    public DataValueDescriptor[] getRowArray() {
        return this.column;
    }

    @Override
    public DataValueDescriptor[] getRowArrayClone() {
        int n2 = this.column.length;
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.column[i2] == null) continue;
            dataValueDescriptorArray[i2] = this.column[i2].cloneValue(false);
        }
        return dataValueDescriptorArray;
    }

    @Override
    public void setRowArray(DataValueDescriptor[] dataValueDescriptorArray) {
        this.column = dataValueDescriptorArray;
    }

    protected void realloc(int n2) {
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[n2];
        System.arraycopy(this.column, 0, dataValueDescriptorArray, 0, this.column.length);
        this.column = dataValueDescriptorArray;
    }
}

