/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.ResultSet;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.DMLVTIResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;

class UpdateVTIResultSet
extends DMLVTIResultSet {
    private ResultSet rs;
    private TemporaryRowHolderImpl rowHolder;

    public UpdateVTIResultSet(NoPutResultSet noPutResultSet, Activation activation) throws StandardException {
        super(noPutResultSet, activation);
    }

    @Override
    protected void openCore() throws StandardException {
        Object object;
        int n2 = -1;
        boolean bl2 = true;
        this.rs = this.activation.getTargetVTI();
        ExecRow execRow = this.getNextRowCore(this.sourceResultSet);
        if (null != execRow) {
            n2 = execRow.nColumns();
        }
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (null == this.rowHolder && this.constants.deferred) {
            object = new Properties();
            this.rowHolder = new TemporaryRowHolderImpl(this.activation, (Properties)object, this.resultDescription);
        }
        try {
            while (execRow != null) {
                if (this.constants.deferred) {
                    if (bl2) {
                        execRow.getColumn(n2).setValue(this.rs.getRow());
                        bl2 = false;
                    } else {
                        object = execRow.cloneColumn(n2);
                        object.setValue(this.rs.getRow());
                        execRow.setColumn(n2, (DataValueDescriptor)object);
                    }
                    this.rowHolder.insert(execRow);
                } else {
                    this.updateVTI(this.rs, execRow);
                }
                ++this.rowCount;
                if (this.constants.singleRowSource) {
                    execRow = null;
                    continue;
                }
                execRow = this.getNextRowCore(this.sourceResultSet);
            }
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
        if (this.constants.deferred) {
            object = this.rowHolder.getResultSet();
            try {
                object.open();
                while ((execRow = object.getNextRow()) != null) {
                    int n3 = execRow.getColumn(n2).getInt();
                    this.rs.absolute(n3);
                    this.updateVTI(this.rs, execRow);
                }
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
            finally {
                this.sourceResultSet.clearCurrentRow();
                object.close();
            }
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
    }

    @Override
    public void close() throws StandardException {
        this.close(false);
    }

    private void updateVTI(ResultSet resultSet, ExecRow execRow) throws StandardException {
        int[] nArray = this.constants.changedColumnIds;
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n2 = nArray[i2];
                DataValueDescriptor dataValueDescriptor = execRow.getColumn(i2 + 1);
                if (dataValueDescriptor.isNull()) {
                    resultSet.updateNull(n2);
                    continue;
                }
                dataValueDescriptor.setInto(resultSet, n2);
            }
            resultSet.updateRow();
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
    }
}

