/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.WriteCursorConstantAction;

public class UpdateConstantAction
extends WriteCursorConstantAction {
    int[] changedColumnIds;
    private boolean positionedUpdate;
    int numColumns;
    private String schemaName;
    private String tableName;
    private String[] columnNames;
    String identitySequenceUUIDString;
    RowLocation[] autoincRowLocation;
    private long[] autoincIncrement;

    public UpdateConstantAction() {
    }

    UpdateConstantAction(TableDescriptor tableDescriptor, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, IndexRowGenerator[] indexRowGeneratorArray, long[] lArray, StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray, String[] stringArray, boolean bl2, UUID uUID, int n2, int[] nArray, FKInfo[] fKInfoArray, TriggerInfo triggerInfo, FormatableBitSet formatableBitSet, int[] nArray2, int[] nArray3, int n3, boolean bl3, boolean bl4, RowLocation[] rowLocationArray, boolean bl5, String string) throws StandardException {
        super(tableDescriptor.getHeapConglomerateId(), staticCompiledOpenConglomInfo, indexRowGeneratorArray, lArray, staticCompiledOpenConglomInfoArray, stringArray, bl2, null, uUID, n2, fKInfoArray, triggerInfo, formatableBitSet, nArray2, nArray3, bl4, bl5);
        this.changedColumnIds = nArray;
        this.positionedUpdate = bl3;
        this.numColumns = n3;
        this.schemaName = tableDescriptor.getSchemaName();
        this.tableName = tableDescriptor.getName();
        this.columnNames = tableDescriptor.getColumnNamesArray();
        this.autoincIncrement = tableDescriptor.getAutoincIncrementArray();
        this.identitySequenceUUIDString = string;
        this.autoincRowLocation = rowLocationArray;
    }

    public boolean hasAutoincrement() {
        return this.autoincRowLocation != null;
    }

    RowLocation[] getAutoincRowLocation() {
        return this.autoincRowLocation;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.changedColumnIds = ArrayUtil.readIntArray(objectInput);
        this.positionedUpdate = objectInput.readBoolean();
        this.numColumns = objectInput.readInt();
        this.autoincIncrement = ArrayUtil.readLongArray(objectInput);
        this.identitySequenceUUIDString = (String)objectInput.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        ArrayUtil.writeIntArray(objectOutput, this.changedColumnIds);
        objectOutput.writeBoolean(this.positionedUpdate);
        objectOutput.writeInt(this.numColumns);
        ArrayUtil.writeLongArray(objectOutput, this.autoincIncrement);
        objectOutput.writeObject(this.identitySequenceUUIDString);
    }

    @Override
    public int getTypeFormatId() {
        return 39;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName(int n2) {
        return this.columnNames[n2];
    }

    String[] getColumnNames() {
        return this.columnNames;
    }

    public long getAutoincIncrement(int n2) {
        return this.autoincIncrement[n2];
    }
}

