/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;

public class UniqueWithDuplicateNullsIndexSortObserver
extends BasicSortObserver {
    private final String indexOrConstraintName;
    private final String tableName;
    private final boolean deferrable;
    private final boolean deferred;
    private final LanguageConnectionContext lcc;
    private final UUID constraintId;
    private BackingStoreHashtable deferredDuplicates;

    public UniqueWithDuplicateNullsIndexSortObserver(LanguageConnectionContext languageConnectionContext, UUID uUID, boolean bl2, boolean bl3, boolean bl4, String string, ExecRow execRow, boolean bl5, String string2) {
        super(bl2, false, execRow, bl5);
        this.lcc = languageConnectionContext;
        this.constraintId = uUID;
        this.deferrable = bl3;
        this.deferred = bl4;
        this.indexOrConstraintName = string;
        this.tableName = string2;
    }

    @Override
    public DataValueDescriptor[] insertDuplicateKey(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2) throws StandardException {
        for (int i2 = 0; i2 < dataValueDescriptorArray.length; ++i2) {
            if (!dataValueDescriptorArray[i2].isNull()) continue;
            return super.insertDuplicateKey(dataValueDescriptorArray, dataValueDescriptorArray2);
        }
        StandardException standardException = null;
        standardException = StandardException.newException("23505", this.indexOrConstraintName, this.tableName);
        throw standardException;
    }

    @Override
    public boolean deferred() {
        return this.deferred;
    }

    @Override
    public boolean deferrable() {
        return this.deferrable;
    }

    @Override
    public void rememberDuplicate(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        this.deferredDuplicates = DeferredConstraintsMemory.rememberDuplicate(this.lcc, this.deferredDuplicates, this.constraintId, dataValueDescriptorArray);
    }
}

