/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.TargetResultSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.sql.execute.BasicNoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.w3c.dom.Element;

class TemporaryRowHolderResultSet
implements Cloneable,
CursorResultSet,
NoPutResultSet {
    private ExecRow[] rowArray;
    private int numRowsOut;
    private ScanController scan;
    private TransactionController tc;
    private boolean isOpen;
    private boolean finished;
    private ExecRow currentRow;
    private ResultDescription resultDescription;
    private boolean isAppendable = false;
    private long positionIndexConglomId;
    private boolean isVirtualMemHeap;
    private boolean currRowFromMem;
    private TemporaryRowHolderImpl holder;
    ConglomerateController heapCC;
    private RowLocation baseRowLocation;
    DataValueDescriptor[] indexRow;
    ScanController indexsc;

    public TemporaryRowHolderResultSet(TransactionController transactionController, ExecRow[] execRowArray, ResultDescription resultDescription, boolean bl2, TemporaryRowHolderImpl temporaryRowHolderImpl) {
        this(transactionController, execRowArray, resultDescription, bl2, false, 0L, temporaryRowHolderImpl);
    }

    public TemporaryRowHolderResultSet(TransactionController transactionController, ExecRow[] execRowArray, ResultDescription resultDescription, boolean bl2, boolean bl3, long l2, TemporaryRowHolderImpl temporaryRowHolderImpl) {
        this.tc = transactionController;
        this.rowArray = execRowArray;
        this.resultDescription = resultDescription;
        this.numRowsOut = 0;
        this.isOpen = false;
        this.finished = false;
        this.isVirtualMemHeap = bl2;
        this.isAppendable = bl3;
        this.positionIndexConglomId = l2;
        this.holder = temporaryRowHolderImpl;
    }

    public void reset(ExecRow[] execRowArray) {
        this.rowArray = execRowArray;
        this.numRowsOut = 0;
        this.isOpen = false;
        this.finished = false;
    }

    public void reStartScan(long l2, long l3) throws StandardException {
        if (this.isAppendable) {
            this.positionIndexConglomId = l3;
            this.setupPositionBasedScan(this.numRowsOut);
        } else {
            --this.numRowsOut;
        }
    }

    private static int[] supersetofAllColumns(int[] nArray, int[] nArray2) {
        int n2;
        int n3 = nArray.length + nArray2.length;
        int[] nArray3 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray3[n2] = -1;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray3[n2] = nArray[n2];
        }
        n2 = nArray.length;
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            boolean bl2 = false;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (nArray3[i3] != nArray2[i2]) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            nArray3[n2] = nArray2[i2];
            ++n2;
        }
        nArray3 = TemporaryRowHolderResultSet.shrinkArray(nArray3);
        Arrays.sort(nArray3);
        return nArray3;
    }

    private static int[] shrinkArray(int[] nArray) {
        int n2 = 0;
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] == -1) continue;
            ++n2;
        }
        if (n2 > 0) {
            int[] nArray2 = new int[n2];
            int n4 = 0;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (nArray[i3] == -1) continue;
                nArray2[n4++] = nArray[i3];
            }
            return nArray2;
        }
        return null;
    }

    private static int[] justTheRequiredColumnsPositions(int[] nArray) {
        int n2 = 0;
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] == -1) continue;
            ++n2;
        }
        if (n2 > 0) {
            int[] nArray2 = new int[n2];
            int n4 = 0;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (nArray[i3] == -1) continue;
                nArray2[n4++] = i3 + 1;
            }
            return nArray2;
        }
        return null;
    }

    public static TemporaryRowHolderResultSet getNewRSOnCurrentRow(TriggerDescriptor triggerDescriptor, Activation activation, CursorResultSet cursorResultSet, int[] nArray) throws StandardException {
        TemporaryRowHolderImpl temporaryRowHolderImpl;
        DataDictionary dataDictionary = activation.getLanguageConnectionContext().getDataDictionary();
        if (!dataDictionary.checkVersion(210, null)) {
            TemporaryRowHolderImpl temporaryRowHolderImpl2 = new TemporaryRowHolderImpl(activation, null, cursorResultSet.getResultDescription());
            temporaryRowHolderImpl2.insert(cursorResultSet.getCurrentRow());
            return (TemporaryRowHolderResultSet)temporaryRowHolderImpl2.getResultSet();
        }
        int[] nArray2 = triggerDescriptor.getReferencedColsInTriggerAction();
        int[] nArray3 = triggerDescriptor.getReferencedCols();
        if (nArray3 != null && triggerDescriptor.isRowTrigger() && nArray2 != null && nArray2.length != 0) {
            int n2;
            int n3;
            int[] nArray4;
            int[] nArray5 = TemporaryRowHolderResultSet.supersetofAllColumns(nArray3, nArray2);
            int n4 = nArray5.length;
            int[] nArray6 = new int[n4];
            if (nArray != null) {
                nArray4 = TemporaryRowHolderResultSet.justTheRequiredColumnsPositions(nArray);
            } else {
                n3 = triggerDescriptor.getTableDescriptor().getNumberOfColumns();
                nArray4 = new int[n3];
                for (n2 = 1; n2 <= n3; ++n2) {
                    nArray4[n2 - 1] = n2;
                }
            }
            n3 = 0;
            block1: for (n2 = 0; n2 < n4; ++n2) {
                while (n3 < nArray4.length) {
                    if (nArray4[n3] == nArray5[n2]) {
                        nArray6[n2] = n3 + 1;
                        continue block1;
                    }
                    ++n3;
                }
            }
            temporaryRowHolderImpl = new TemporaryRowHolderImpl(activation, null, activation.getLanguageConnectionContext().getLanguageFactory().getResultDescription(cursorResultSet.getResultDescription(), nArray6));
            ExecRow execRow = activation.getExecutionFactory().getValueRow(n4);
            for (int i2 = 0; i2 < n4; ++i2) {
                execRow.setColumn(i2 + 1, cursorResultSet.getCurrentRow().getColumn(nArray6[i2]));
            }
            temporaryRowHolderImpl.insert(execRow);
        } else {
            temporaryRowHolderImpl = new TemporaryRowHolderImpl(activation, null, cursorResultSet.getResultDescription());
            temporaryRowHolderImpl.insert(cursorResultSet.getCurrentRow());
        }
        return (TemporaryRowHolderResultSet)temporaryRowHolderImpl.getResultSet();
    }

    @Override
    public void markAsTopResultSet() {
    }

    @Override
    public void openCore() throws StandardException {
        this.numRowsOut = 0;
        this.isOpen = true;
        this.currentRow = null;
        if (this.isAppendable) {
            this.setupPositionBasedScan(this.numRowsOut);
        }
    }

    @Override
    public void reopenCore() throws StandardException {
        this.numRowsOut = 0;
        this.isOpen = true;
        this.currentRow = null;
        if (this.isAppendable) {
            this.setupPositionBasedScan(this.numRowsOut);
            return;
        }
        if (this.scan != null) {
            this.scan.reopenScan(null, 0, null, null, 0);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        if (this.isAppendable) {
            return this.getNextAppendedRow();
        }
        if (this.isVirtualMemHeap && this.holder.lastArraySlot >= 0) {
            ++this.numRowsOut;
            this.currentRow = this.rowArray[this.holder.lastArraySlot];
            this.currRowFromMem = true;
            return this.currentRow;
        }
        if (this.numRowsOut++ <= this.holder.lastArraySlot) {
            this.currentRow = this.rowArray[this.numRowsOut - 1];
            return this.currentRow;
        }
        if (this.holder.getTemporaryConglomId() == 0L) {
            return null;
        }
        if (this.scan == null) {
            this.scan = this.tc.openScan(this.holder.getTemporaryConglomId(), false, 0, 7, 5, null, null, 0, null, null, 0);
        } else if (this.isVirtualMemHeap && this.holder.state == 1) {
            this.holder.state = 2;
            this.scan.reopenScan(null, 0, null, null, 0);
        }
        if (this.scan.next()) {
            this.currentRow = this.rowArray[0].getNewNullRow();
            this.scan.fetch(this.currentRow.getRowArray());
            this.currRowFromMem = false;
            return this.currentRow;
        }
        return null;
    }

    public void deleteCurrentRow() throws StandardException {
        if (this.currRowFromMem) {
            if (this.holder.lastArraySlot > 0) {
                this.rowArray[this.holder.lastArraySlot] = null;
            }
            --this.holder.lastArraySlot;
        } else {
            if (this.baseRowLocation == null) {
                this.baseRowLocation = this.scan.newRowLocationTemplate();
            }
            this.scan.fetchLocation(this.baseRowLocation);
            if (this.heapCC == null) {
                this.heapCC = this.tc.openConglomerate(this.holder.getTemporaryConglomId(), false, 4, 7, 5);
            }
            this.heapCC.delete(this.baseRowLocation);
        }
    }

    private void setupPositionBasedScan(long l2) throws StandardException {
        if (this.holder.getTemporaryConglomId() == 0L) {
            return;
        }
        if (this.heapCC == null) {
            this.heapCC = this.tc.openConglomerate(this.holder.getTemporaryConglomId(), false, 0, 7, 5);
        }
        this.currentRow = this.rowArray[0].getNewNullRow();
        this.indexRow = new DataValueDescriptor[2];
        this.indexRow[0] = new SQLLongint(l2);
        this.indexRow[1] = this.heapCC.newRowLocationTemplate();
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[]{new SQLLongint(l2)};
        if (this.indexsc == null) {
            this.indexsc = this.tc.openScan(this.positionIndexConglomId, false, 0, 7, 5, null, dataValueDescriptorArray, 1, null, null, -1);
        } else {
            this.indexsc.reopenScan(dataValueDescriptorArray, 1, null, null, -1);
        }
    }

    private ExecRow getNextAppendedRow() throws StandardException {
        if (this.indexsc == null) {
            return null;
        }
        if (!this.indexsc.fetchNext(this.indexRow)) {
            return null;
        }
        RowLocation rowLocation = (RowLocation)this.indexRow[1];
        boolean bl2 = this.heapCC.fetch(rowLocation, this.currentRow.getRowArray(), null);
        ++this.numRowsOut;
        return this.currentRow;
    }

    @Override
    public int getPointOfAttachment() {
        return -1;
    }

    @Override
    public int getScanIsolationLevel() {
        return 5;
    }

    @Override
    public void setTargetResultSet(TargetResultSet targetResultSet) {
    }

    @Override
    public void setNeedsRowLocation(boolean bl2) {
    }

    @Override
    public double getEstimatedRowCount() {
        return 0.0;
    }

    @Override
    public int resultSetNumber() {
        return 0;
    }

    @Override
    public void setCurrentRow(ExecRow execRow) {
        this.currentRow = execRow;
    }

    @Override
    public void clearCurrentRow() {
        this.currentRow = null;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }

    @Override
    public RowLocation getRowLocation() {
        return null;
    }

    @Override
    public void close() throws StandardException {
        this.isOpen = false;
        this.numRowsOut = 0;
        this.currentRow = null;
        if (this.scan != null) {
            this.scan.close();
            this.scan = null;
        }
    }

    @Override
    public boolean returnsRows() {
        return true;
    }

    @Override
    public long modifiedRowCount() {
        return 0L;
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    @Override
    public void open() throws StandardException {
        this.openCore();
    }

    @Override
    public ExecRow getAbsoluteRow(int n2) throws StandardException {
        return null;
    }

    @Override
    public ExecRow getRelativeRow(int n2) throws StandardException {
        return null;
    }

    @Override
    public ExecRow setBeforeFirstRow() throws StandardException {
        return null;
    }

    @Override
    public ExecRow getFirstRow() throws StandardException {
        return null;
    }

    @Override
    public ExecRow getNextRow() throws StandardException {
        return this.getNextRowCore();
    }

    @Override
    public ExecRow getPreviousRow() throws StandardException {
        return null;
    }

    @Override
    public ExecRow getLastRow() throws StandardException {
        return null;
    }

    @Override
    public ExecRow setAfterLastRow() throws StandardException {
        return null;
    }

    @Override
    public boolean checkRowPosition(int n2) {
        return false;
    }

    @Override
    public int getRowNumber() {
        return 0;
    }

    @Override
    public void cleanUp() throws StandardException {
        this.close();
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public void finish() throws StandardException {
        this.finished = true;
        this.close();
    }

    @Override
    public long getExecuteTime() {
        return 0L;
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    @Override
    public Timestamp getBeginExecutionTimestamp() {
        return null;
    }

    @Override
    public Timestamp getEndExecutionTimestamp() {
        return null;
    }

    @Override
    public long getTimeSpent(int n2) {
        return 0L;
    }

    @Override
    public NoPutResultSet[] getSubqueryTrackingArray(int n2) {
        return null;
    }

    @Override
    public String getCursorName() {
        return null;
    }

    @Override
    public boolean requiresRelocking() {
        return false;
    }

    @Override
    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        return null;
    }

    @Override
    public boolean needsToClone() {
        return false;
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return null;
    }

    @Override
    public void closeRowSource() {
    }

    @Override
    public boolean needsRowLocation() {
        return false;
    }

    @Override
    public void setHasDeferrableChecks() {
    }

    @Override
    public boolean needsRowLocationForDeferredCheckConstraints() {
        return false;
    }

    @Override
    public void rowLocation(RowLocation rowLocation) throws StandardException {
    }

    @Override
    public void offendingRowLocation(RowLocation rowLocation, long l2) throws StandardException {
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rowLocation) throws StandardException {
    }

    @Override
    public boolean isForUpdate() {
        return false;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    @Override
    public void addWarning(SQLWarning sQLWarning) {
        this.getActivation().addWarning(sQLWarning);
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void updateRow(ExecRow execRow, RowChanger rowChanger) throws StandardException {
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
    }

    @Override
    public final Activation getActivation() {
        return this.holder.activation;
    }

    @Override
    public Element toXML(Element element, String string) throws Exception {
        return BasicNoPutResultSetImpl.childrenToXML(BasicNoPutResultSetImpl.toXML(element, string, this), this);
    }
}

