/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLRef;
import org.apache.derby.impl.sql.execute.IndexValueRow;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;

class TemporaryRowHolderImpl
implements TemporaryRowHolder {
    public static final int DEFAULT_OVERFLOWTHRESHOLD = 5;
    protected static final int STATE_UNINIT = 0;
    protected static final int STATE_INSERT = 1;
    protected static final int STATE_DRAIN = 2;
    protected ExecRow[] rowArray;
    protected int lastArraySlot;
    private int numRowsIn;
    protected int state = 0;
    private long CID;
    private boolean conglomCreated;
    private ConglomerateController cc;
    private Properties properties;
    private ScanController scan;
    private ResultDescription resultDescription;
    Activation activation;
    private boolean isUniqueStream;
    private boolean isVirtualMemHeap;
    private boolean uniqueIndexCreated;
    private boolean positionIndexCreated;
    private long uniqueIndexConglomId;
    private long positionIndexConglomId;
    private ConglomerateController uniqueIndex_cc;
    private ConglomerateController positionIndex_cc;
    private DataValueDescriptor[] uniqueIndexRow = null;
    private DataValueDescriptor[] positionIndexRow = null;
    private RowLocation destRowLocation;
    private SQLLongint position_sqllong;

    public TemporaryRowHolderImpl(Activation activation, Properties properties, ResultDescription resultDescription) {
        this(activation, properties, resultDescription, 5, false, false);
    }

    public TemporaryRowHolderImpl(Activation activation, Properties properties, ResultDescription resultDescription, boolean bl2) {
        this(activation, properties, resultDescription, 1, bl2, false);
    }

    public TemporaryRowHolderImpl(Activation activation, Properties properties, ResultDescription resultDescription, int n2, boolean bl2, boolean bl3) {
        this.activation = activation;
        this.properties = properties;
        this.resultDescription = resultDescription;
        this.isUniqueStream = bl2;
        this.isVirtualMemHeap = bl3;
        this.rowArray = new ExecRow[n2];
        this.lastArraySlot = -1;
    }

    private ExecRow cloneRow(ExecRow execRow) {
        DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
        int n2 = dataValueDescriptorArray.length;
        ExecRow execRow2 = ((ValueRow)execRow).cloneMe();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (dataValueDescriptorArray[i2] == null) continue;
            execRow2.setColumn(i2 + 1, dataValueDescriptorArray[i2].cloneHolder());
        }
        if (execRow instanceof IndexValueRow) {
            return new IndexValueRow(execRow2);
        }
        return execRow2;
    }

    @Override
    public void insert(ExecRow execRow) throws StandardException {
        if (!this.isVirtualMemHeap) {
            this.state = 1;
        }
        if (this.uniqueIndexCreated && this.isRowAlreadyExist(execRow)) {
            return;
        }
        ++this.numRowsIn;
        if (this.lastArraySlot + 1 < this.rowArray.length) {
            this.rowArray[++this.lastArraySlot] = this.cloneRow(execRow);
            if (!this.isUniqueStream) {
                return;
            }
        }
        if (!this.conglomCreated) {
            TransactionController transactionController = this.activation.getTransactionController();
            int[] nArray = null;
            this.CID = transactionController.createConglomerate("heap", execRow.getRowArray(), null, nArray, this.properties, 3);
            this.conglomCreated = true;
            this.cc = transactionController.openConglomerate(this.CID, false, 4, 7, 5);
            if (this.isUniqueStream) {
                this.destRowLocation = this.cc.newRowLocationTemplate();
            }
        }
        int n2 = 0;
        if (this.isUniqueStream) {
            this.cc.insertAndFetchLocation(execRow.getRowArray(), this.destRowLocation);
            this.insertToPositionIndex(this.numRowsIn - 1, this.destRowLocation);
            if (!this.uniqueIndexCreated) {
                this.isRowAlreadyExist(execRow);
            }
        } else {
            n2 = this.cc.insert(execRow.getRowArray());
            if (this.isVirtualMemHeap) {
                this.state = 1;
            }
        }
    }

    private boolean isRowAlreadyExist(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(execRow.nColumns());
        if (this.CID != 0L && dataValueDescriptor instanceof SQLRef) {
            RowLocation rowLocation = (RowLocation)dataValueDescriptor.getObject();
            if (!this.uniqueIndexCreated) {
                TransactionController transactionController = this.activation.getTransactionController();
                int n2 = 2;
                this.uniqueIndexRow = new DataValueDescriptor[n2];
                this.uniqueIndexRow[0] = rowLocation;
                this.uniqueIndexRow[1] = rowLocation;
                Properties properties = this.makeIndexProperties(this.uniqueIndexRow, this.CID);
                this.uniqueIndexConglomId = transactionController.createConglomerate("BTREE", this.uniqueIndexRow, null, null, properties, 3);
                this.uniqueIndex_cc = transactionController.openConglomerate(this.uniqueIndexConglomId, false, 4, 7, 5);
                this.uniqueIndexCreated = true;
            }
            this.uniqueIndexRow[0] = rowLocation;
            this.uniqueIndexRow[1] = rowLocation;
            int n3 = this.uniqueIndex_cc.insert(this.uniqueIndexRow);
            if (n3 != 0 && n3 == 1) {
                return true;
            }
        }
        return false;
    }

    private void insertToPositionIndex(int n2, RowLocation rowLocation) throws StandardException {
        if (!this.positionIndexCreated) {
            TransactionController transactionController = this.activation.getTransactionController();
            int n3 = 2;
            this.position_sqllong = new SQLLongint();
            this.positionIndexRow = new DataValueDescriptor[n3];
            this.positionIndexRow[0] = this.position_sqllong;
            this.positionIndexRow[1] = rowLocation;
            Properties properties = this.makeIndexProperties(this.positionIndexRow, this.CID);
            this.positionIndexConglomId = transactionController.createConglomerate("BTREE", this.positionIndexRow, null, null, properties, 3);
            this.positionIndex_cc = transactionController.openConglomerate(this.positionIndexConglomId, false, 4, 7, 5);
            this.positionIndexCreated = true;
        }
        this.position_sqllong.setValue(n2);
        this.positionIndexRow[0] = this.position_sqllong;
        this.positionIndexRow[1] = rowLocation;
        this.positionIndex_cc.insert(this.positionIndexRow);
    }

    @Override
    public CursorResultSet getResultSet() {
        this.state = 2;
        TransactionController transactionController = this.activation.getTransactionController();
        if (this.isUniqueStream) {
            return new TemporaryRowHolderResultSet(transactionController, this.rowArray, this.resultDescription, this.isVirtualMemHeap, true, this.positionIndexConglomId, this);
        }
        return new TemporaryRowHolderResultSet(transactionController, this.rowArray, this.resultDescription, this.isVirtualMemHeap, this);
    }

    public void truncate() throws StandardException {
        this.close();
        for (int i2 = 0; i2 < this.rowArray.length; ++i2) {
            this.rowArray[i2] = null;
        }
        this.numRowsIn = 0;
    }

    @Override
    public long getTemporaryConglomId() {
        return this.CID;
    }

    @Override
    public long getPositionIndexConglomId() {
        return this.positionIndexConglomId;
    }

    private Properties makeIndexProperties(DataValueDescriptor[] dataValueDescriptorArray, long l2) throws StandardException {
        int n2 = dataValueDescriptorArray.length;
        Properties properties = new Properties();
        properties.put("allowDuplicates", "false");
        properties.put("nKeyFields", String.valueOf(n2));
        properties.put("nUniqueColumns", String.valueOf(n2 - 1));
        properties.put("rowLocationColumn", String.valueOf(n2 - 1));
        properties.put("baseConglomerateId", String.valueOf(l2));
        return properties;
    }

    @Override
    public void setRowHolderTypeToUniqueStream() {
        this.isUniqueStream = true;
    }

    @Override
    public void close() throws StandardException {
        if (this.scan != null) {
            this.scan.close();
            this.scan = null;
        }
        if (this.cc != null) {
            this.cc.close();
            this.cc = null;
        }
        if (this.uniqueIndex_cc != null) {
            this.uniqueIndex_cc.close();
            this.uniqueIndex_cc = null;
        }
        if (this.positionIndex_cc != null) {
            this.positionIndex_cc.close();
            this.positionIndex_cc = null;
        }
        TransactionController transactionController = this.activation.getTransactionController();
        if (this.uniqueIndexCreated) {
            transactionController.dropConglomerate(this.uniqueIndexConglomId);
            this.uniqueIndexCreated = false;
        }
        if (this.positionIndexCreated) {
            transactionController.dropConglomerate(this.positionIndexConglomId);
            this.positionIndexCreated = false;
        }
        if (this.conglomCreated) {
            transactionController.dropConglomerate(this.CID);
            this.conglomCreated = false;
            this.CID = 0L;
        }
        this.state = 0;
        this.lastArraySlot = -1;
    }
}

