/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.ScanResultSet;

class TableScanResultSet
extends ScanResultSet
implements Cloneable,
CursorResultSet {
    protected ScanController scanController;
    protected boolean scanControllerOpened;
    protected boolean isKeyed;
    protected boolean firstScan = true;
    protected ExecIndexRow startPosition;
    protected ExecIndexRow stopPosition;
    protected long conglomId;
    protected DynamicCompiledOpenConglomInfo dcoci;
    protected StaticCompiledOpenConglomInfo scoci;
    protected GeneratedMethod startKeyGetter;
    protected int startSearchOperator;
    protected GeneratedMethod stopKeyGetter;
    protected int stopSearchOperator;
    public Qualifier[][] qualifiers;
    public String userSuppliedOptimizerOverrides;
    protected boolean runTimeStatisticsOn;
    protected int[] indexCols;
    public int rowsPerRead;
    public boolean forUpdate;
    final boolean sameStartStopPosition;
    protected boolean nextDone;
    private RowLocation rlTemplate;
    private Properties scanProperties;
    public String startPositionString;
    public String stopPositionString;
    public boolean isConstraint;
    public boolean coarserLock;
    public boolean oneRowScan;
    protected long rowsThisScan;
    private long estimatedRowCount;
    protected BackingStoreHashtable past2FutureTbl;
    protected boolean qualify;
    protected boolean currentRowIsValid;
    protected boolean scanRepositioned;

    TableScanResultSet(long l2, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, Activation activation, int n2, int n3, GeneratedMethod generatedMethod, int n4, GeneratedMethod generatedMethod2, int n5, boolean bl2, Qualifier[][] qualifierArray, String string, String string2, String string3, boolean bl3, boolean bl4, int n6, int n7, int n8, boolean bl5, int n9, int n10, boolean bl6, double d2, double d3) throws StandardException {
        super(activation, n3, n2, n8, bl5, n9, n6, d2, d3);
        this.conglomId = l2;
        this.scoci = staticCompiledOpenConglomInfo;
        this.startKeyGetter = generatedMethod;
        this.startSearchOperator = n4;
        this.stopKeyGetter = generatedMethod2;
        this.stopSearchOperator = n5;
        this.sameStartStopPosition = bl2;
        this.qualifiers = qualifierArray;
        this.tableName = string;
        this.userSuppliedOptimizerOverrides = string2;
        this.indexName = string3;
        this.isConstraint = bl3;
        this.forUpdate = bl4;
        this.rowsPerRead = n10;
        this.oneRowScan = bl6;
        if (n7 != -1) {
            this.indexCols = (int[])activation.getPreparedStatement().getSavedObject(n7);
        }
        if (this.indexCols != null) {
            activation.setForUpdateIndexScan(this);
        }
        this.runTimeStatisticsOn = activation != null && activation.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.qualify = true;
        this.currentRowIsValid = false;
        this.scanRepositioned = false;
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        TransactionController transactionController = this.activation.getTransactionController();
        this.initIsolationLevel();
        if (this.dcoci == null) {
            this.dcoci = transactionController.getDynamicCompiledConglomInfo(this.conglomId);
        }
        this.initStartAndStopKey();
        if (this.firstScan) {
            this.openScanController(transactionController);
            this.isKeyed = this.scanController.isKeyed();
        }
        if (this.skipScan(this.startPosition, this.stopPosition)) {
            this.scanControllerOpened = false;
        } else if (!this.firstScan) {
            this.openScanController(transactionController);
        }
        if (this.forUpdate && this.isKeyed) {
            this.activation.setIndexScanController(this.scanController);
            this.activation.setIndexConglomerateNumber(this.conglomId);
        }
        this.firstScan = false;
        this.isOpen = true;
        ++this.numOpens;
        this.nextDone = false;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    void initStartAndStopKey() throws StandardException {
        if (this.startKeyGetter != null) {
            this.startPosition = (ExecIndexRow)this.startKeyGetter.invoke(this.activation);
            if (this.sameStartStopPosition) {
                this.stopPosition = this.startPosition;
            }
        }
        if (this.stopKeyGetter != null) {
            this.stopPosition = (ExecIndexRow)this.stopKeyGetter.invoke(this.activation);
        }
    }

    protected void openScanController(TransactionController transactionController) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray;
        DataValueDescriptor[] dataValueDescriptorArray2 = this.startPosition == null ? null : this.startPosition.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray3 = dataValueDescriptorArray = this.stopPosition == null ? null : this.stopPosition.getRowArray();
        if (this.qualifiers != null) {
            this.clearOrderableCache(this.qualifiers);
        }
        if (transactionController == null) {
            transactionController = this.activation.getTransactionController();
        }
        int n2 = 0;
        if (this.forUpdate) {
            n2 = 4;
            if (this.activation.isCursorActivation()) {
                n2 |= 0x1000;
            }
        }
        this.scanController = transactionController.openCompiledScan(this.activation.getResultSetHoldability(), n2, this.lockMode, this.isolationLevel, this.accessedCols, dataValueDescriptorArray2, this.startSearchOperator, this.qualifiers, dataValueDescriptorArray, this.stopSearchOperator, this.scoci, this.dcoci);
        this.scanControllerOpened = true;
        this.rowsThisScan = 0L;
        this.estimatedRowCount = this.scanController.getEstimatedRowCount();
        this.activation.informOfRowCount(this, this.scanController.getEstimatedRowCount());
    }

    protected void reopenScanController() throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = this.startPosition == null ? null : this.startPosition.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray2 = this.stopPosition == null ? null : this.stopPosition.getRowArray();
        this.rowsThisScan = 0L;
        if (this.qualifiers != null) {
            this.clearOrderableCache(this.qualifiers);
        }
        this.scanController.reopenScan(dataValueDescriptorArray, this.startSearchOperator, this.qualifiers, dataValueDescriptorArray2, this.stopSearchOperator);
        this.scanControllerOpened = true;
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.initStartAndStopKey();
        if (this.skipScan(this.startPosition, this.stopPosition)) {
            this.scanControllerOpened = false;
        } else if (this.scanController == null) {
            this.openScanController(null);
        } else {
            this.reopenScanController();
        }
        ++this.numOpens;
        this.nextDone = false;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    boolean loopControl(boolean bl2) throws StandardException {
        return this.scanController.fetchNext(this.candidate.getRowArray());
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        this.checkCancellationFlag();
        if (this.currentRow == null || this.scanRepositioned) {
            this.currentRow = this.getCompactRow(this.candidate, this.accessedCols, this.isKeyed);
        }
        this.beginTime = this.getCurrentTimeMillis();
        ExecRow execRow = null;
        if (this.isOpen && !this.nextDone) {
            this.nextDone = this.oneRowScan;
            if (this.scanControllerOpened) {
                boolean bl2 = true;
                while (bl2 = this.loopControl(bl2)) {
                    RowLocation rowLocation;
                    ++this.rowsSeen;
                    ++this.rowsThisScan;
                    if (!this.sameStartStopPosition && this.skipRow(this.candidate)) {
                        ++this.rowsFiltered;
                        continue;
                    }
                    if (this.past2FutureTbl != null && this.past2FutureTbl.remove(rowLocation = (RowLocation)this.currentRow.getColumn(this.currentRow.nColumns())) != null) continue;
                    execRow = this.currentRow;
                    break;
                }
                if (!bl2) {
                    this.setRowCountIfPossible(this.rowsThisScan);
                    this.currentRow = null;
                }
            }
        }
        this.setCurrentRow(execRow);
        this.currentRowIsValid = true;
        this.scanRepositioned = false;
        this.qualify = true;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            ConglomerateController conglomerateController;
            this.clearCurrentRow();
            if (this.scanController != null) {
                if (this.runTimeStatisticsOn) {
                    this.scanProperties = this.getScanProperties();
                    this.startPositionString = this.printStartPosition();
                    this.stopPositionString = this.printStopPosition();
                }
                this.scanController.close();
                this.scanController = null;
                if (this.forUpdate && this.isKeyed) {
                    this.activation.clearIndexScanInfo();
                }
            }
            this.scanControllerOpened = false;
            this.startPosition = null;
            this.stopPosition = null;
            super.close();
            if (this.indexCols != null && (conglomerateController = this.activation.getHeapConglomerateController()) != null) {
                conglomerateController.close();
                this.activation.clearHeapConglomerateController();
            }
            if (this.past2FutureTbl != null) {
                this.past2FutureTbl.close();
            }
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public long getTimeSpent(int n2) {
        long l2 = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n2 == 0) {
            return l2;
        }
        return l2;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        RowLocation rowLocation;
        if (!this.isOpen) {
            return null;
        }
        if (!this.scanControllerOpened) {
            return null;
        }
        if (this.isKeyed) {
            rowLocation = (RowLocation)this.currentRow.getColumn(this.currentRow.nColumns());
        } else if (this.currentRowIsValid) {
            if (this.rlTemplate == null) {
                this.rlTemplate = this.scanController.newRowLocationTemplate();
            }
            rowLocation = this.rlTemplate;
            try {
                this.scanController.fetchLocation(rowLocation);
            }
            catch (StandardException standardException) {
                if (standardException.getMessageId().equals("XSCH7.S")) {
                    throw StandardException.newException("24000", new Object[0]);
                }
                throw standardException;
            }
        } else {
            rowLocation = null;
        }
        return rowLocation;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        block6: {
            try {
                if (this.currentRow == null || !this.currentRowIsValid || !this.scanControllerOpened || this.qualify && this.scanController.isCurrentPositionDeleted() || this.qualify && !this.scanController.doesCurrentPositionQualify()) {
                    return null;
                }
            }
            catch (StandardException standardException) {
                if (!standardException.getMessageId().equals("XSAM5.S")) break block6;
                StandardException standardException2 = StandardException.newException("24000", new Object[0]);
                throw standardException2;
            }
        }
        this.resultRowBuilder.reset(this.candidate);
        this.currentRow = this.getCompactRow(this.candidate, this.accessedCols, this.isKeyed);
        try {
            this.scanController.fetchWithoutQualify(this.candidate.getRowArray());
        }
        catch (StandardException standardException) {
            if (standardException.getMessageId().equals("XSAM6.S")) {
                return null;
            }
            throw standardException;
        }
        this.setCurrentRow(this.candidate);
        return this.currentRow;
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rowLocation) throws StandardException {
        if (!this.isKeyed) {
            this.currentRowIsValid = this.scanController.positionAtRowLocation(rowLocation);
        }
        this.qualify = false;
        this.scanRepositioned = true;
    }

    public String printStartPosition() {
        return this.printPosition(this.startSearchOperator, this.startKeyGetter, this.startPosition);
    }

    public String printStopPosition() {
        if (this.sameStartStopPosition) {
            return this.printPosition(this.stopSearchOperator, this.startKeyGetter, this.startPosition);
        }
        return this.printPosition(this.stopSearchOperator, this.stopKeyGetter, this.stopPosition);
    }

    private String printPosition(int n2, GeneratedMethod generatedMethod, ExecIndexRow execIndexRow) {
        String string = "";
        if (generatedMethod == null) {
            return "\t" + MessageService.getTextMessage("42Z37.U", new Object[0]) + "\n";
        }
        if (execIndexRow == null) {
            if (this.numOpens == 0) {
                return "\t" + MessageService.getTextMessage("42Z38.U", new Object[0]) + "\n";
            }
            try {
                execIndexRow = (ExecIndexRow)generatedMethod.invoke(this.activation);
            }
            catch (StandardException standardException) {
                return "\t" + MessageService.getTextMessage("42Z39.U", standardException.toString());
            }
        }
        if (execIndexRow == null) {
            return "\t" + MessageService.getTextMessage("42Z37.U", new Object[0]) + "\n";
        }
        String string2 = null;
        switch (n2) {
            case 1: {
                string2 = ">=";
                break;
            }
            case -1: {
                string2 = ">";
                break;
            }
            default: {
                string2 = "unknown value (" + n2 + ")";
            }
        }
        string = string + "\t" + MessageService.getTextMessage("42Z40.U", string2, String.valueOf(execIndexRow.nColumns())) + "\n";
        string = string + "\t" + MessageService.getTextMessage("42Z41.U", new Object[0]) + "\n";
        boolean bl2 = false;
        for (int i2 = 0; i2 < execIndexRow.nColumns(); ++i2) {
            if (execIndexRow.areNullsOrdered(i2)) {
                string = string + i2 + " ";
                bl2 = true;
            }
            if (!bl2 || i2 != execIndexRow.nColumns() - 1) continue;
            string = string + "\n";
        }
        return string;
    }

    public Properties getScanProperties() {
        if (this.scanProperties == null) {
            this.scanProperties = new Properties();
        }
        try {
            if (this.scanController != null) {
                this.scanController.getScanInfo().getAllScanInfo(this.scanProperties);
                this.coarserLock = this.scanController.isTableLocked() && this.lockMode == 6;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return this.scanProperties;
    }

    @Override
    public boolean requiresRelocking() {
        return this.isolationLevel == 3;
    }

    protected final void setRowCountIfPossible(long l2) throws StandardException {
        if (!(this.scanController.isKeyed() || this.qualifiers != null && this.qualifiers.length != 0 || this.forUpdate)) {
            long l3 = l2 - this.estimatedRowCount;
            long l4 = this.estimatedRowCount / 10L;
            if (l3 < 0L) {
                l3 = -l3;
            }
            if (l3 > l4) {
                this.scanController.setEstimatedRowCount(l2);
            }
        }
    }

    @Override
    protected boolean canGetInstantaneousLocks() {
        return false;
    }

    @Override
    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }
}

