/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;

public class TablePrivilegeInfo
extends PrivilegeInfo {
    public static final int SELECT_ACTION = 0;
    public static final int DELETE_ACTION = 1;
    public static final int INSERT_ACTION = 2;
    public static final int UPDATE_ACTION = 3;
    public static final int REFERENCES_ACTION = 4;
    public static final int TRIGGER_ACTION = 5;
    public static final int ACTION_COUNT = 6;
    private static final String YES_WITH_GRANT_OPTION = "Y";
    private static final String YES_WITHOUT_GRANT_OPTION = "y";
    private static final String NO = "N";
    private static final String[][] actionString = new String[][]{{"s", "S"}, {"d", "D"}, {"i", "I"}, {"u", "U"}, {"r", "R"}, {"t", "T"}};
    private final TableDescriptor td;
    private final boolean[] actionAllowed;
    private final FormatableBitSet[] columnBitSets;
    private final List descriptorList;

    public TablePrivilegeInfo(TableDescriptor tableDescriptor, boolean[] blArray, FormatableBitSet[] formatableBitSetArray, List list) {
        this.actionAllowed = ArrayUtil.copy(blArray);
        this.columnBitSets = new FormatableBitSet[formatableBitSetArray.length];
        for (int i2 = 0; i2 < formatableBitSetArray.length; ++i2) {
            if (formatableBitSetArray[i2] == null) continue;
            this.columnBitSets[i2] = new FormatableBitSet(formatableBitSetArray[i2]);
        }
        this.td = tableDescriptor;
        this.descriptorList = list;
    }

    protected void checkOwnership(String string, TableDescriptor tableDescriptor, SchemaDescriptor schemaDescriptor, DataDictionary dataDictionary, LanguageConnectionContext languageConnectionContext, boolean bl2) throws StandardException {
        super.checkOwnership(string, tableDescriptor, schemaDescriptor, dataDictionary);
        if (bl2) {
            this.checkPrivileges(string, tableDescriptor, schemaDescriptor, dataDictionary, languageConnectionContext);
        }
    }

    private void checkPrivileges(String string, TableDescriptor tableDescriptor, SchemaDescriptor schemaDescriptor, DataDictionary dataDictionary, LanguageConnectionContext languageConnectionContext) throws StandardException {
        if (string.equals(dataDictionary.getAuthorizationDatabaseOwner())) {
            return;
        }
        if (tableDescriptor.getTableType() == 2 && this.descriptorList != null) {
            TransactionController transactionController = languageConnectionContext.getTransactionExecute();
            int n2 = this.descriptorList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                UniqueTupleDescriptor uniqueTupleDescriptor;
                SchemaDescriptor schemaDescriptor2 = null;
                TupleDescriptor tupleDescriptor = (TupleDescriptor)this.descriptorList.get(i2);
                if (tupleDescriptor instanceof TableDescriptor) {
                    uniqueTupleDescriptor = (TableDescriptor)tupleDescriptor;
                    schemaDescriptor2 = ((TableDescriptor)uniqueTupleDescriptor).getSchemaDescriptor();
                } else if (tupleDescriptor instanceof ViewDescriptor) {
                    uniqueTupleDescriptor = (ViewDescriptor)tupleDescriptor;
                    schemaDescriptor2 = dataDictionary.getSchemaDescriptor(((ViewDescriptor)uniqueTupleDescriptor).getCompSchemaId(), transactionController);
                } else if (tupleDescriptor instanceof AliasDescriptor) {
                    uniqueTupleDescriptor = (AliasDescriptor)tupleDescriptor;
                    schemaDescriptor2 = dataDictionary.getSchemaDescriptor(((AliasDescriptor)uniqueTupleDescriptor).getSchemaUUID(), transactionController);
                }
                if (schemaDescriptor2 == null || string.equals(schemaDescriptor2.getAuthorizationId())) continue;
                throw StandardException.newException("4250A", string, "grant", schemaDescriptor.getSchemaName(), tableDescriptor.getName());
            }
        }
    }

    @Override
    public void executeGrantRevoke(Activation activation, boolean bl2, List list) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        String string = languageConnectionContext.getCurrentUserId(activation);
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        SchemaDescriptor schemaDescriptor = this.td.getSchemaDescriptor();
        this.checkOwnership(string, this.td, schemaDescriptor, dataDictionary, languageConnectionContext, bl2);
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        TablePermsDescriptor tablePermsDescriptor = dataDescriptorGenerator.newTablePermsDescriptor(this.td, this.getPermString(0, false), this.getPermString(1, false), this.getPermString(2, false), this.getPermString(3, false), this.getPermString(4, false), this.getPermString(5, false), string);
        ColPermsDescriptor[] colPermsDescriptorArray = new ColPermsDescriptor[this.columnBitSets.length];
        for (int i2 = 0; i2 < this.columnBitSets.length; ++i2) {
            if (this.columnBitSets[i2] == null && (bl2 || !this.hasColumnPermissions(i2) || !this.actionAllowed[i2])) continue;
            colPermsDescriptorArray[i2] = dataDescriptorGenerator.newColPermsDescriptor(this.td, this.getActionString(i2, false), this.columnBitSets[i2], string);
        }
        dataDictionary.startWriting(languageConnectionContext);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl3 = false;
            String string2 = (String)iterator.next();
            if (tablePermsDescriptor != null && dataDictionary.addRemovePermissionsDescriptor(bl2, tablePermsDescriptor, string2, transactionController)) {
                bl3 = true;
                dataDictionary.getDependencyManager().invalidateFor(tablePermsDescriptor, 44, languageConnectionContext);
                dataDictionary.getDependencyManager().invalidateFor(this.td, 23, languageConnectionContext);
            }
            for (int i3 = 0; i3 < this.columnBitSets.length; ++i3) {
                if (colPermsDescriptorArray[i3] == null || !dataDictionary.addRemovePermissionsDescriptor(bl2, colPermsDescriptorArray[i3], string2, transactionController)) continue;
                bl3 = true;
                dataDictionary.getDependencyManager().invalidateFor(colPermsDescriptorArray[i3], 44, languageConnectionContext);
                dataDictionary.getDependencyManager().invalidateFor(this.td, 23, languageConnectionContext);
            }
            this.addWarningIfPrivilegeNotRevoked(activation, bl2, bl3, string2);
        }
    }

    private String getPermString(int n2, boolean bl2) {
        if (this.actionAllowed[n2] && this.columnBitSets[n2] == null) {
            return bl2 ? YES_WITH_GRANT_OPTION : YES_WITHOUT_GRANT_OPTION;
        }
        return NO;
    }

    private String getActionString(int n2, boolean bl2) {
        return actionString[n2][bl2 ? 1 : 0];
    }

    private boolean hasColumnPermissions(int n2) {
        return n2 == 0 || n2 == 3 || n2 == 4;
    }
}

