/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecRowBuilder;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

class SortResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public int rowsInput;
    public int rowsReturned;
    public boolean distinct;
    public NoPutResultSet source;
    private ColumnOrdering[] order;
    private ColumnOrdering[] savedOrder;
    private SortObserver observer;
    private ExecRow sortTemplateRow;
    public boolean isInSortedOrder;
    private NoPutResultSet originalSource;
    private int maxRowSize;
    private ScanController scanController;
    private ExecRow sortResultRow;
    private ExecRow currSortedRow;
    private boolean nextCalled;
    private int numColumns;
    private long genericSortId;
    private boolean dropGenericSort;
    private boolean sorted;
    public Properties sortProperties = new Properties();

    public SortResultSet(NoPutResultSet noPutResultSet, boolean bl2, boolean bl3, int n2, Activation activation, int n3, int n4, int n5, double d2, double d3) throws StandardException {
        super(activation, n5, d2, d3);
        this.distinct = bl2;
        this.isInSortedOrder = bl3;
        this.source = noPutResultSet;
        this.originalSource = noPutResultSet;
        this.maxRowSize = n4;
        ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
        this.sortTemplateRow = ((ExecRowBuilder)execPreparedStatement.getSavedObject(n3)).build(activation.getExecutionFactory());
        this.order = (ColumnOrdering[])((FormatableArrayHolder)execPreparedStatement.getSavedObject(n2)).getArray(ColumnOrdering[].class);
        this.savedOrder = this.order;
        this.observer = new BasicSortObserver(true, bl2, this.sortTemplateRow, true);
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.nextCalled = false;
        this.beginTime = this.getCurrentTimeMillis();
        this.order = this.savedOrder;
        this.sortResultRow = this.sortTemplateRow.getClone();
        this.source.openCore();
        try {
            if (this.isInSortedOrder && this.distinct) {
                this.currSortedRow = this.getNextRowFromRS();
                if (this.currSortedRow != null) {
                    this.currSortedRow = this.currSortedRow.getClone();
                }
            } else {
                this.scanController = this.loadSorter();
                this.sorted = true;
            }
        }
        catch (StandardException standardException) {
            this.isOpen = true;
            try {
                this.close();
            }
            catch (StandardException standardException2) {
                // empty catch block
            }
            throw standardException;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private ScanController loadSorter() throws StandardException {
        ExecRow execRow;
        boolean bl2 = this.order.length == 0 || this.isInSortedOrder;
        int n2 = (int)this.optimizerEstimatedRowCount;
        TransactionController transactionController = this.getTransactionController();
        long l2 = transactionController.createSort(null, this.sortTemplateRow.getRowArray(), this.order, this.observer, bl2, n2, this.maxRowSize);
        SortController sortController = transactionController.openSort(l2);
        this.genericSortId = l2;
        this.dropGenericSort = true;
        while ((execRow = this.getNextRowFromRS()) != null) {
            sortController.insert(execRow.getRowArray());
        }
        this.source.close();
        this.sortProperties = sortController.getSortInfo().getAllSortInfo(this.sortProperties);
        sortController.completedInserts();
        return transactionController.openSortScan(l2, this.activation.getResultSetHoldability());
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        if (!this.isOpen) {
            return null;
        }
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isInSortedOrder && this.distinct) {
            if (this.currSortedRow == null) {
                this.nextTime += this.getElapsedMillis(this.beginTime);
                return null;
            }
            if (!this.nextCalled) {
                this.nextCalled = true;
                this.numColumns = this.currSortedRow.getRowArray().length;
                this.nextTime += this.getElapsedMillis(this.beginTime);
                ++this.rowsReturned;
                this.setCurrentRow(this.currSortedRow);
                return this.currSortedRow;
            }
            ExecRow execRow = this.getNextRowFromRS();
            while (execRow != null) {
                if (!this.filterRow(this.currSortedRow, execRow)) {
                    this.currSortedRow = execRow.getClone();
                    this.setCurrentRow(this.currSortedRow);
                    this.nextTime += this.getElapsedMillis(this.beginTime);
                    ++this.rowsReturned;
                    return this.currSortedRow;
                }
                execRow = this.getNextRowFromRS();
            }
            this.currSortedRow = null;
            this.nextTime += this.getElapsedMillis(this.beginTime);
            return null;
        }
        ExecRow execRow = this.getNextRowFromRS();
        if (execRow != null) {
            this.setCurrentRow(execRow);
            ++this.rowsReturned;
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    private boolean filterRow(ExecRow execRow, ExecRow execRow2) throws StandardException {
        for (int i2 = 1; i2 <= this.numColumns; ++i2) {
            DataValueDescriptor dataValueDescriptor;
            DataValueDescriptor dataValueDescriptor2 = execRow.getColumn(i2);
            if (dataValueDescriptor2.compare(2, dataValueDescriptor = execRow2.getColumn(i2), true, true)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.sortResultRow = null;
            this.closeSource();
            if (this.dropGenericSort) {
                this.getTransactionController().dropSort(this.genericSortId);
                this.dropGenericSort = false;
            }
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
        this.isOpen = false;
    }

    @Override
    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    @Override
    public long getTimeSpent(int n2) {
        long l2 = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n2 == 0) {
            return l2 - this.originalSource.getTimeSpent(1);
        }
        return l2;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        RowLocation rowLocation = this.scanController.newRowLocationTemplate();
        this.scanController.fetchLocation(rowLocation);
        return rowLocation;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }

    private ExecRow getNextRowFromRS() throws StandardException {
        return this.scanController == null ? this.getRowFromResultSet() : this.getRowFromSorter();
    }

    private ExecRow getRowFromResultSet() throws StandardException {
        ExecRow execRow = this.source.getNextRowCore();
        if (execRow != null) {
            ++this.rowsInput;
        }
        return execRow;
    }

    private ExecRow getRowFromSorter() throws StandardException {
        ExecRow execRow = null;
        if (this.scanController.next()) {
            this.currentRow = this.sortResultRow;
            execRow = this.sortResultRow;
            this.scanController.fetch(execRow.getRowArray());
        }
        return execRow;
    }

    private void closeSource() throws StandardException {
        if (this.scanController == null) {
            this.source.close();
        } else {
            this.scanController.close();
            this.scanController = null;
        }
    }
}

