/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class SetConstraintsConstantAction
extends DDLConstantAction {
    private final boolean deferred;
    private final List<TableName> constraints;

    SetConstraintsConstantAction(List<TableName> list, boolean bl2) {
        this.constraints = list;
        this.deferred = bl2;
    }

    public String toString() {
        return "SET CONSTRAINTS";
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.constraints != null) {
            for (TableName tableName : this.constraints) {
                SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(tableName.getSchemaName(), languageConnectionContext.getTransactionExecute(), true);
                ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(tableName.getTableName(), schemaDescriptor.getUUID());
                if (constraintDescriptor == null) {
                    throw StandardException.newException("42X94", "CONSTRAINT", tableName.getFullSQLName());
                }
                String string = IdUtil.normalToDelimited(schemaDescriptor.getSchemaName()) + "." + IdUtil.normalToDelimited(constraintDescriptor.getConstraintName());
                if (arrayList.contains(string)) {
                    throw StandardException.newException("42734", constraintDescriptor.getConstraintName(), string);
                }
                arrayList.add(string);
                if (this.deferred && !constraintDescriptor.deferrable()) {
                    throw StandardException.newException("X0Y91.S", constraintDescriptor.getConstraintName());
                }
                languageConnectionContext.setConstraintDeferred(activation, constraintDescriptor, this.deferred);
            }
        } else {
            languageConnectionContext.setDeferredAll(activation, this.deferred);
        }
    }
}

